/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.contract.jaxws;

import com.sun.mirror.type.VoidType;
import com.sun.mirror.util.SourcePosition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.xml.namespace.QName;
import org.codehaus.enunciate.contract.jaxb.ImplicitChildElement;
import org.codehaus.enunciate.contract.jaxb.ImplicitRootElement;
import org.codehaus.enunciate.contract.jaxws.WebMessage;
import org.codehaus.enunciate.contract.jaxws.WebMessagePart;
import org.codehaus.enunciate.contract.jaxws.WebMethod;
import org.codehaus.enunciate.contract.jaxws.WebParam;
import org.codehaus.enunciate.contract.jaxws.WebResult;

public class ResponseWrapper
implements WebMessage,
WebMessagePart,
ImplicitRootElement {
    private WebMethod webMethod;

    public ResponseWrapper(WebMethod webMethod) {
        this.webMethod = webMethod;
    }

    @Override
    public WebMethod getWebMethod() {
        return this.webMethod;
    }

    public String getResponseBeanName() {
        String capitalizedName = this.webMethod.getSimpleName();
        capitalizedName = Character.toString(capitalizedName.charAt(0)).toUpperCase() + capitalizedName.substring(1);
        String responseBeanName = this.webMethod.getDeclaringEndpointInterface().getPackage().getQualifiedName() + ".jaxws." + capitalizedName + "Response";
        javax.xml.ws.ResponseWrapper annotation = (javax.xml.ws.ResponseWrapper)this.webMethod.getAnnotation(javax.xml.ws.ResponseWrapper.class);
        if (annotation != null && annotation.className() != null && !"".equals(annotation.className())) {
            responseBeanName = annotation.className();
        }
        return responseBeanName;
    }

    @Override
    public String getElementName() {
        String name = this.webMethod.getSimpleName() + "Response";
        javax.xml.ws.ResponseWrapper annotation = (javax.xml.ws.ResponseWrapper)this.webMethod.getAnnotation(javax.xml.ws.ResponseWrapper.class);
        if (annotation != null && annotation.localName() != null && !"".equals(annotation.localName())) {
            name = annotation.localName();
        }
        return name;
    }

    @Override
    public String getTargetNamespace() {
        return this.getElementNamespace();
    }

    public String getElementNamespace() {
        String namespace = this.webMethod.getDeclaringEndpointInterface().getTargetNamespace();
        javax.xml.ws.ResponseWrapper annotation = (javax.xml.ws.ResponseWrapper)this.webMethod.getAnnotation(javax.xml.ws.ResponseWrapper.class);
        if (annotation != null && annotation.targetNamespace() != null && !"".equals(annotation.targetNamespace())) {
            namespace = annotation.targetNamespace();
        }
        return namespace;
    }

    @Override
    public String getElementDocs() {
        String docs = "doc/lit response wrapper for operation \"" + this.webMethod.getOperationName() + "\".";
        String methodDocs = this.webMethod.getJavaDoc().toString();
        if (methodDocs.trim().length() > 0) {
            docs = docs + " (" + methodDocs.trim() + ")";
        }
        return docs;
    }

    @Override
    public WebMessagePart.ParticleType getParticleType() {
        return WebMessagePart.ParticleType.ELEMENT;
    }

    @Override
    public QName getParticleQName() {
        return new QName(this.getElementNamespace(), this.getElementName());
    }

    @Override
    public boolean isImplicitSchemaElement() {
        return true;
    }

    @Override
    public QName getTypeQName() {
        return null;
    }

    @Override
    public Collection<ImplicitChildElement> getChildElements() {
        WebResult webResult;
        ArrayList<ImplicitChildElement> childElements = new ArrayList<ImplicitChildElement>();
        if (!(this.webMethod.getReturnType() instanceof VoidType) && !(webResult = this.webMethod.getWebResult()).isHeader()) {
            childElements.add(webResult);
        }
        for (WebParam webParam : this.webMethod.getWebParameters()) {
            if (!webParam.isOutput() || webParam.isHeader()) continue;
            childElements.add(webParam);
        }
        return childElements;
    }

    @Override
    public Collection<WebMessagePart> getParts() {
        return new ArrayList<WebMessagePart>(Arrays.asList(this));
    }

    @Override
    public boolean isInput() {
        return false;
    }

    @Override
    public boolean isOutput() {
        return true;
    }

    @Override
    public boolean isHeader() {
        return false;
    }

    @Override
    public boolean isFault() {
        return false;
    }

    @Override
    public String getMessageName() {
        return this.webMethod.getDeclaringEndpointInterface().getSimpleName() + "." + this.webMethod.getSimpleName() + "Response";
    }

    @Override
    public String getMessageDocs() {
        String docs = "response message for operation \"" + this.webMethod.getOperationName() + "\".";
        String methodDocs = this.webMethod.getJavaDoc().toString();
        if (methodDocs.trim().length() > 0) {
            docs = docs + " (" + methodDocs.trim() + ")";
        }
        return docs;
    }

    @Override
    public String getPartDocs() {
        return null;
    }

    @Override
    public String getPartName() {
        return "parameters";
    }

    @Override
    public SourcePosition getPosition() {
        return this.webMethod.getPosition();
    }
}

