/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.contract.jaxws;

import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.EnumDeclaration;
import com.sun.mirror.declaration.InterfaceDeclaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.Modifier;
import com.sun.mirror.declaration.PackageDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.type.ClassType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import net.sf.jelly.apt.Context;
import net.sf.jelly.apt.decorations.declaration.DecoratedTypeDeclaration;
import org.codehaus.enunciate.ClientName;
import org.codehaus.enunciate.contract.jaxws.EndpointImplementation;
import org.codehaus.enunciate.contract.jaxws.WebMethod;
import org.codehaus.enunciate.contract.validation.ValidationException;
import org.codehaus.enunciate.soap.annotations.SoapBindingName;
import org.codehaus.enunciate.util.TypeDeclarationComparator;

public class EndpointInterface
extends DecoratedTypeDeclaration {
    private final WebService annotation;
    private final List<WebMethod> webMethods;
    private final Collection<EndpointImplementation> impls;
    private final Map<String, Object> metaData = new HashMap<String, Object>();

    /*
     * WARNING - void declaration
     */
    public EndpointInterface(TypeDeclaration delegate, TypeDeclaration ... implementationCandidates) {
        super(delegate);
        ClassType superclass;
        this.annotation = (WebService)this.getAnnotation(WebService.class);
        this.impls = new ArrayList<EndpointImplementation>();
        if (this.annotation != null) {
            if (this.isClass()) {
                this.impls.add(new EndpointImplementation((ClassDeclaration)this.getDelegate(), this));
            } else {
                TreeSet<TypeDeclaration> potentialImpls = new TreeSet<TypeDeclaration>(new TypeDeclarationComparator());
                potentialImpls.addAll(this.getAnnotationProcessorEnvironment().getTypeDeclarations());
                if (implementationCandidates != null) {
                    potentialImpls.addAll(Arrays.asList(implementationCandidates));
                }
                for (TypeDeclaration typeDeclaration : potentialImpls) {
                    if (!this.isEndpointImplementation(typeDeclaration)) continue;
                    WebService ws = (WebService)typeDeclaration.getAnnotation(WebService.class);
                    if (!this.getQualifiedName().equals(ws.endpointInterface())) continue;
                    this.impls.add(new EndpointImplementation((ClassDeclaration)typeDeclaration, this));
                }
            }
        }
        ArrayList<WebMethod> webMethods = new ArrayList<WebMethod>();
        for (MethodDeclaration methodDeclaration : this.getMethods()) {
            if (!this.isWebMethod(methodDeclaration)) continue;
            webMethods.add(new WebMethod(methodDeclaration, this));
        }
        if (this.isClass() && (superclass = ((ClassDeclaration)this.getDelegate()).getSuperclass()) != null) {
            void var5_9;
            ClassDeclaration classDeclaration = superclass.getDeclaration();
            while (var5_9 != null && !Object.class.getName().equals(var5_9.getQualifiedName())) {
                for (MethodDeclaration method : var5_9.getMethods()) {
                    if (!this.isWebMethod(method)) continue;
                    webMethods.add(new WebMethod(method, this));
                }
                superclass = var5_9.getSuperclass();
                if (superclass == null) {
                    Object var5_10 = null;
                    continue;
                }
                ClassDeclaration classDeclaration2 = superclass.getDeclaration();
            }
        }
        this.webMethods = webMethods;
    }

    public String getPortTypeName() {
        String name = null;
        if (this.annotation != null) {
            name = this.annotation.name();
        }
        if (name == null || "".equals(name)) {
            name = this.getSimpleName();
        }
        return name;
    }

    public String getServiceName() {
        WebService implAnnotation;
        String serviceName = null;
        if (this.annotation != null) {
            serviceName = this.annotation.serviceName();
        }
        if ((serviceName == null || "".equals(serviceName)) && this.getEndpointImplementations().size() == 1 && (implAnnotation = (WebService)this.getEndpointImplementations().iterator().next().getAnnotation(WebService.class)) != null) {
            serviceName = implAnnotation.serviceName();
        }
        if (serviceName == null || "".equals(serviceName)) {
            serviceName = this.getSimpleName() + "Service";
        }
        return serviceName;
    }

    public String getTargetNamespace() {
        String targetNamespace = null;
        if (this.annotation != null) {
            targetNamespace = this.annotation.targetNamespace();
        }
        if (targetNamespace == null || "".equals(targetNamespace)) {
            targetNamespace = this.calculateNamespaceURI();
        }
        return targetNamespace;
    }

    public String getClientSimpleName() {
        String clientSimpleName = this.getSimpleName();
        ClientName clientName = (ClientName)this.getAnnotation(ClientName.class);
        if (clientName != null) {
            clientSimpleName = clientName.value();
        }
        return clientSimpleName;
    }

    protected String calculateNamespaceURI() {
        PackageDeclaration pkg = this.getPackage();
        if (pkg == null || "".equals(pkg.getQualifiedName())) {
            throw new ValidationException(this.getPosition(), this.getQualifiedName() + ": a web service in no package must specify a target namespace.");
        }
        String[] tokens = pkg.getQualifiedName().split("\\.");
        String uri = "http://";
        for (int i = tokens.length - 1; i >= 0; --i) {
            uri = uri + tokens[i];
            if (i == 0) continue;
            uri = uri + ".";
        }
        uri = uri + "/";
        return uri;
    }

    public Set<String> getReferencedNamespaces() {
        HashSet<String> namespaces = new HashSet<String>();
        namespaces.add(this.getTargetNamespace());
        Collection<WebMethod> webMethods = this.getWebMethods();
        for (WebMethod webMethod : webMethods) {
            namespaces.addAll(webMethod.getReferencedNamespaces());
        }
        return namespaces;
    }

    public Collection<WebMethod> getWebMethods() {
        return this.webMethods;
    }

    public boolean isWebMethod(MethodDeclaration method) {
        boolean isWebMethod = method.getModifiers().contains(Modifier.PUBLIC);
        javax.jws.WebMethod annotation = (javax.jws.WebMethod)method.getAnnotation(javax.jws.WebMethod.class);
        if (annotation != null) {
            isWebMethod &= !annotation.exclude();
        }
        return isWebMethod;
    }

    public Collection<EndpointImplementation> getEndpointImplementations() {
        return this.impls;
    }

    protected boolean isEndpointImplementation(TypeDeclaration declaration) {
        if (declaration instanceof ClassDeclaration && !declaration.getQualifiedName().equals(this.getQualifiedName())) {
            WebService webServiceInfo = (WebService)declaration.getAnnotation(WebService.class);
            return webServiceInfo != null && this.getQualifiedName().equals(webServiceInfo.endpointInterface());
        }
        return false;
    }

    public SOAPBinding.Style getSoapBindingStyle() {
        SOAPBinding.Style style = SOAPBinding.Style.DOCUMENT;
        SOAPBinding bindingInfo = (SOAPBinding)this.getAnnotation(SOAPBinding.class);
        if (bindingInfo != null) {
            style = bindingInfo.style();
        }
        return style;
    }

    public String getSoapBindingName() {
        String name = this.getSimpleName() + "PortBinding";
        SoapBindingName bindingNameInfo = (SoapBindingName)this.getAnnotation(SoapBindingName.class);
        if (bindingNameInfo != null) {
            name = bindingNameInfo.value();
        }
        return name;
    }

    public SOAPBinding.Use getSoapUse() {
        SOAPBinding.Use use = SOAPBinding.Use.LITERAL;
        SOAPBinding bindingInfo = (SOAPBinding)this.getAnnotation(SOAPBinding.class);
        if (bindingInfo != null) {
            use = bindingInfo.use();
        }
        return use;
    }

    public SOAPBinding.ParameterStyle getSoapParameterStyle() {
        SOAPBinding.ParameterStyle style = SOAPBinding.ParameterStyle.WRAPPED;
        SOAPBinding bindingInfo = (SOAPBinding)this.getAnnotation(SOAPBinding.class);
        if (bindingInfo != null) {
            style = bindingInfo.parameterStyle();
        }
        return style;
    }

    public boolean isClass() {
        return this.getDelegate() instanceof ClassDeclaration;
    }

    public boolean isInterface() {
        return this.getDelegate() instanceof InterfaceDeclaration;
    }

    public boolean isEnum() {
        return this.getDelegate() instanceof EnumDeclaration;
    }

    public boolean isAnnotatedType() {
        return this.getDelegate() instanceof AnnotationTypeDeclaration;
    }

    public Map<String, Object> getMetaData() {
        return Collections.unmodifiableMap(this.metaData);
    }

    public void putMetaData(String name, Object data) {
        this.metaData.put(name, data);
    }

    protected AnnotationProcessorEnvironment getAnnotationProcessorEnvironment() {
        return Context.getCurrentEnvironment();
    }
}

