/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.contract.jaxrs;

import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.ParameterDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.type.DeclaredType;
import com.sun.mirror.type.TypeMirror;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.ws.rs.Path;
import net.sf.jelly.apt.Context;
import net.sf.jelly.apt.decorations.declaration.DecoratedMethodDeclaration;
import org.codehaus.enunciate.contract.jaxrs.Resource;
import org.codehaus.enunciate.contract.jaxrs.ResourceParameter;
import org.codehaus.enunciate.contract.jaxrs.SubResource;

public class SubResourceLocator
extends DecoratedMethodDeclaration {
    private final Path path;
    private final SubResource resource;
    private final Resource parent;
    private final List<ResourceParameter> resourceParameters;
    private final ParameterDeclaration entityParameter;

    public SubResourceLocator(MethodDeclaration delegate, Resource parent) {
        super(delegate);
        TypeDeclaration declaration;
        SubResource resource;
        this.parent = parent;
        this.path = (Path)delegate.getAnnotation(Path.class);
        if (this.path == null) {
            throw new IllegalArgumentException("A subresource locator must specify a path with the @javax.ws.rs.Path annotation.");
        }
        TypeMirror returnType = delegate.getReturnType();
        resource = returnType instanceof DeclaredType && ((DeclaredType)returnType).getDeclaration() != null ? ((resource = this.findRecursiveSubResource(declaration = ((DeclaredType)returnType).getDeclaration(), this.getPath())) == null ? new SubResource(declaration, this.getPath(), this) : resource) : new SubResource(Context.getCurrentEnvironment().getTypeDeclaration(Object.class.getName()), this.getPath(), this);
        this.resource = resource;
        ParameterDeclaration entityParameter = null;
        ArrayList<ResourceParameter> resourceParameters = new ArrayList<ResourceParameter>();
        for (ParameterDeclaration parameterDeclaration : delegate.getParameters()) {
            if (ResourceParameter.isResourceParameter((Declaration)parameterDeclaration)) {
                resourceParameters.add(new ResourceParameter((Declaration)parameterDeclaration));
                continue;
            }
            entityParameter = parameterDeclaration;
        }
        this.entityParameter = entityParameter;
        this.resourceParameters = resourceParameters;
    }

    private SubResource findRecursiveSubResource(TypeDeclaration declaration, String path) {
        LinkedList<SubResource> ancestorResources = SubResource.ANCESTOR_DECLARATIONS.get();
        for (SubResource ancestorResource : ancestorResources) {
            if (!ancestorResource.getQualifiedName().equals(declaration.getQualifiedName()) || !ancestorResource.getPath().equals(path)) continue;
            return ancestorResource;
        }
        return null;
    }

    public String getPath() {
        return this.path.value();
    }

    public SubResource getResource() {
        return this.resource;
    }

    public Resource getParent() {
        return this.parent;
    }

    public List<ResourceParameter> getResourceParameters() {
        ArrayList<ResourceParameter> resourceParams = new ArrayList<ResourceParameter>(this.resourceParameters);
        resourceParams.addAll(this.getParent().getResourceParameters());
        return resourceParams;
    }

    public ParameterDeclaration getEntityParameter() {
        return this.entityParameter;
    }
}

