/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.contract.jaxrs;

import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.ConstructorDeclaration;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.InterfaceDeclaration;
import com.sun.mirror.declaration.ParameterDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.Path;
import org.codehaus.enunciate.contract.jaxrs.Resource;
import org.codehaus.enunciate.contract.jaxrs.ResourceParameter;

public class RootResource
extends Resource {
    private final Path path;

    public RootResource(TypeDeclaration delegate) {
        super(delegate);
        this.path = (Path)delegate.getAnnotation(Path.class);
        if (this.path == null) {
            throw new IllegalArgumentException("A JAX-RS root resource must be annotated with @javax.ws.rs.Path.");
        }
    }

    @Override
    public String getPath() {
        return this.path.value();
    }

    @Override
    public Resource getParent() {
        return null;
    }

    public boolean isInterface() {
        return this.getDelegate() instanceof InterfaceDeclaration;
    }

    public boolean isClass() {
        return this.getDelegate() instanceof ClassDeclaration;
    }

    @Override
    protected List<ResourceParameter> getResourceParameters(TypeDeclaration delegate) {
        List<ResourceParameter> resourceParams = super.getResourceParameters(delegate);
        if (this.getDelegate() == delegate && delegate instanceof ClassDeclaration) {
            Collection constructors = ((ClassDeclaration)delegate).getConstructors();
            ConstructorDeclaration chosen = null;
            block0: for (ConstructorDeclaration constructor : constructors) {
                if (chosen != null && constructor.getParameters().size() <= chosen.getParameters().size()) continue;
                for (ParameterDeclaration param : constructor.getParameters()) {
                    if (ResourceParameter.isResourceParameter((Declaration)param)) continue;
                    continue block0;
                }
                chosen = constructor;
            }
            if (chosen != null) {
                for (ParameterDeclaration param : chosen.getParameters()) {
                    resourceParams.add(new ResourceParameter((Declaration)param));
                }
            }
        }
        return resourceParams;
    }
}

