/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.contract.jaxrs;

import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.FieldDeclaration;
import com.sun.mirror.declaration.ParameterDeclaration;
import com.sun.mirror.type.DeclaredType;
import com.sun.mirror.type.TypeMirror;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.CookieParam;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import net.sf.jelly.apt.decorations.DeclarationDecorator;
import net.sf.jelly.apt.decorations.declaration.DecoratedDeclaration;
import net.sf.jelly.apt.decorations.declaration.DecoratedTypeDeclaration;
import net.sf.jelly.apt.decorations.declaration.PropertyDeclaration;
import net.sf.jelly.apt.freemarker.FreemarkerModel;
import org.codehaus.enunciate.apt.EnunciateFreemarkerModel;
import org.codehaus.enunciate.config.EnunciateConfiguration;
import org.codehaus.enunciate.contract.jaxb.types.XmlType;
import org.codehaus.enunciate.contract.jaxb.types.XmlTypeException;
import org.codehaus.enunciate.contract.jaxb.types.XmlTypeFactory;

public class ResourceParameter
extends DecoratedDeclaration {
    public static final List<String> FORM_BEAN_ANNOTATIONS = Arrays.asList("org.jboss.resteasy.annotations.Form");
    private final String parameterName;
    private final String defaultValue;
    private final String typeName;
    private final XmlType xmlType;
    private final boolean matrixParam;
    private final boolean queryParam;
    private final boolean pathParam;
    private final boolean cookieParam;
    private final boolean headerParam;
    private final boolean formParam;

    public ResourceParameter(Declaration declaration) {
        super(declaration);
        FormParam formParam;
        HeaderParam headerParam;
        CookieParam cookieParam;
        PathParam pathParam;
        QueryParam queryParam;
        String parameterName = null;
        String typeName = null;
        boolean matrix = false;
        boolean query = false;
        boolean path = false;
        boolean cookie = false;
        boolean header = false;
        boolean form = false;
        MatrixParam matrixParam = (MatrixParam)declaration.getAnnotation(MatrixParam.class);
        if (matrixParam != null) {
            parameterName = matrixParam.value();
            typeName = "matrix";
            matrix = true;
        }
        if ((queryParam = (QueryParam)declaration.getAnnotation(QueryParam.class)) != null) {
            parameterName = queryParam.value();
            typeName = "query";
            query = true;
        }
        if ((pathParam = (PathParam)declaration.getAnnotation(PathParam.class)) != null) {
            parameterName = pathParam.value();
            typeName = "path";
            path = true;
        }
        if ((cookieParam = (CookieParam)declaration.getAnnotation(CookieParam.class)) != null) {
            parameterName = cookieParam.value();
            typeName = "cookie";
            cookie = true;
        }
        if ((headerParam = (HeaderParam)declaration.getAnnotation(HeaderParam.class)) != null) {
            parameterName = headerParam.value();
            typeName = "header";
            header = true;
        }
        if ((formParam = (FormParam)declaration.getAnnotation(FormParam.class)) != null) {
            parameterName = formParam.value();
            typeName = "form";
            form = true;
        }
        if (typeName == null) {
            for (AnnotationMirror annotation : declaration.getAnnotationMirrors()) {
                AnnotationTypeDeclaration decl = annotation.getAnnotationType().getDeclaration();
                if (decl == null) continue;
                String fqn = decl.getQualifiedName();
                EnunciateConfiguration config = ((EnunciateFreemarkerModel)FreemarkerModel.get()).getEnunciateConfig();
                if (config == null || !config.getCustomResourceParameterAnnotations().contains(fqn)) continue;
                parameterName = declaration.getSimpleName();
                typeName = decl.getSimpleName().toLowerCase().replaceAll("param", "");
                break;
            }
        }
        if (typeName == null) {
            typeName = "custom";
        }
        XmlType xmlType = null;
        if (declaration instanceof ParameterDeclaration) {
            try {
                xmlType = XmlTypeFactory.getXmlType(((ParameterDeclaration)declaration).getType());
            }
            catch (XmlTypeException e) {
                xmlType = null;
            }
        }
        this.parameterName = parameterName;
        this.matrixParam = matrix;
        this.queryParam = query;
        this.pathParam = path;
        this.cookieParam = cookie;
        this.headerParam = header;
        this.formParam = form;
        this.typeName = typeName;
        this.xmlType = xmlType;
        DefaultValue defaultValue = (DefaultValue)declaration.getAnnotation(DefaultValue.class);
        this.defaultValue = defaultValue != null ? defaultValue.value() : null;
    }

    public static boolean isResourceParameter(Declaration candidate) {
        for (AnnotationMirror annotation : candidate.getAnnotationMirrors()) {
            AnnotationTypeDeclaration declaration = annotation.getAnnotationType().getDeclaration();
            if (declaration == null) continue;
            String fqn = declaration.getQualifiedName();
            if (MatrixParam.class.getName().equals(fqn) || QueryParam.class.getName().equals(fqn) || PathParam.class.getName().equals(fqn) || CookieParam.class.getName().equals(fqn) || HeaderParam.class.getName().equals(fqn) || FormParam.class.getName().equals(fqn)) {
                return true;
            }
            EnunciateConfiguration config = ((EnunciateFreemarkerModel)FreemarkerModel.get()).getEnunciateConfig();
            if (config == null || !config.getCustomResourceParameterAnnotations().contains(fqn)) continue;
            return true;
        }
        return false;
    }

    public static boolean isFormBeanParameter(Declaration candidate) {
        for (AnnotationMirror annotation : candidate.getAnnotationMirrors()) {
            String fqn;
            AnnotationTypeDeclaration declaration = annotation.getAnnotationType().getDeclaration();
            if (declaration == null || !FORM_BEAN_ANNOTATIONS.contains(fqn = declaration.getQualifiedName())) continue;
            return true;
        }
        return false;
    }

    public static List<ResourceParameter> getFormBeanParameters(ParameterDeclaration parameterDeclaration) {
        ArrayList<ResourceParameter> formBeanParameters = new ArrayList<ResourceParameter>();
        ResourceParameter.gatherFormBeanParameters(parameterDeclaration.getType(), formBeanParameters);
        return formBeanParameters;
    }

    private static void gatherFormBeanParameters(TypeMirror type, ArrayList<ResourceParameter> formBeanParameters) {
        if (type instanceof DeclaredType) {
            DecoratedTypeDeclaration typeDeclaration = (DecoratedTypeDeclaration)DeclarationDecorator.decorate((Declaration)((DeclaredType)type).getDeclaration());
            for (FieldDeclaration field : typeDeclaration.getFields()) {
                if (ResourceParameter.isResourceParameter((Declaration)field)) {
                    formBeanParameters.add(new ResourceParameter((Declaration)field));
                    continue;
                }
                if (!ResourceParameter.isFormBeanParameter((Declaration)field)) continue;
                ResourceParameter.gatherFormBeanParameters(field.getType(), formBeanParameters);
            }
            for (PropertyDeclaration property : typeDeclaration.getProperties()) {
                if (ResourceParameter.isResourceParameter((Declaration)property)) {
                    formBeanParameters.add(new ResourceParameter((Declaration)property));
                    continue;
                }
                if (!ResourceParameter.isFormBeanParameter((Declaration)property)) continue;
                ResourceParameter.gatherFormBeanParameters(property.getPropertyType(), formBeanParameters);
            }
            if (typeDeclaration instanceof ClassDeclaration) {
                ResourceParameter.gatherFormBeanParameters((TypeMirror)((ClassDeclaration)typeDeclaration).getSuperclass(), formBeanParameters);
            }
        }
    }

    public String getParameterName() {
        return this.parameterName;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isMatrixParam() {
        return this.matrixParam;
    }

    public boolean isQueryParam() {
        return this.queryParam;
    }

    public boolean isPathParam() {
        return this.pathParam;
    }

    public boolean isCookieParam() {
        return this.cookieParam;
    }

    public boolean isHeaderParam() {
        return this.headerParam;
    }

    public boolean isFormParam() {
        return this.formParam;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public XmlType getXmlType() {
        return this.xmlType;
    }
}

