/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.contract.jaxrs;

import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.ParameterDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.type.DeclaredType;
import com.sun.mirror.type.MirroredTypeException;
import com.sun.mirror.type.TypeMirror;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.Consumes;
import javax.ws.rs.CookieParam;
import javax.ws.rs.HttpMethod;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import net.sf.jelly.apt.decorations.JavaDoc;
import net.sf.jelly.apt.decorations.TypeMirrorDecorator;
import net.sf.jelly.apt.decorations.declaration.DecoratedMethodDeclaration;
import net.sf.jelly.apt.decorations.type.DecoratedClassType;
import net.sf.jelly.apt.decorations.type.DecoratedTypeMirror;
import org.codehaus.enunciate.contract.jaxrs.ExplicitResourceParameter;
import org.codehaus.enunciate.contract.jaxrs.JAXRSUtils;
import org.codehaus.enunciate.contract.jaxrs.Resource;
import org.codehaus.enunciate.contract.jaxrs.ResourceEntityParameter;
import org.codehaus.enunciate.contract.jaxrs.ResourceMethodMediaType;
import org.codehaus.enunciate.contract.jaxrs.ResourceMethodSignature;
import org.codehaus.enunciate.contract.jaxrs.ResourceParameter;
import org.codehaus.enunciate.contract.jaxrs.ResourceParameterType;
import org.codehaus.enunciate.contract.jaxrs.ResourceRepresentationMetadata;
import org.codehaus.enunciate.contract.jaxrs.ResponseCode;
import org.codehaus.enunciate.contract.validation.ValidationException;
import org.codehaus.enunciate.jaxrs.ResponseHeaders;
import org.codehaus.enunciate.jaxrs.StatusCodes;
import org.codehaus.enunciate.jaxrs.TypeHint;
import org.codehaus.enunciate.jaxrs.Warnings;
import org.codehaus.enunciate.rest.MimeType;

public class ResourceMethod
extends DecoratedMethodDeclaration {
    private static final Pattern CONTEXT_PARAM_PATTERN = Pattern.compile("\\{([^\\}]+)\\}");
    private final String subpath;
    private final Set<String> httpMethods;
    private final Set<String> consumesMime;
    private final Set<String> producesMime;
    private final Resource parent;
    private final List<ResourceParameter> resourceParameters;
    private final ResourceEntityParameter entityParameter;
    private final List<ResourceEntityParameter> declaredEntityParameters;
    private final Map<String, Object> metaData = new HashMap<String, Object>();
    private final List<? extends ResponseCode> statusCodes;
    private final List<? extends ResponseCode> warnings;
    private final Map<String, String> responseHeaders = new HashMap<String, String>();
    private final ResourceRepresentationMetadata representationMetadata;

    public ResourceMethod(MethodDeclaration delegate, Resource parent) {
        super(delegate);
        ResponseHeaders responseHeaders;
        Warnings warningInfo;
        ResponseCode rc;
        ResourceRepresentationMetadata outputPayload;
        List<Object> resourceParameters;
        ResourceEntityParameter entityParameter;
        TreeSet<String> httpMethods = new TreeSet<String>();
        Collection mirrors = delegate.getAnnotationMirrors();
        for (AnnotationMirror mirror : mirrors) {
            AnnotationTypeDeclaration annotationDeclaration = mirror.getAnnotationType().getDeclaration();
            HttpMethod httpMethodInfo = (HttpMethod)annotationDeclaration.getAnnotation(HttpMethod.class);
            if (httpMethodInfo == null) continue;
            httpMethods.add(httpMethodInfo.value());
        }
        if (httpMethods.isEmpty()) {
            throw new IllegalStateException("A resource method must specify an HTTP method by using a request method designator annotation.");
        }
        this.httpMethods = httpMethods;
        Consumes consumesInfo = (Consumes)delegate.getAnnotation(Consumes.class);
        TreeSet<String> consumes = consumesInfo != null ? new TreeSet<String>(Arrays.asList(JAXRSUtils.value(consumesInfo))) : new TreeSet<String>(parent.getConsumesMime());
        this.consumesMime = consumes;
        Produces producesInfo = (Produces)delegate.getAnnotation(Produces.class);
        TreeSet<String> produces = producesInfo != null ? new TreeSet<String>(Arrays.asList(JAXRSUtils.value(producesInfo))) : new TreeSet<String>(parent.getProducesMime());
        this.producesMime = produces;
        String subpath = null;
        Path pathInfo = (Path)delegate.getAnnotation(Path.class);
        if (pathInfo != null) {
            subpath = pathInfo.value();
        }
        ArrayList<ResourceEntityParameter> declaredEntityParameters = new ArrayList<ResourceEntityParameter>();
        ResourceMethodSignature signatureOverride = (ResourceMethodSignature)delegate.getAnnotation(ResourceMethodSignature.class);
        if (signatureOverride == null) {
            DecoratedTypeMirror returnTypeMirror;
            AnnotationProcessorEnvironment env;
            entityParameter = null;
            resourceParameters = new ArrayList();
            for (ParameterDeclaration parameterDeclaration : this.getParameters()) {
                if (ResourceParameter.isResourceParameter((Declaration)parameterDeclaration)) {
                    resourceParameters.add((Object)new ResourceParameter((Declaration)parameterDeclaration));
                    continue;
                }
                if (ResourceParameter.isFormBeanParameter((Declaration)parameterDeclaration)) {
                    resourceParameters.addAll(ResourceParameter.getFormBeanParameters(parameterDeclaration));
                    continue;
                }
                if (parameterDeclaration.getAnnotation(Context.class) != null) continue;
                entityParameter = new ResourceEntityParameter(this, parameterDeclaration);
                declaredEntityParameters.add(entityParameter);
            }
            TypeHint hintInfo = (TypeHint)this.getAnnotation(TypeHint.class);
            if (hintInfo != null) {
                try {
                    Class hint = hintInfo.value();
                    env = net.sf.jelly.apt.Context.getCurrentEnvironment();
                    if (TypeHint.NO_CONTENT.class.equals((Object)hint)) {
                        returnTypeMirror = (DecoratedTypeMirror)TypeMirrorDecorator.decorate((TypeMirror)env.getTypeUtils().getVoidType());
                    } else {
                        String hintName = hint.getName();
                        if (TypeHint.NONE.class.equals((Object)hint)) {
                            hintName = hintInfo.qualifiedName();
                        }
                        if (!"##NONE".equals(hintName)) {
                            TypeDeclaration type = env.getTypeDeclaration(hintName);
                            returnTypeMirror = (DecoratedTypeMirror)TypeMirrorDecorator.decorate((TypeMirror)env.getTypeUtils().getDeclaredType(type, new TypeMirror[0]));
                        } else {
                            returnTypeMirror = (DecoratedTypeMirror)this.getReturnType();
                        }
                    }
                }
                catch (MirroredTypeException e) {
                    returnTypeMirror = (DecoratedTypeMirror)TypeMirrorDecorator.decorate((TypeMirror)e.getTypeMirror());
                }
                returnTypeMirror.setDocComment(((DecoratedTypeMirror)this.getReturnType()).getDocComment());
            } else {
                DecoratedTypeMirror responseType;
                DecoratedClassType jresponse;
                returnTypeMirror = (DecoratedTypeMirror)this.getReturnType();
                if (this.getJavaDoc().get((Object)"returnWrapped") != null) {
                    String fqn = (String)((JavaDoc.JavaDocTagList)this.getJavaDoc().get((Object)"returnWrapped")).get(0);
                    env = net.sf.jelly.apt.Context.getCurrentEnvironment();
                    TypeDeclaration type = env.getTypeDeclaration(fqn);
                    if (type != null) {
                        returnTypeMirror = (DecoratedTypeMirror)TypeMirrorDecorator.decorate((TypeMirror)env.getTypeUtils().getDeclaredType(type, new TypeMirror[0]));
                    }
                }
                if (returnTypeMirror.isClass() && returnTypeMirror.isInstanceOf("com.sun.jersey.api.JResponse") && !(jresponse = (DecoratedClassType)returnTypeMirror).getActualTypeArguments().isEmpty() && (responseType = (DecoratedTypeMirror)TypeMirrorDecorator.decorate((TypeMirror)((TypeMirror)jresponse.getActualTypeArguments().iterator().next()))).isDeclared()) {
                    responseType.setDocComment(returnTypeMirror.getDocComment());
                    returnTypeMirror = responseType;
                }
            }
            outputPayload = returnTypeMirror.isVoid() ? null : new ResourceRepresentationMetadata(returnTypeMirror);
        } else {
            entityParameter = this.loadEntityParameter(signatureOverride);
            declaredEntityParameters.add(entityParameter);
            resourceParameters = this.loadResourceParameters(signatureOverride);
            outputPayload = this.loadOutputPayload(signatureOverride);
        }
        JavaDoc.JavaDocTagList doclets = (JavaDoc.JavaDocTagList)this.getJavaDoc().get((Object)"RequestHeader");
        if (doclets != null) {
            for (String doclet : doclets) {
                int firstspace = doclet.indexOf(32);
                String header = firstspace > 0 ? doclet.substring(0, firstspace) : doclet;
                String doc = firstspace > 0 && firstspace + 1 < doclet.length() ? doclet.substring(firstspace + 1) : "";
                resourceParameters.add((Object)new ExplicitResourceParameter(this, doc, header, ResourceParameterType.HEADER));
            }
        }
        ArrayList<? extends ResponseCode> statusCodes = new ArrayList<ResponseCode>();
        ArrayList<? extends ResponseCode> warnings = new ArrayList<ResponseCode>();
        StatusCodes codes = (StatusCodes)this.getAnnotation(StatusCodes.class);
        if (codes != null) {
            for (Object code : codes.value()) {
                ResponseCode rc2 = new ResponseCode();
                rc2.setCode(code.code());
                rc2.setCondition(code.condition());
                statusCodes.add(rc2);
            }
        }
        if ((doclets = (JavaDoc.JavaDocTagList)this.getJavaDoc().get((Object)"HTTP")) != null) {
            for (String doclet : doclets) {
                Object code;
                int firstspace = doclet.indexOf(32);
                code = firstspace > 0 ? doclet.substring(0, firstspace) : doclet;
                String doc = firstspace > 0 && firstspace + 1 < doclet.length() ? doclet.substring(firstspace + 1) : "";
                try {
                    rc = new ResponseCode();
                    rc.setCode(Integer.parseInt((String)code));
                    rc.setCondition(doc);
                    statusCodes.add(rc);
                }
                catch (NumberFormatException e) {}
            }
        }
        if ((warningInfo = (Warnings)this.getAnnotation(Warnings.class)) != null) {
            for (org.codehaus.enunciate.jaxrs.ResponseCode code : warningInfo.value()) {
                rc = new ResponseCode();
                rc.setCode(code.code());
                rc.setCondition(code.condition());
                warnings.add(rc);
            }
        }
        if ((codes = (StatusCodes)parent.getAnnotation(StatusCodes.class)) != null) {
            for (org.codehaus.enunciate.jaxrs.ResponseCode code : codes.value()) {
                rc = new ResponseCode();
                rc.setCode(code.code());
                rc.setCondition(code.condition());
                statusCodes.add(rc);
            }
        }
        if ((warningInfo = (Warnings)parent.getAnnotation(Warnings.class)) != null) {
            for (org.codehaus.enunciate.jaxrs.ResponseCode code : warningInfo.value()) {
                rc = new ResponseCode();
                rc.setCode(code.code());
                rc.setCondition(code.condition());
                warnings.add(rc);
            }
        }
        if ((responseHeaders = (ResponseHeaders)parent.getAnnotation(ResponseHeaders.class)) != null) {
            for (Object header : responseHeaders.value()) {
                this.responseHeaders.put(header.name(), header.description());
            }
        }
        if ((responseHeaders = (ResponseHeaders)this.getAnnotation(ResponseHeaders.class)) != null) {
            for (Object header : responseHeaders.value()) {
                this.responseHeaders.put(header.name(), header.description());
            }
        }
        if ((doclets = (JavaDoc.JavaDocTagList)this.getJavaDoc().get((Object)"ResponseHeader")) != null) {
            for (String doclet : doclets) {
                Object header;
                int firstspace = doclet.indexOf(32);
                header = firstspace > 0 ? doclet.substring(0, firstspace) : doclet;
                String doc = firstspace > 0 && firstspace + 1 < doclet.length() ? doclet.substring(firstspace + 1) : "";
                this.responseHeaders.put((String)header, doc);
            }
        }
        this.entityParameter = entityParameter;
        this.resourceParameters = resourceParameters;
        this.subpath = subpath;
        this.parent = parent;
        this.statusCodes = statusCodes;
        this.warnings = warnings;
        this.representationMetadata = outputPayload;
        this.declaredEntityParameters = declaredEntityParameters;
    }

    protected ResourceRepresentationMetadata loadOutputPayload(ResourceMethodSignature signatureOverride) {
        DecoratedTypeMirror returnType = (DecoratedTypeMirror)this.getReturnType();
        try {
            Class<?> outputType = signatureOverride.output();
            if (outputType != ResourceMethodSignature.NONE.class) {
                AnnotationProcessorEnvironment env = net.sf.jelly.apt.Context.getCurrentEnvironment();
                TypeDeclaration type = env.getTypeDeclaration(outputType.getName());
                return new ResourceRepresentationMetadata((TypeMirror)env.getTypeUtils().getDeclaredType(type, new TypeMirror[0]), returnType.getDocValue());
            }
        }
        catch (MirroredTypeException e) {
            DecoratedTypeMirror typeMirror = (DecoratedTypeMirror)TypeMirrorDecorator.decorate((TypeMirror)e.getTypeMirror());
            if (typeMirror.isDeclared()) {
                if (typeMirror.isInstanceOf(ResourceMethodSignature.class.getName() + ".NONE")) {
                    return null;
                }
                return new ResourceRepresentationMetadata((TypeMirror)typeMirror, returnType.getDocValue());
            }
            throw new ValidationException(this.getPosition(), "Illegal output type (must be a declared type): " + typeMirror);
        }
        return null;
    }

    protected List<ResourceParameter> loadResourceParameters(ResourceMethodSignature signatureOverride) {
        HashMap paramComments = ResourceMethod.parseParamComments((JavaDoc)this.getJavaDoc());
        ArrayList<ResourceParameter> params = new ArrayList<ResourceParameter>();
        for (CookieParam cookieParam : signatureOverride.cookieParams()) {
            params.add(new ExplicitResourceParameter(this, (String)paramComments.get(cookieParam.value()), cookieParam.value(), ResourceParameterType.COOKIE));
        }
        for (CookieParam cookieParam : signatureOverride.matrixParams()) {
            params.add(new ExplicitResourceParameter(this, (String)paramComments.get(cookieParam.value()), cookieParam.value(), ResourceParameterType.MATRIX));
        }
        for (CookieParam cookieParam : signatureOverride.queryParams()) {
            params.add(new ExplicitResourceParameter(this, (String)paramComments.get(cookieParam.value()), cookieParam.value(), ResourceParameterType.QUERY));
        }
        for (CookieParam cookieParam : signatureOverride.pathParams()) {
            params.add(new ExplicitResourceParameter(this, (String)paramComments.get(cookieParam.value()), cookieParam.value(), ResourceParameterType.PATH));
        }
        for (CookieParam cookieParam : signatureOverride.headerParams()) {
            params.add(new ExplicitResourceParameter(this, (String)paramComments.get(cookieParam.value()), cookieParam.value(), ResourceParameterType.HEADER));
        }
        for (CookieParam cookieParam : signatureOverride.formParams()) {
            params.add(new ExplicitResourceParameter(this, (String)paramComments.get(cookieParam.value()), cookieParam.value(), ResourceParameterType.FORM));
        }
        return params;
    }

    protected ResourceEntityParameter loadEntityParameter(ResourceMethodSignature signatureOverride) {
        try {
            Class<?> entityType = signatureOverride.input();
            if (entityType != ResourceMethodSignature.NONE.class) {
                AnnotationProcessorEnvironment env = net.sf.jelly.apt.Context.getCurrentEnvironment();
                TypeDeclaration type = env.getTypeDeclaration(entityType.getName());
                return new ResourceEntityParameter((Declaration)type, (TypeMirror)env.getTypeUtils().getDeclaredType(type, new TypeMirror[0]));
            }
        }
        catch (MirroredTypeException e) {
            DecoratedTypeMirror typeMirror = (DecoratedTypeMirror)TypeMirrorDecorator.decorate((TypeMirror)e.getTypeMirror());
            if (typeMirror.isDeclared()) {
                if (typeMirror.isInstanceOf(ResourceMethodSignature.class.getName() + ".NONE")) {
                    return null;
                }
                return new ResourceEntityParameter((Declaration)((DeclaredType)typeMirror).getDeclaration(), (TypeMirror)typeMirror);
            }
            throw new ValidationException(this.getPosition(), "Illegal input type (must be a declared type): " + typeMirror);
        }
        return null;
    }

    public Set<String> getHttpMethods() {
        return this.httpMethods;
    }

    public String getFullpath() {
        ArrayList<String> subpaths = new ArrayList<String>();
        if (this.getSubpath() != null) {
            subpaths.add(0, this.getSubpath());
        }
        for (Resource parent = this.getParent(); parent != null; parent = parent.getParent()) {
            subpaths.add(0, parent.getPath());
        }
        StringBuilder builder = new StringBuilder();
        for (String subpath : subpaths) {
            if (!(subpath = subpath.trim()).startsWith("/")) {
                subpath = '/' + subpath;
            }
            while (subpath.endsWith("/")) {
                subpath = subpath.substring(0, subpath.length() - 1);
            }
            subpath = ResourceMethod.scrubParamNames(subpath);
            builder.append(subpath);
        }
        return builder.toString();
    }

    public String getServletPattern() {
        StringBuilder builder = new StringBuilder();
        String fullPath = this.getFullpath();
        Matcher pathParamMatcher = CONTEXT_PARAM_PATTERN.matcher(fullPath);
        if (pathParamMatcher.find()) {
            builder.append(fullPath, 0, pathParamMatcher.start()).append("*");
        } else {
            builder.append(fullPath);
        }
        return builder.toString();
    }

    protected static String scrubParamNames(String subpath) {
        StringBuilder builder = new StringBuilder(subpath.length());
        int charIndex = 0;
        int inBrace = 0;
        boolean definingRegexp = false;
        while (charIndex < subpath.length()) {
            char ch;
            if ((ch = subpath.charAt(charIndex++)) == '{') {
                ++inBrace;
            } else if (ch == '}') {
                if (--inBrace == 0) {
                    definingRegexp = false;
                }
            } else if (inBrace == 1 && ch == ':') {
                definingRegexp = true;
            }
            if (definingRegexp) continue;
            builder.append(ch);
        }
        return builder.toString();
    }

    public String getSubpath() {
        return this.subpath;
    }

    public Resource getParent() {
        return this.parent;
    }

    public Set<String> getConsumesMime() {
        return this.consumesMime;
    }

    public Set<String> getProducesMime() {
        return this.producesMime;
    }

    public List<ResourceParameter> getResourceParameters() {
        ArrayList<ResourceParameter> resourceParams = new ArrayList<ResourceParameter>(this.resourceParameters);
        resourceParams.addAll(this.getParent().getResourceParameters());
        return resourceParams;
    }

    public ResourceEntityParameter getEntityParameter() {
        return this.entityParameter;
    }

    public List<ResourceEntityParameter> getDeclaredEntityParameters() {
        return this.declaredEntityParameters;
    }

    public List<ResourceMethodMediaType> getApplicableMediaTypes() {
        ResourceMethodMediaType supportedType;
        String type;
        HashMap<String, ResourceMethodMediaType> applicableTypes = new HashMap<String, ResourceMethodMediaType>();
        for (String consumesMime : this.getConsumesMime()) {
            try {
                type = MimeType.parse((String)consumesMime).toString();
            }
            catch (Exception e) {
                type = consumesMime;
            }
            supportedType = (ResourceMethodMediaType)applicableTypes.get(type);
            if (supportedType == null) {
                supportedType = new ResourceMethodMediaType();
                supportedType.setType(type);
                applicableTypes.put(type, supportedType);
            }
            supportedType.setConsumable(true);
        }
        for (String producesMime : this.getProducesMime()) {
            try {
                type = MimeType.parse((String)producesMime).toString();
            }
            catch (Exception e) {
                type = producesMime;
            }
            supportedType = (ResourceMethodMediaType)applicableTypes.get(type);
            if (supportedType == null) {
                supportedType = new ResourceMethodMediaType();
                supportedType.setType(type);
                applicableTypes.put(type, supportedType);
            }
            supportedType.setProduceable(true);
        }
        return new ArrayList<ResourceMethodMediaType>(applicableTypes.values());
    }

    public ResourceRepresentationMetadata getRepresentationMetadata() {
        return this.representationMetadata;
    }

    public List<? extends ResponseCode> getStatusCodes() {
        return this.statusCodes;
    }

    public List<? extends ResponseCode> getWarnings() {
        return this.warnings;
    }

    public Map<String, Object> getMetaData() {
        return Collections.unmodifiableMap(this.metaData);
    }

    public void putMetaData(String name, Object data) {
        this.metaData.put(name, data);
    }

    public Map<String, String> getResponseHeaders() {
        return this.responseHeaders;
    }
}

