/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.contract.jaxrs;

import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.FieldDeclaration;
import com.sun.mirror.declaration.MemberDeclaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.Modifier;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.type.ClassType;
import com.sun.mirror.type.InterfaceType;
import com.sun.mirror.util.Declarations;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import javax.ws.rs.Consumes;
import javax.ws.rs.HttpMethod;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import net.sf.jelly.apt.Context;
import net.sf.jelly.apt.decorations.DeclarationDecorator;
import net.sf.jelly.apt.decorations.declaration.DecoratedDeclaration;
import net.sf.jelly.apt.decorations.declaration.DecoratedTypeDeclaration;
import net.sf.jelly.apt.decorations.declaration.PropertyDeclaration;
import org.codehaus.enunciate.contract.jaxrs.JAXRSUtils;
import org.codehaus.enunciate.contract.jaxrs.ResourceMethod;
import org.codehaus.enunciate.contract.jaxrs.ResourceParameter;
import org.codehaus.enunciate.contract.jaxrs.SubResourceLocator;

public abstract class Resource
extends DecoratedTypeDeclaration {
    private final Set<String> consumesMime;
    private final Set<String> producesMime;
    private final List<ResourceParameter> resourceParameters;
    private final List<ResourceMethod> resourceMethods;
    private final List<SubResourceLocator> resourceLocators;

    public Resource(TypeDeclaration delegate) {
        super(delegate);
        TreeSet<String> consumes = new TreeSet<String>();
        Consumes consumesInfo = (Consumes)delegate.getAnnotation(Consumes.class);
        if (consumesInfo != null) {
            consumes.addAll(Arrays.asList(JAXRSUtils.value(consumesInfo)));
        } else {
            consumes.add("*/*");
        }
        this.consumesMime = Collections.unmodifiableSet(consumes);
        TreeSet<String> produces = new TreeSet<String>();
        Produces producesInfo = (Produces)delegate.getAnnotation(Produces.class);
        if (producesInfo != null) {
            produces.addAll(Arrays.asList(JAXRSUtils.value(producesInfo)));
        } else {
            produces.add("*/*");
        }
        this.producesMime = Collections.unmodifiableSet(produces);
        this.resourceParameters = Collections.unmodifiableList(this.getResourceParameters(delegate));
        this.resourceMethods = Collections.unmodifiableList(this.getResourceMethods(delegate));
        this.resourceLocators = Collections.unmodifiableList(this.getSubresourceLocators(delegate));
    }

    protected List<SubResourceLocator> getSubresourceLocators(TypeDeclaration delegate) {
        ClassType superclass;
        if (delegate == null || delegate.getQualifiedName().equals(Object.class.getName())) {
            return Collections.emptyList();
        }
        ArrayList<SubResourceLocator> resourceLocators = new ArrayList<SubResourceLocator>();
        block0: for (MethodDeclaration methodDeclaration : delegate.getMethods()) {
            if (methodDeclaration.getAnnotation(Path.class) == null) continue;
            for (AnnotationMirror annotation : methodDeclaration.getAnnotationMirrors()) {
                AnnotationTypeDeclaration annotationDeclaration = annotation.getAnnotationType().getDeclaration();
                if (annotationDeclaration == null || annotationDeclaration.getAnnotation(HttpMethod.class) == null) continue;
                continue block0;
            }
            resourceLocators.add(new SubResourceLocator(methodDeclaration, this));
        }
        for (InterfaceType interfaceType : delegate.getSuperinterfaces()) {
            List<SubResourceLocator> interfaceMethods = this.getSubresourceLocators((TypeDeclaration)interfaceType.getDeclaration());
            for (SubResourceLocator interfaceMethod : interfaceMethods) {
                if (this.isOverridden((DecoratedDeclaration)interfaceMethod, resourceLocators)) continue;
                resourceLocators.add(interfaceMethod);
            }
        }
        if (delegate instanceof ClassDeclaration && (superclass = ((ClassDeclaration)delegate).getSuperclass()) != null && superclass.getDeclaration() != null) {
            List<SubResourceLocator> superMethods = this.getSubresourceLocators((TypeDeclaration)superclass.getDeclaration());
            for (SubResourceLocator superMethod : superMethods) {
                if (this.isOverridden((DecoratedDeclaration)superMethod, resourceLocators)) continue;
                resourceLocators.add(superMethod);
            }
        }
        return resourceLocators;
    }

    protected List<ResourceMethod> getResourceMethods(TypeDeclaration delegate) {
        ClassType superclass;
        if (delegate == null || delegate.getQualifiedName().equals(Object.class.getName())) {
            return Collections.emptyList();
        }
        ArrayList<ResourceMethod> resourceMethods = new ArrayList<ResourceMethod>();
        block0: for (MethodDeclaration methodDeclaration : delegate.getMethods()) {
            if (!methodDeclaration.getModifiers().contains(Modifier.PUBLIC)) continue;
            for (AnnotationMirror annotation : methodDeclaration.getAnnotationMirrors()) {
                AnnotationTypeDeclaration annotationDeclaration = annotation.getAnnotationType().getDeclaration();
                if (annotationDeclaration == null || annotationDeclaration.getAnnotation(HttpMethod.class) == null) continue;
                resourceMethods.add(new ResourceMethod(methodDeclaration, this));
                continue block0;
            }
        }
        for (InterfaceType interfaceType : delegate.getSuperinterfaces()) {
            List<ResourceMethod> interfaceMethods = this.getResourceMethods((TypeDeclaration)interfaceType.getDeclaration());
            for (ResourceMethod interfaceMethod : interfaceMethods) {
                if (this.isOverridden((DecoratedDeclaration)interfaceMethod, resourceMethods)) continue;
                resourceMethods.add(interfaceMethod);
            }
        }
        if (delegate instanceof ClassDeclaration && (superclass = ((ClassDeclaration)delegate).getSuperclass()) != null && superclass.getDeclaration() != null) {
            List<ResourceMethod> superMethods = this.getResourceMethods((TypeDeclaration)superclass.getDeclaration());
            for (ResourceMethod superMethod : superMethods) {
                if (this.isOverridden((DecoratedDeclaration)superMethod, resourceMethods)) continue;
                resourceMethods.add(superMethod);
            }
        }
        return resourceMethods;
    }

    protected List<ResourceParameter> getResourceParameters(TypeDeclaration delegate) {
        if (delegate == null || delegate.getQualifiedName().equals(Object.class.getName())) {
            return Collections.emptyList();
        }
        ArrayList<ResourceParameter> resourceParameters = new ArrayList<ResourceParameter>();
        DecoratedTypeDeclaration decorated = (DecoratedTypeDeclaration)DeclarationDecorator.decorate((Declaration)delegate);
        for (FieldDeclaration field : decorated.getFields()) {
            if (!ResourceParameter.isResourceParameter((Declaration)field)) continue;
            resourceParameters.add(new ResourceParameter((Declaration)field));
        }
        for (PropertyDeclaration property : decorated.getProperties()) {
            if (!ResourceParameter.isResourceParameter((Declaration)property)) continue;
            resourceParameters.add(new ResourceParameter((Declaration)property));
        }
        if (delegate instanceof ClassDeclaration) {
            List<ResourceParameter> superParams = this.getResourceParameters((TypeDeclaration)((ClassDeclaration)delegate).getSuperclass().getDeclaration());
            for (ResourceParameter superParam : superParams) {
                if (this.isHidden(superParam, resourceParameters)) continue;
                resourceParameters.add(superParam);
            }
        }
        return resourceParameters;
    }

    protected boolean isOverridden(DecoratedDeclaration method, ArrayList<? extends DecoratedDeclaration> resourceMethods) {
        AnnotationProcessorEnvironment env = Context.getCurrentEnvironment();
        Declarations decls = env.getDeclarationUtils();
        Declaration unwrappedMethod = method.getDelegate();
        while (unwrappedMethod instanceof DecoratedDeclaration) {
            unwrappedMethod = ((DecoratedDeclaration)unwrappedMethod).getDelegate();
        }
        for (DecoratedDeclaration decoratedDeclaration : resourceMethods) {
            Declaration candidate = decoratedDeclaration.getDelegate();
            while (candidate instanceof DecoratedDeclaration) {
                candidate = ((DecoratedDeclaration)candidate).getDelegate();
            }
            if (!decls.overrides((MethodDeclaration)candidate, (MethodDeclaration)unwrappedMethod)) continue;
            return true;
        }
        return false;
    }

    private boolean isHidden(ResourceParameter param, List<ResourceParameter> resourceParameters) {
        AnnotationProcessorEnvironment env = Context.getCurrentEnvironment();
        Declarations decls = env.getDeclarationUtils();
        Declaration unwrappedParam = param.getDelegate();
        while (unwrappedParam instanceof DecoratedDeclaration) {
            unwrappedParam = ((DecoratedDeclaration)unwrappedParam).getDelegate();
        }
        for (ResourceParameter resourceParameter : resourceParameters) {
            Declaration candidate = resourceParameter.getDelegate();
            while (candidate instanceof DecoratedDeclaration) {
                candidate = ((DecoratedDeclaration)candidate).getDelegate();
            }
            if (!decls.hides((MemberDeclaration)candidate, (MemberDeclaration)unwrappedParam)) continue;
            return true;
        }
        return false;
    }

    public abstract String getPath();

    public abstract Resource getParent();

    public Set<String> getConsumesMime() {
        return this.consumesMime;
    }

    public Set<String> getProducesMime() {
        return this.producesMime;
    }

    public List<ResourceParameter> getResourceParameters() {
        return this.resourceParameters;
    }

    public List<ResourceMethod> getResourceMethods() {
        return this.resourceMethods;
    }

    public List<ResourceMethod> getResourceMethods(boolean loadDescendants) {
        if (!loadDescendants) {
            return this.resourceMethods;
        }
        ArrayList<ResourceMethod> resourceMethods = new ArrayList<ResourceMethod>();
        Stack<Resource> resources = new Stack<Resource>();
        resources.add(this);
        while (!resources.isEmpty()) {
            Resource resource = (Resource)((Object)resources.pop());
            resourceMethods.addAll(resource.getResourceMethods());
            for (SubResourceLocator locator : resource.getResourceLocators()) {
                resources.add(locator.getResource());
            }
        }
        return resourceMethods;
    }

    public List<SubResourceLocator> getResourceLocators() {
        return this.resourceLocators;
    }
}

