/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.contract.jaxb.util;

import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.declaration.TypeParameterDeclaration;
import com.sun.mirror.type.ArrayType;
import com.sun.mirror.type.DeclaredType;
import com.sun.mirror.type.InterfaceType;
import com.sun.mirror.type.TypeMirror;
import com.sun.mirror.type.TypeVariable;
import com.sun.mirror.util.TypeVisitor;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.sf.jelly.apt.Context;
import net.sf.jelly.apt.decorations.TypeMirrorDecorator;
import net.sf.jelly.apt.decorations.declaration.DecoratedTypeDeclaration;
import net.sf.jelly.apt.decorations.type.DecoratedTypeMirror;
import org.codehaus.enunciate.contract.jaxb.util.NarrowingCollectionComponentVisitor;

public class JAXBUtil {
    public static TypeMirror unwrapComponentType(TypeMirror typeMirror) {
        DecoratedTypeMirror decoratedType = (DecoratedTypeMirror)TypeMirrorDecorator.decorate((TypeMirror)typeMirror);
        if (decoratedType.isArray()) {
            typeMirror = ((ArrayType)decoratedType).getComponentType();
        } else if (decoratedType.isCollection()) {
            Iterator actualTypeArguments = ((DeclaredType)decoratedType).getActualTypeArguments().iterator();
            if (!actualTypeArguments.hasNext()) {
                AnnotationProcessorEnvironment ape = Context.getCurrentEnvironment();
                typeMirror = ape.getTypeUtils().getDeclaredType(ape.getTypeDeclaration(Object.class.getName()), new TypeMirror[0]);
            } else {
                typeMirror = (TypeMirror)actualTypeArguments.next();
            }
        } else {
            return typeMirror;
        }
        return typeMirror;
    }

    public static TypeMirror getNormalizedCollection(TypeMirror typeMirror) {
        Collection typeArgs;
        TypeMirror base = JAXBUtil.findCollectionStrippedOfExtensions(typeMirror);
        if (base != null && (typeArgs = ((DeclaredType)base).getActualTypeArguments()).size() == 1) {
            TypeMirror candidateToNarrow = (TypeMirror)typeArgs.iterator().next();
            NarrowingCollectionComponentVisitor visitor = new NarrowingCollectionComponentVisitor();
            candidateToNarrow.accept((TypeVisitor)visitor);
            TypeMirror narrowing = visitor.getResult();
            if (narrowing != null) {
                TypeDeclaration decl = ((DeclaredType)base).getDeclaration();
                while (decl instanceof DecoratedTypeDeclaration) {
                    decl = (TypeDeclaration)((DecoratedTypeDeclaration)decl).getDelegate();
                }
                while (narrowing instanceof DecoratedTypeMirror) {
                    narrowing = ((DecoratedTypeMirror)narrowing).getDelegate();
                }
                base = Context.getCurrentEnvironment().getTypeUtils().getDeclaredType(decl, new TypeMirror[]{narrowing});
            }
        }
        return TypeMirrorDecorator.decorate((TypeMirror)base);
    }

    private static TypeMirror findCollectionStrippedOfExtensions(TypeMirror typeMirror) {
        TypeDeclaration decl;
        TypeMirror found = null;
        if (typeMirror instanceof DeclaredType && (decl = ((DeclaredType)typeMirror).getDeclaration()) != null) {
            InterfaceType si;
            String qn = decl.getQualifiedName();
            if (List.class.getName().equals(qn) || Collection.class.getName().equals(qn)) {
                return typeMirror;
            }
            Iterator i$ = decl.getSuperinterfaces().iterator();
            while (i$.hasNext() && (found = JAXBUtil.findCollectionStrippedOfExtensions((TypeMirror)(si = (InterfaceType)i$.next()))) == null) {
            }
            if (found == null && decl instanceof ClassDeclaration) {
                found = JAXBUtil.findCollectionStrippedOfExtensions((TypeMirror)((ClassDeclaration)decl).getSuperclass());
            }
            if (found != null) {
                TypeParameterDeclaration typeParam = null;
                for (TypeMirror typeArg : ((DeclaredType)found).getActualTypeArguments()) {
                    if (!(typeArg instanceof TypeVariable)) continue;
                    typeParam = ((TypeVariable)typeArg).getDeclaration();
                    break;
                }
                if (typeParam != null) {
                    int typeArgIndex = -1;
                    for (TypeParameterDeclaration typeParamDeclaration : decl.getFormalTypeParameters()) {
                        ++typeArgIndex;
                        if (!typeParam.getSimpleName().equals(typeParamDeclaration.getSimpleName())) continue;
                        Iterator resolvingTypeArgs = ((DeclaredType)typeMirror).getActualTypeArguments().iterator();
                        TypeMirror resolved = null;
                        for (int resolvingTypeIndex = 0; resolvingTypeIndex <= typeArgIndex && resolvingTypeArgs.hasNext(); ++resolvingTypeIndex) {
                            resolved = (TypeMirror)resolvingTypeArgs.next();
                        }
                        if (resolved == null) continue;
                        TypeDeclaration foundDecl = ((DeclaredType)found).getDeclaration();
                        while (foundDecl instanceof DecoratedTypeDeclaration) {
                            foundDecl = (TypeDeclaration)((DecoratedTypeDeclaration)foundDecl).getDelegate();
                        }
                        while (resolved instanceof DecoratedTypeMirror) {
                            resolved = ((DecoratedTypeMirror)resolved).getDelegate();
                        }
                        found = Context.getCurrentEnvironment().getTypeUtils().getDeclaredType(foundDecl, new TypeMirror[]{resolved});
                    }
                }
            }
        }
        return found;
    }
}

