/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.contract.jaxb.types;

import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.type.AnnotationType;
import com.sun.mirror.type.ArrayType;
import com.sun.mirror.type.ClassType;
import com.sun.mirror.type.DeclaredType;
import com.sun.mirror.type.EnumType;
import com.sun.mirror.type.InterfaceType;
import com.sun.mirror.type.PrimitiveType;
import com.sun.mirror.type.ReferenceType;
import com.sun.mirror.type.TypeMirror;
import com.sun.mirror.type.TypeVariable;
import com.sun.mirror.type.VoidType;
import com.sun.mirror.type.WildcardType;
import com.sun.mirror.util.TypeVisitor;
import java.util.Iterator;
import net.sf.jelly.apt.freemarker.FreemarkerModel;
import org.codehaus.enunciate.apt.EnunciateFreemarkerModel;
import org.codehaus.enunciate.contract.jaxb.TypeDefinition;
import org.codehaus.enunciate.contract.jaxb.adapters.AdapterType;
import org.codehaus.enunciate.contract.jaxb.adapters.AdapterUtil;
import org.codehaus.enunciate.contract.jaxb.types.KnownXmlType;
import org.codehaus.enunciate.contract.jaxb.types.MapXmlType;
import org.codehaus.enunciate.contract.jaxb.types.XmlClassType;
import org.codehaus.enunciate.contract.jaxb.types.XmlPrimitiveType;
import org.codehaus.enunciate.contract.jaxb.types.XmlType;
import org.codehaus.enunciate.contract.jaxb.types.XmlTypeException;
import org.codehaus.enunciate.contract.jaxb.types.XmlTypeFactory;
import org.codehaus.enunciate.util.MapType;
import org.codehaus.enunciate.util.MapTypeUtil;

class XmlTypeVisitor
implements TypeVisitor {
    boolean isInArray;
    boolean isInCollection;
    private XmlType xmlType;
    private String errorMessage = null;

    XmlTypeVisitor() {
    }

    public XmlType getXmlType() {
        return this.xmlType;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void visitTypeMirror(TypeMirror typeMirror) {
        this.xmlType = null;
        this.errorMessage = "Unknown xml type: " + typeMirror;
    }

    public void visitPrimitiveType(PrimitiveType primitiveType) {
        this.xmlType = this.isInArray && primitiveType.getKind() == PrimitiveType.Kind.BYTE ? KnownXmlType.BASE64_BINARY : new XmlPrimitiveType(primitiveType);
    }

    public void visitVoidType(VoidType voidType) {
        this.xmlType = null;
        this.errorMessage = "Void is not a valid xml type.";
    }

    public void visitReferenceType(ReferenceType referenceType) {
        this.xmlType = null;
        this.errorMessage = "Unknown xml type: " + referenceType;
    }

    public void visitDeclaredType(DeclaredType declaredType) {
        MapType mapType = MapTypeUtil.findMapType((TypeMirror)declaredType);
        if (mapType != null) {
            this.setMapXmlType(mapType);
        } else {
            this.xmlType = null;
            this.errorMessage = "Unknown xml type: " + declaredType;
        }
    }

    public void visitClassType(ClassType classType) {
        MapType mapType = MapTypeUtil.findMapType((TypeMirror)classType);
        if (mapType != null) {
            this.setMapXmlType(mapType);
        } else {
            XmlType xmlType = null;
            EnunciateFreemarkerModel model = (EnunciateFreemarkerModel)FreemarkerModel.get();
            ClassDeclaration declaration = classType.getDeclaration();
            if (declaration != null) {
                XmlType knownType = model.getKnownType((TypeDeclaration)declaration);
                if (knownType != null) {
                    xmlType = knownType;
                } else {
                    TypeDefinition typeDefinition = model.findTypeDefinition(declaration);
                    if (typeDefinition != null) {
                        xmlType = new XmlClassType(typeDefinition);
                    }
                }
            }
            this.xmlType = xmlType;
            if (xmlType == null) {
                this.errorMessage = "Unknown xml type for class: " + classType + ".  If this is a class that is already compiled, you either need to specify an 'api-import' " + "element in the configuration file, or your class needs to be explicitly exported. See the FAQ " + "( http://tinyurl.com/cte3oq ) for details.";
            }
        }
    }

    public void visitEnumType(EnumType enumType) {
        this.visitClassType((ClassType)enumType);
    }

    public void visitInterfaceType(InterfaceType interfaceType) {
        AdapterType adapterType = AdapterUtil.findAdapterType((Declaration)interfaceType.getDeclaration());
        if (adapterType != null) {
            adapterType.getAdaptingType().accept((TypeVisitor)this);
        } else {
            MapType mapType = MapTypeUtil.findMapType((TypeMirror)interfaceType);
            if (mapType != null) {
                this.setMapXmlType(mapType);
            } else if (this.isInCollection) {
                this.xmlType = KnownXmlType.ANY_TYPE;
            } else {
                this.xmlType = null;
                this.errorMessage = "An interface type cannot be an xml type.";
            }
        }
    }

    private void setMapXmlType(MapType mapType) {
        try {
            XmlType keyType = XmlTypeFactory.getXmlType(mapType.getKeyType());
            XmlType valueType = XmlTypeFactory.getXmlType(mapType.getValueType());
            this.xmlType = new MapXmlType(keyType, valueType);
        }
        catch (XmlTypeException e) {
            this.errorMessage = "Error with map type: " + e.getMessage();
        }
    }

    public void visitAnnotationType(AnnotationType annotationType) {
        this.xmlType = null;
        this.errorMessage = "An annotation type cannot be an xml type.";
    }

    public void visitArrayType(ArrayType arrayType) {
        if (this.isInArray) {
            this.xmlType = null;
            this.errorMessage = "No support yet for multidimensional arrays.";
            return;
        }
        arrayType.getComponentType().accept((TypeVisitor)this);
        if (this.errorMessage != null) {
            this.errorMessage = "Problem with the array component type: " + this.errorMessage;
        }
    }

    public void visitTypeVariable(TypeVariable typeVariable) {
        Iterator bounds = typeVariable.getDeclaration().getBounds().iterator();
        if (!bounds.hasNext()) {
            this.xmlType = KnownXmlType.ANY_TYPE;
        } else {
            ((ReferenceType)bounds.next()).accept((TypeVisitor)this);
            if (this.errorMessage != null) {
                this.errorMessage = "Problem with the type variable bounds: " + this.errorMessage;
            }
        }
    }

    public void visitWildcardType(WildcardType wildcardType) {
        Iterator upperBounds = wildcardType.getUpperBounds().iterator();
        if (!upperBounds.hasNext()) {
            this.xmlType = KnownXmlType.ANY_TYPE;
        } else {
            ((ReferenceType)upperBounds.next()).accept((TypeVisitor)this);
            if (this.errorMessage != null) {
                this.errorMessage = "Problem with wildcard bounds: " + this.errorMessage;
            }
        }
    }
}

