/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.contract.jaxb.types;

import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.declaration.PackageDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.type.DeclaredType;
import com.sun.mirror.type.MirroredTypeException;
import com.sun.mirror.type.TypeMirror;
import com.sun.mirror.util.TypeVisitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlSchemaTypes;
import net.sf.jelly.apt.Context;
import net.sf.jelly.apt.decorations.TypeMirrorDecorator;
import net.sf.jelly.apt.decorations.type.DecoratedTypeMirror;
import org.codehaus.enunciate.contract.jaxb.Accessor;
import org.codehaus.enunciate.contract.jaxb.adapters.Adaptable;
import org.codehaus.enunciate.contract.jaxb.types.SpecifiedXmlType;
import org.codehaus.enunciate.contract.jaxb.types.XmlType;
import org.codehaus.enunciate.contract.jaxb.types.XmlTypeException;
import org.codehaus.enunciate.contract.jaxb.types.XmlTypeVisitor;
import org.codehaus.enunciate.contract.jaxb.util.JAXBUtil;
import org.codehaus.enunciate.contract.validation.ValidationException;

public class XmlTypeFactory {
    private static final HashMap<String, HashMap<String, XmlSchemaType>> EXPLICIT_ELEMENTS_BY_PACKAGE = new HashMap();

    public static XmlType findSpecifiedType(Adaptable adaptable) throws XmlTypeException {
        XmlSchemaType specified;
        XmlType xmlType = null;
        if (adaptable instanceof Accessor && (specified = (XmlSchemaType)((Accessor)adaptable).getAnnotation(XmlSchemaType.class)) != null) {
            return new SpecifiedXmlType(specified);
        }
        if (adaptable.isAdapted()) {
            xmlType = XmlTypeFactory.getXmlType(adaptable.getAdapterType().getAdaptingType());
        } else if (adaptable instanceof Accessor) {
            xmlType = XmlTypeFactory.findExplicitSchemaType((Accessor)adaptable);
        }
        return xmlType;
    }

    public static XmlType findExplicitSchemaType(Accessor accessor) {
        TypeMirror typeMirror = JAXBUtil.unwrapComponentType(accessor.getAccessorType());
        SpecifiedXmlType xmlType = null;
        XmlSchemaType schemaType = (XmlSchemaType)accessor.getAnnotation(XmlSchemaType.class);
        if (schemaType == null && typeMirror instanceof DeclaredType) {
            PackageDeclaration pckg = accessor.getDeclaringType().getPackage();
            String packageName = pckg.getQualifiedName();
            HashMap<String, Object> explicitTypes = EXPLICIT_ELEMENTS_BY_PACKAGE.get(packageName);
            if (explicitTypes == null) {
                explicitTypes = new HashMap();
                EXPLICIT_ELEMENTS_BY_PACKAGE.put(packageName, explicitTypes);
                XmlSchemaType schemaTypeInfo = (XmlSchemaType)pckg.getAnnotation(XmlSchemaType.class);
                XmlSchemaTypes schemaTypes = (XmlSchemaTypes)pckg.getAnnotation(XmlSchemaTypes.class);
                if (schemaTypeInfo != null || schemaTypes != null) {
                    ArrayList<XmlSchemaType> allSpecifiedTypes = new ArrayList<XmlSchemaType>();
                    if (schemaTypeInfo != null) {
                        allSpecifiedTypes.add(schemaTypeInfo);
                    }
                    if (schemaTypes != null) {
                        allSpecifiedTypes.addAll(Arrays.asList(schemaTypes.value()));
                    }
                    for (XmlSchemaType specifiedType : allSpecifiedTypes) {
                        String typeFqn;
                        try {
                            Class specifiedClass = specifiedType.type();
                            if (specifiedClass == XmlSchemaType.DEFAULT.class) {
                                throw new ValidationException(pckg.getPosition(), pckg.getQualifiedName() + ": a type must be specified in " + XmlSchemaType.class.getName() + " at the package-level.");
                            }
                            typeFqn = specifiedClass.getName();
                        }
                        catch (MirroredTypeException e) {
                            TypeMirror explicitTypeMirror = e.getTypeMirror();
                            if (!(explicitTypeMirror instanceof DeclaredType)) {
                                throw new ValidationException(pckg.getPosition(), pckg.getQualifiedName() + ": only a declared type can be adapted.  Offending type: " + explicitTypeMirror);
                            }
                            typeFqn = ((DeclaredType)explicitTypeMirror).getDeclaration().getQualifiedName();
                        }
                        explicitTypes.put(typeFqn, specifiedType);
                    }
                }
            }
            schemaType = explicitTypes.get(((DeclaredType)typeMirror).getDeclaration().getQualifiedName());
        }
        if (schemaType != null) {
            xmlType = new SpecifiedXmlType(schemaType);
        }
        return xmlType;
    }

    public static XmlType getXmlType(TypeMirror typeMirror) throws XmlTypeException {
        XmlTypeVisitor visitor = new XmlTypeVisitor();
        DecoratedTypeMirror decorated = (DecoratedTypeMirror)TypeMirrorDecorator.decorate((TypeMirror)typeMirror);
        visitor.isInCollection = decorated.isCollection();
        visitor.isInArray = decorated.isArray();
        JAXBUtil.unwrapComponentType(typeMirror).accept((TypeVisitor)visitor);
        if (visitor.getErrorMessage() != null) {
            throw new XmlTypeException(visitor.getErrorMessage());
        }
        return visitor.getXmlType();
    }

    public static XmlType getXmlType(Class type) throws XmlTypeException {
        AnnotationProcessorEnvironment env = Context.getCurrentEnvironment();
        TypeDeclaration declaration = env.getTypeDeclaration(type.getName());
        return XmlTypeFactory.getXmlType((TypeMirror)env.getTypeUtils().getDeclaredType(declaration, new TypeMirror[0]));
    }
}

