/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.contract.jaxb.adapters;

import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.PackageDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.type.ClassType;
import com.sun.mirror.type.DeclaredType;
import com.sun.mirror.type.MirroredTypeException;
import com.sun.mirror.type.ReferenceType;
import com.sun.mirror.type.TypeMirror;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapters;
import net.sf.jelly.apt.Context;
import org.codehaus.enunciate.contract.jaxb.Accessor;
import org.codehaus.enunciate.contract.jaxb.adapters.AdapterType;
import org.codehaus.enunciate.contract.jaxb.util.JAXBUtil;
import org.codehaus.enunciate.contract.jaxws.WebParam;
import org.codehaus.enunciate.contract.validation.ValidationException;

public class AdapterUtil {
    private static final HashMap<String, HashMap<String, XmlJavaTypeAdapter>> ADAPTERS_BY_PACKAGE = new HashMap();

    public static AdapterType findAdapterType(Declaration declaration) {
        if (declaration instanceof Accessor) {
            Accessor accessor = (Accessor)declaration;
            return AdapterUtil.findAdapterType(accessor.getAccessorType(), (Declaration)accessor, accessor.getDeclaringType().getPackage());
        }
        if (declaration instanceof MethodDeclaration) {
            MethodDeclaration method = (MethodDeclaration)declaration;
            return AdapterUtil.findAdapterType(method.getReturnType(), (Declaration)method, method.getDeclaringType().getPackage());
        }
        if (declaration instanceof WebParam) {
            WebParam parameter = (WebParam)declaration;
            return AdapterUtil.findAdapterType(parameter.getType(), (Declaration)parameter, parameter.getWebMethod().getDeclaringEndpointInterface().getPackage());
        }
        if (declaration instanceof TypeDeclaration) {
            TypeDeclaration typeDeclaration = (TypeDeclaration)declaration;
            AnnotationProcessorEnvironment ape = Context.getCurrentEnvironment();
            typeDeclaration = ape.getTypeDeclaration(typeDeclaration.getQualifiedName());
            DeclaredType declaredType = ape.getTypeUtils().getDeclaredType(typeDeclaration, new TypeMirror[0]);
            return AdapterUtil.findAdapterType((TypeMirror)declaredType, null, null);
        }
        throw new IllegalArgumentException("A " + declaration.getClass().getSimpleName() + " is not an adaptable declaration according to the JAXB spec.");
    }

    private static AdapterType findAdapterType(TypeMirror unwrappedAdaptedType, Declaration referer, PackageDeclaration pckg) {
        XmlJavaTypeAdapter typeAdapterInfo;
        TypeMirror adaptedType = JAXBUtil.unwrapComponentType(unwrappedAdaptedType);
        XmlJavaTypeAdapter xmlJavaTypeAdapter = typeAdapterInfo = referer != null ? (XmlJavaTypeAdapter)referer.getAnnotation(XmlJavaTypeAdapter.class) : null;
        if (adaptedType instanceof DeclaredType) {
            TypeDeclaration typeDeclaration;
            if (typeAdapterInfo == null) {
                typeDeclaration = ((DeclaredType)adaptedType).getDeclaration();
                if (typeDeclaration == null) {
                    throw new IllegalStateException("Class not found: " + adaptedType);
                }
                typeAdapterInfo = (XmlJavaTypeAdapter)typeDeclaration.getAnnotation(XmlJavaTypeAdapter.class);
            }
            if (typeAdapterInfo == null && pckg != null) {
                typeDeclaration = ((DeclaredType)adaptedType).getDeclaration();
                if (typeDeclaration == null) {
                    throw new IllegalStateException("Class not found: " + adaptedType);
                }
                typeAdapterInfo = AdapterUtil.getAdaptersOfPackage(pckg).get(typeDeclaration.getQualifiedName());
            }
        }
        if (typeAdapterInfo != null) {
            ClassType adapterTypeMirror;
            try {
                Class adaptedClass = typeAdapterInfo.value();
                AnnotationProcessorEnvironment ape = Context.getCurrentEnvironment();
                adapterTypeMirror = (ClassType)ape.getTypeUtils().getDeclaredType(ape.getTypeDeclaration(adaptedClass.getName()), new TypeMirror[0]);
            }
            catch (MirroredTypeException e) {
                adapterTypeMirror = (ClassType)e.getTypeMirror();
            }
            AdapterType adapterType = new AdapterType(adapterTypeMirror);
            if (adaptedType instanceof DeclaredType && adapterType.canAdapt((ReferenceType)((DeclaredType)adaptedType)) || unwrappedAdaptedType != adaptedType && unwrappedAdaptedType instanceof ReferenceType && adapterType.canAdapt((ReferenceType)unwrappedAdaptedType)) {
                return adapterType;
            }
            throw new ValidationException(referer.getPosition(), referer.getSimpleName() + ": adapter " + adapterTypeMirror.getDeclaration().getQualifiedName() + " does not adapt " + unwrappedAdaptedType);
        }
        return null;
    }

    private static Map<String, XmlJavaTypeAdapter> getAdaptersOfPackage(PackageDeclaration pckg) {
        HashMap<String, Object> adaptersOfPackage = ADAPTERS_BY_PACKAGE.get(pckg.getQualifiedName());
        if (adaptersOfPackage == null) {
            adaptersOfPackage = new HashMap();
            ADAPTERS_BY_PACKAGE.put(pckg.getQualifiedName(), adaptersOfPackage);
            XmlJavaTypeAdapter javaType = (XmlJavaTypeAdapter)pckg.getAnnotation(XmlJavaTypeAdapter.class);
            XmlJavaTypeAdapters javaTypes = (XmlJavaTypeAdapters)pckg.getAnnotation(XmlJavaTypeAdapters.class);
            if (javaType != null || javaTypes != null) {
                ArrayList<XmlJavaTypeAdapter> allAdaptedTypes = new ArrayList<XmlJavaTypeAdapter>();
                if (javaType != null) {
                    allAdaptedTypes.add(javaType);
                }
                if (javaTypes != null) {
                    allAdaptedTypes.addAll(Arrays.asList(javaTypes.value()));
                }
                for (XmlJavaTypeAdapter adaptedTypeInfo : allAdaptedTypes) {
                    String typeFqn;
                    try {
                        Class adaptedClass = adaptedTypeInfo.type();
                        if (adaptedClass == XmlJavaTypeAdapter.DEFAULT.class) {
                            throw new ValidationException(pckg.getPosition(), "Package " + pckg.getSimpleName() + ": a type must be specified in " + XmlJavaTypeAdapter.class.getName() + " at the package-level.");
                        }
                        typeFqn = adaptedClass.getName();
                    }
                    catch (MirroredTypeException e) {
                        TypeMirror adaptedType = e.getTypeMirror();
                        if (!(adaptedType instanceof DeclaredType)) {
                            throw new ValidationException(pckg.getPosition(), "Package " + pckg.getSimpleName() + ": unadaptable type: " + adaptedType);
                        }
                        TypeDeclaration typeDeclaration = ((DeclaredType)adaptedType).getDeclaration();
                        if (typeDeclaration == null) {
                            throw new IllegalStateException("Class not found: " + adaptedType);
                        }
                        typeFqn = typeDeclaration.getQualifiedName();
                    }
                    adaptersOfPackage.put(typeFqn, adaptedTypeInfo);
                }
            }
        }
        return adaptersOfPackage;
    }
}

