/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.contract.jaxb.adapters;

import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.declaration.TypeParameterDeclaration;
import com.sun.mirror.type.ArrayType;
import com.sun.mirror.type.ClassType;
import com.sun.mirror.type.DeclaredType;
import com.sun.mirror.type.ReferenceType;
import com.sun.mirror.type.TypeMirror;
import com.sun.mirror.type.TypeVariable;
import com.sun.mirror.util.Types;
import java.util.Collection;
import java.util.Iterator;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import net.sf.jelly.apt.Context;
import net.sf.jelly.apt.decorations.TypeMirrorDecorator;
import net.sf.jelly.apt.decorations.type.DecoratedClassType;
import net.sf.jelly.apt.decorations.type.DecoratedTypeMirror;
import org.codehaus.enunciate.contract.validation.ValidationException;

public class AdapterType
extends DecoratedClassType {
    private final ReferenceType adaptedType;
    private final TypeMirror adaptingType;

    public AdapterType(ClassType adapterType) {
        super(adapterType);
        ClassDeclaration adapterDeclaration = adapterType.getDeclaration();
        ClassType adaptorInterfaceType = AdapterType.findXmlAdapterType(adapterDeclaration);
        if (adaptorInterfaceType == null) {
            throw new ValidationException(adapterDeclaration.getPosition(), adapterDeclaration.getQualifiedName() + " is not an instance of javax.xml.bind.annotation.adapters.XmlAdapter.");
        }
        Collection adaptorTypeArgs = adaptorInterfaceType.getActualTypeArguments();
        if (adaptorTypeArgs == null || adaptorTypeArgs.size() != 2) {
            throw new ValidationException(adapterDeclaration.getPosition(), adapterDeclaration.getQualifiedName() + " must specify both a value type and a bound type.");
        }
        Iterator formalTypeIt = adaptorTypeArgs.iterator();
        this.adaptingType = TypeMirrorDecorator.decorate((TypeMirror)((TypeMirror)formalTypeIt.next()));
        TypeMirror boundTypeMirror = (TypeMirror)formalTypeIt.next();
        if (!(boundTypeMirror instanceof ReferenceType)) {
            throw new ValidationException(adapterDeclaration.getPosition(), adapterDeclaration.getQualifiedName() + ": illegal XML adapter: not adapting a reference type (" + boundTypeMirror + ").");
        }
        while (boundTypeMirror instanceof TypeVariable) {
            TypeParameterDeclaration declaration = ((TypeVariable)boundTypeMirror).getDeclaration();
            if (declaration == null) {
                throw new IllegalStateException(adapterDeclaration.getQualifiedName() + ": unable to find type parameter declaration for type variable " + boundTypeMirror + ".");
            }
            if (declaration.getBounds() != null && !declaration.getBounds().isEmpty()) {
                boundTypeMirror = (TypeMirror)declaration.getBounds().iterator().next();
                continue;
            }
            AnnotationProcessorEnvironment env = Context.getCurrentEnvironment();
            boundTypeMirror = env.getTypeUtils().getDeclaredType(env.getTypeDeclaration(Object.class.getName()), new TypeMirror[0]);
        }
        this.adaptedType = (ReferenceType)TypeMirrorDecorator.decorate((TypeMirror)((ReferenceType)boundTypeMirror));
    }

    private static ClassType findXmlAdapterType(ClassDeclaration declaration) {
        if (Object.class.getName().equals(declaration.getQualifiedName())) {
            return null;
        }
        ClassType superClass = declaration.getSuperclass();
        if (XmlAdapter.class.getName().equals(superClass.getDeclaration().getQualifiedName())) {
            return superClass;
        }
        return AdapterType.findXmlAdapterType(superClass.getDeclaration());
    }

    public boolean canAdapt(ReferenceType type) {
        DecoratedTypeMirror decorated = (DecoratedTypeMirror)TypeMirrorDecorator.decorate((TypeMirror)type);
        ReferenceType adaptedType = this.getAdaptedType();
        if (adaptedType instanceof DeclaredType) {
            return ((DeclaredType)adaptedType).getDeclaration() != null && decorated.isInstanceOf(((DeclaredType)adaptedType).getDeclaration().getQualifiedName());
        }
        if (adaptedType instanceof ArrayType && decorated instanceof ArrayType) {
            TypeMirror adaptedComponentType = ((ArrayType)adaptedType).getComponentType();
            while (adaptedComponentType instanceof DecoratedTypeMirror) {
                adaptedComponentType = ((DecoratedTypeMirror)adaptedComponentType).getDelegate();
            }
            TypeMirror componentType = ((ArrayType)decorated).getComponentType();
            while (componentType instanceof DecoratedTypeMirror) {
                componentType = ((DecoratedTypeMirror)componentType).getDelegate();
            }
            Types typeUtils = Context.getCurrentEnvironment().getTypeUtils();
            return typeUtils.isAssignable(componentType, adaptedComponentType);
        }
        return false;
    }

    public TypeMirror getAdaptingType(TypeMirror adaptedType) {
        DecoratedTypeMirror decorated = (DecoratedTypeMirror)TypeMirrorDecorator.decorate((TypeMirror)adaptedType);
        TypeMirror componentType = null;
        if (decorated.isCollection()) {
            Iterator itemTypes = ((DeclaredType)decorated).getActualTypeArguments().iterator();
            if (!itemTypes.hasNext()) {
                AnnotationProcessorEnvironment env = Context.getCurrentEnvironment();
                Types typeUtils = env.getTypeUtils();
                componentType = TypeMirrorDecorator.decorate((TypeMirror)typeUtils.getDeclaredType(env.getTypeDeclaration(Object.class.getName()), new TypeMirror[0]));
            } else {
                componentType = (TypeMirror)itemTypes.next();
            }
        } else if (decorated.isArray()) {
            componentType = ((ArrayType)decorated).getComponentType();
        }
        if (componentType instanceof ReferenceType && this.canAdapt((ReferenceType)componentType)) {
            AnnotationProcessorEnvironment env = Context.getCurrentEnvironment();
            TypeDeclaration collection = env.getTypeDeclaration(Collection.class.getName());
            TypeMirror declaredAdapting = this.getAdaptingType();
            while (declaredAdapting instanceof DecoratedTypeMirror) {
                declaredAdapting = ((DecoratedTypeMirror)declaredAdapting).getDelegate();
            }
            return env.getTypeUtils().getDeclaredType(collection, new TypeMirror[]{declaredAdapting});
        }
        return this.getAdaptingType();
    }

    public ReferenceType getAdaptedType() {
        return this.adaptedType;
    }

    public TypeMirror getAdaptingType() {
        return this.adaptingType;
    }
}

