/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.contract.jaxb;

import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.FieldDeclaration;
import com.sun.mirror.declaration.MemberDeclaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.type.ClassType;
import com.sun.mirror.type.DeclaredType;
import com.sun.mirror.type.MirroredTypeException;
import com.sun.mirror.type.MirroredTypesException;
import com.sun.mirror.type.TypeMirror;
import com.sun.mirror.util.Declarations;
import java.beans.Introspector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.xml.bind.annotation.XmlAccessOrder;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorOrder;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyAttribute;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElementRefs;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlMixed;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlValue;
import javax.xml.namespace.QName;
import net.sf.jelly.apt.Context;
import net.sf.jelly.apt.decorations.DeclarationDecorator;
import net.sf.jelly.apt.decorations.declaration.DecoratedClassDeclaration;
import net.sf.jelly.apt.decorations.declaration.DecoratedDeclaration;
import net.sf.jelly.apt.decorations.declaration.DecoratedMethodDeclaration;
import net.sf.jelly.apt.decorations.declaration.PropertyDeclaration;
import org.codehaus.enunciate.ClientName;
import org.codehaus.enunciate.contract.jaxb.Accessor;
import org.codehaus.enunciate.contract.jaxb.AccessorFilter;
import org.codehaus.enunciate.contract.jaxb.AnyElement;
import org.codehaus.enunciate.contract.jaxb.Attribute;
import org.codehaus.enunciate.contract.jaxb.Element;
import org.codehaus.enunciate.contract.jaxb.ElementComparator;
import org.codehaus.enunciate.contract.jaxb.ElementRef;
import org.codehaus.enunciate.contract.jaxb.Schema;
import org.codehaus.enunciate.contract.jaxb.Value;
import org.codehaus.enunciate.contract.jaxb.types.XmlType;
import org.codehaus.enunciate.contract.validation.BaseValidator;
import org.codehaus.enunciate.contract.validation.ValidationException;
import org.codehaus.enunciate.contract.validation.ValidationResult;
import org.codehaus.enunciate.qname.XmlQNameEnumRef;

public abstract class TypeDefinition
extends DecoratedClassDeclaration {
    private final javax.xml.bind.annotation.XmlType xmlType;
    private final Schema schema;
    private final SortedSet<Element> elements;
    private final Collection<Attribute> attributes;
    private final Value xmlValue;
    private final Accessor xmlID;
    private final boolean hasAnyAttribute;
    private final TypeMirror anyAttributeQNameEnumRef;
    private final AnyElement anyElement;
    private final Set<String> referencedFrom = new TreeSet<String>();

    protected TypeDefinition(ClassDeclaration delegate) {
        super(delegate);
        Package pckg;
        this.xmlType = (javax.xml.bind.annotation.XmlType)this.getAnnotation(javax.xml.bind.annotation.XmlType.class);
        try {
            pckg = Class.forName(this.getQualifiedName()).getPackage();
        }
        catch (Throwable e) {
            pckg = null;
        }
        this.schema = new Schema(delegate.getPackage(), pckg);
        ElementComparator comparator = new ElementComparator(this.getPropertyOrder(), this.getAccessorOrder());
        TreeSet<Element> elementAccessors = new TreeSet<Element>(comparator);
        AccessorFilter filter = new AccessorFilter(this.getAccessType());
        ArrayList<Attribute> attributeAccessors = new ArrayList<Attribute>();
        Value value = null;
        Accessor xmlID = null;
        AnyElement anyElement = null;
        boolean hasAnyAttribute = false;
        TypeMirror anyAttributeQNameEnumRef = null;
        for (MemberDeclaration accessor : this.loadPotentialAccessors(filter)) {
            Accessor added;
            if (this.isAttribute(accessor)) {
                Attribute attribute = new Attribute(accessor, this);
                attributeAccessors.add(attribute);
                added = attribute;
            } else if (this.isValue(accessor)) {
                if (value != null) {
                    throw new ValidationException(accessor.getPosition(), "Accessor " + accessor.getSimpleName() + " of " + this.getQualifiedName() + ": a type definition cannot have more than one xml value.");
                }
                value = new Value(accessor, this);
                added = value;
            } else if (this.isElementRef(accessor)) {
                ElementRef elementRef = new ElementRef(accessor, this);
                if (!elementAccessors.add(elementRef)) continue;
                added = elementRef;
            } else {
                Element element;
                if (this.isAnyAttribute(accessor)) {
                    hasAnyAttribute = true;
                    XmlQNameEnumRef enumRef = (XmlQNameEnumRef)accessor.getAnnotation(XmlQNameEnumRef.class);
                    if (enumRef == null) continue;
                    AnnotationProcessorEnvironment env = Context.getCurrentEnvironment();
                    try {
                        TypeDeclaration decl = env.getTypeDeclaration(enumRef.value().getName());
                        anyAttributeQNameEnumRef = env.getTypeUtils().getDeclaredType(decl, new TypeMirror[0]);
                    }
                    catch (MirroredTypeException e) {
                        anyAttributeQNameEnumRef = e.getTypeMirror();
                    }
                    continue;
                }
                if (this.isAnyElement(accessor)) {
                    anyElement = new AnyElement(accessor, this);
                    continue;
                }
                if (this.isUnsupported(accessor)) {
                    throw new ValidationException(accessor.getPosition(), "Accessor " + accessor.getSimpleName() + " of " + this.getQualifiedName() + ": sorry, we currently don't support mixed or wildard elements. Maybe someday...");
                }
                if (accessor instanceof PropertyDeclaration && (this.overrides(((PropertyDeclaration)accessor).getGetter()) || this.overrides(((PropertyDeclaration)accessor).getSetter())) || !elementAccessors.add(element = new Element(accessor, this))) continue;
                added = element;
            }
            if (added.getAnnotation(XmlID.class) == null) continue;
            if (xmlID != null) {
                throw new ValidationException(added.getPosition(), "Accessor " + added.getSimpleName() + " of " + this.getQualifiedName() + ": more than one XML id specified.");
            }
            xmlID = added;
        }
        this.elements = Collections.unmodifiableSortedSet(elementAccessors);
        this.attributes = Collections.unmodifiableCollection(attributeAccessors);
        this.xmlValue = value;
        this.xmlID = xmlID;
        this.hasAnyAttribute = hasAnyAttribute;
        this.anyAttributeQNameEnumRef = anyAttributeQNameEnumRef;
        this.anyElement = anyElement;
    }

    protected List<MemberDeclaration> loadPotentialAccessors(AccessorFilter filter) {
        ArrayList<FieldDeclaration> potentialFields = new ArrayList<FieldDeclaration>();
        ArrayList<PropertyDeclaration> potentialProperties = new ArrayList<PropertyDeclaration>();
        this.aggregatePotentialAccessors(potentialFields, potentialProperties, this, filter);
        ArrayList<MemberDeclaration> accessors = new ArrayList<MemberDeclaration>();
        accessors.addAll(potentialFields);
        accessors.addAll(potentialProperties);
        return accessors;
    }

    protected void aggregatePotentialAccessors(List<FieldDeclaration> fields, List<PropertyDeclaration> properties, DecoratedClassDeclaration clazz, AccessorFilter filter) {
        DecoratedClassDeclaration superDeclaration;
        DecoratedClassDeclaration decoratedClassDeclaration = superDeclaration = clazz.getSuperclass() != null && clazz.getSuperclass().getDeclaration() != null ? (DecoratedClassDeclaration)DeclarationDecorator.decorate((Declaration)clazz.getSuperclass().getDeclaration()) : null;
        if (superDeclaration != null && this.isXmlTransient((Declaration)superDeclaration)) {
            this.aggregatePotentialAccessors(fields, properties, superDeclaration, filter);
        }
        for (FieldDeclaration fieldDeclaration : clazz.getFields()) {
            if (!filter.accept((MemberDeclaration)fieldDeclaration)) {
                this.remove(fieldDeclaration, fields);
                continue;
            }
            this.addOrReplace(fieldDeclaration, fields);
        }
        for (PropertyDeclaration propertyDeclaration : clazz.getProperties()) {
            if (!filter.accept((MemberDeclaration)propertyDeclaration)) {
                this.remove(propertyDeclaration, properties);
                continue;
            }
            this.addOrReplace(propertyDeclaration, properties);
        }
    }

    protected boolean overrides(DecoratedMethodDeclaration method) {
        if (method == null) {
            return false;
        }
        AnnotationProcessorEnvironment env = Context.getCurrentEnvironment();
        Declarations decls = env.getDeclarationUtils();
        Declaration unwrappedMethod = method.getDelegate();
        while (unwrappedMethod instanceof DecoratedDeclaration) {
            unwrappedMethod = ((DecoratedDeclaration)unwrappedMethod).getDelegate();
        }
        TypeDeclaration declaringType = method.getDeclaringType();
        if (declaringType instanceof ClassDeclaration) {
            declaringType = ((ClassDeclaration)declaringType).getSuperclass().getDeclaration();
            while (declaringType instanceof ClassDeclaration && !Object.class.getName().equals(declaringType.getQualifiedName())) {
                Collection methods = declaringType.getMethods();
                for (MethodDeclaration candidate : methods) {
                    while (candidate instanceof DecoratedDeclaration) {
                        candidate = ((DecoratedDeclaration)candidate).getDelegate();
                    }
                    if (!decls.overrides(candidate, (MethodDeclaration)unwrappedMethod)) continue;
                    return true;
                }
                declaringType = ((ClassDeclaration)declaringType).getSuperclass().getDeclaration();
            }
        }
        return false;
    }

    protected <M extends MemberDeclaration> void addOrReplace(M memberDeclaration, List<M> memberDeclarations) {
        this.remove(memberDeclaration, memberDeclarations);
        memberDeclarations.add(memberDeclaration);
    }

    protected <M extends MemberDeclaration> void remove(M memberDeclaration, List<M> memberDeclarations) {
        Iterator<M> it = memberDeclarations.iterator();
        while (it.hasNext()) {
            MemberDeclaration candidate = (MemberDeclaration)it.next();
            if (!candidate.getSimpleName().equals(memberDeclaration.getSimpleName())) continue;
            it.remove();
        }
    }

    protected boolean isAttribute(MemberDeclaration declaration) {
        return declaration.getAnnotation(XmlAttribute.class) != null;
    }

    protected boolean isValue(MemberDeclaration declaration) {
        return declaration.getAnnotation(XmlValue.class) != null;
    }

    protected boolean isElementRef(MemberDeclaration declaration) {
        return declaration.getAnnotation(XmlElementRef.class) != null || declaration.getAnnotation(XmlElementRefs.class) != null;
    }

    protected boolean isAnyAttribute(MemberDeclaration declaration) {
        return declaration.getAnnotation(XmlAnyAttribute.class) != null;
    }

    protected boolean isAnyElement(MemberDeclaration declaration) {
        return declaration.getAnnotation(XmlAnyElement.class) != null;
    }

    protected boolean isUnsupported(MemberDeclaration declaration) {
        return declaration.getAnnotation(XmlMixed.class) != null;
    }

    public String getName() {
        String name = Introspector.decapitalize(this.getSimpleName());
        if (this.xmlType != null && !"##default".equals(this.xmlType.name()) && "".equals(name = this.xmlType.name())) {
            name = null;
        }
        return name;
    }

    public String getNamespace() {
        String namespace = this.getPackage().getNamespace();
        if (this.xmlType != null && !"##default".equals(this.xmlType.namespace())) {
            namespace = this.xmlType.namespace();
        }
        return namespace;
    }

    public String getClientSimpleName() {
        String clientSimpleName = this.getSimpleName();
        ClientName clientName = (ClientName)this.getAnnotation(ClientName.class);
        if (clientName != null) {
            clientSimpleName = clientName.value();
        }
        return clientSimpleName;
    }

    public QName getQname() {
        String localPart = this.getName();
        if (localPart == null) {
            localPart = "";
        }
        return new QName(this.getNamespace(), localPart);
    }

    public XmlAccessType getAccessType() {
        XmlAccessType accessType = this.getPackage().getAccessType();
        XmlAccessorType xmlAccessorType = (XmlAccessorType)this.getAnnotation(XmlAccessorType.class);
        if (xmlAccessorType != null) {
            accessType = xmlAccessorType.value();
        } else {
            XmlAccessType inheritedAccessType = this.getInheritedAccessType((ClassDeclaration)this);
            if (inheritedAccessType != null) {
                accessType = inheritedAccessType;
            }
        }
        return accessType;
    }

    protected XmlAccessType getInheritedAccessType(ClassDeclaration declaration) {
        ClassDeclaration superDeclaration;
        ClassType superclass = declaration.getSuperclass();
        if (superclass != null && (superDeclaration = superclass.getDeclaration()) != null && !Object.class.getName().equals(superDeclaration.getQualifiedName())) {
            XmlAccessorType xmlAccessorType = (XmlAccessorType)superDeclaration.getAnnotation(XmlAccessorType.class);
            if (xmlAccessorType != null) {
                return xmlAccessorType.value();
            }
            return this.getInheritedAccessType(superDeclaration);
        }
        return null;
    }

    public String[] getPropertyOrder() {
        String[] propOrder;
        String[] propertyOrder = null;
        if (!(this.xmlType == null || (propOrder = this.xmlType.propOrder()) == null || propOrder.length <= 0 || propOrder.length <= 1 && "".equals(propOrder[0]))) {
            propertyOrder = propOrder;
        }
        return propertyOrder;
    }

    public XmlAccessOrder getAccessorOrder() {
        XmlAccessOrder order = this.getPackage().getAccessorOrder();
        XmlAccessorOrder xmlAccessorOrder = (XmlAccessorOrder)this.getAnnotation(XmlAccessorOrder.class);
        if (xmlAccessorOrder != null) {
            order = xmlAccessorOrder.value();
        }
        return order;
    }

    public Collection<TypeMirror> getSeeAlsos() {
        ArrayList<DeclaredType> seeAlsos = null;
        XmlSeeAlso seeAlsoInfo = (XmlSeeAlso)this.getAnnotation(XmlSeeAlso.class);
        if (seeAlsoInfo != null) {
            seeAlsos = new ArrayList<DeclaredType>();
            try {
                AnnotationProcessorEnvironment env = Context.getCurrentEnvironment();
                for (Class clazz : seeAlsoInfo.value()) {
                    TypeDeclaration typeDeclaration = env.getTypeDeclaration(clazz.getName());
                    DeclaredType undecorated = env.getTypeUtils().getDeclaredType(typeDeclaration, new TypeMirror[0]);
                    seeAlsos.add(undecorated);
                }
            }
            catch (MirroredTypesException e) {
                seeAlsos.addAll(e.getTypeMirrors());
            }
        }
        return seeAlsos;
    }

    public boolean isHasAnyAttribute() {
        return this.hasAnyAttribute;
    }

    public TypeMirror getAnyAttributeQNameEnumRef() {
        return this.anyAttributeQNameEnumRef;
    }

    public AnyElement getAnyElement() {
        return this.anyElement;
    }

    public SortedSet<Element> getElements() {
        return this.elements;
    }

    public Collection<Attribute> getAttributes() {
        return this.attributes;
    }

    public Value getValue() {
        return this.xmlValue;
    }

    public Accessor getXmlID() {
        return this.xmlID;
    }

    protected boolean isXmlTransient(Declaration declaration) {
        return declaration.getAnnotation(XmlTransient.class) != null;
    }

    public boolean isAnonymous() {
        return this.getName() == null;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public Schema getPackage() {
        return this.getSchema();
    }

    public boolean isComplex() {
        return false;
    }

    public boolean isEnum() {
        return false;
    }

    public boolean isSimple() {
        return false;
    }

    public boolean isBaseObject() {
        return true;
    }

    public Set<String> getReferencedFrom() {
        return this.referencedFrom;
    }

    public abstract ValidationResult accept(BaseValidator var1);

    public abstract XmlType getBaseType();
}

