/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.contract.jaxb;

import com.sun.mirror.declaration.EnumConstantDeclaration;
import com.sun.mirror.declaration.EnumDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.type.TypeMirror;
import java.net.URI;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.codehaus.enunciate.contract.jaxb.EnumTypeDefinition;
import org.codehaus.enunciate.contract.jaxb.types.KnownXmlType;
import org.codehaus.enunciate.contract.jaxb.types.XmlType;
import org.codehaus.enunciate.contract.validation.BaseValidator;
import org.codehaus.enunciate.contract.validation.ValidationException;
import org.codehaus.enunciate.contract.validation.ValidationResult;
import org.codehaus.enunciate.qname.XmlQNameEnum;
import org.codehaus.enunciate.qname.XmlQNameEnumValue;
import org.codehaus.enunciate.qname.XmlUnknownQNameEnumValue;

public class QNameEnumTypeDefinition
extends EnumTypeDefinition {
    private final String namespace;
    private final XmlQNameEnum.BaseType baseType;

    public QNameEnumTypeDefinition(EnumDeclaration delegate) {
        super(delegate);
        XmlQNameEnum xmlQNameEnum = (XmlQNameEnum)this.getAnnotation(XmlQNameEnum.class);
        if (xmlQNameEnum == null) {
            throw new IllegalArgumentException(delegate.getQualifiedName() + " is not a qname enum (not annotated with @org.codehaus.enunciate.qname.XmlQNameEnum)");
        }
        String namespace = this.getPackage().getNamespace();
        if (!"##default".equals(xmlQNameEnum.namespace())) {
            namespace = xmlQNameEnum.namespace();
        }
        this.namespace = namespace;
        this.baseType = xmlQNameEnum.base();
    }

    @Override
    protected Map<String, Object> loadEnumValues() {
        String namespace = this.getPackage().getNamespace();
        XmlQNameEnum xmlQNameEnum = (XmlQNameEnum)this.getAnnotation(XmlQNameEnum.class);
        if (xmlQNameEnum != null && !"##default".equals(xmlQNameEnum.namespace())) {
            namespace = xmlQNameEnum.namespace();
        }
        if (namespace == null) {
            namespace = "";
        }
        LinkedHashMap<String, Object> enumValueMap = new LinkedHashMap<String, Object>();
        Collection enumConstants = ((EnumDeclaration)this.getDelegate()).getEnumConstants();
        HashSet<QName> enumValues = new HashSet<QName>(enumConstants.size());
        String unknownQNameConstant = null;
        for (EnumConstantDeclaration enumConstant : enumConstants) {
            QName qname;
            XmlUnknownQNameEnumValue unknownQNameEnumValue = (XmlUnknownQNameEnumValue)enumConstant.getAnnotation(XmlUnknownQNameEnumValue.class);
            if (unknownQNameEnumValue != null) {
                if (unknownQNameConstant != null) {
                    throw new ValidationException(enumConstant.getPosition(), this.getQualifiedName() + ": no more than two constants can be annotated with @XmlUnknownQNameEnumValue.");
                }
                unknownQNameConstant = enumConstant.getSimpleName();
                continue;
            }
            String ns = namespace;
            String localPart = enumConstant.getSimpleName();
            XmlQNameEnumValue enumValueInfo = (XmlQNameEnumValue)enumConstant.getAnnotation(XmlQNameEnumValue.class);
            if (enumValueInfo != null) {
                if (enumValueInfo.exclude()) continue;
                if (!"##default".equals(enumValueInfo.namespace())) {
                    ns = enumValueInfo.namespace();
                }
                if (!"##default".equals(enumValueInfo.localPart())) {
                    localPart = enumValueInfo.localPart();
                }
            }
            if (!enumValues.add(qname = new QName(ns, localPart))) {
                throw new ValidationException(enumConstant.getPosition(), this.getQualifiedName() + ": duplicate qname enum value: " + qname);
            }
            enumValueMap.put(enumConstant.getSimpleName(), qname);
        }
        if (unknownQNameConstant != null) {
            enumValueMap.put(unknownQNameConstant, null);
        }
        return enumValueMap;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public XmlType getBaseType() {
        return this.isUriBaseType() ? KnownXmlType.ANY_URI : KnownXmlType.QNAME;
    }

    public boolean isUriBaseType() {
        return this.baseType == XmlQNameEnum.BaseType.URI;
    }

    @Override
    public TypeMirror getEnumBaseClass() {
        TypeDeclaration decl = this.isUriBaseType() ? this.getEnv().getTypeDeclaration(URI.class.getName()) : this.getEnv().getTypeDeclaration(QName.class.getName());
        return this.getEnv().getTypeUtils().getDeclaredType(decl, new TypeMirror[0]);
    }

    @Override
    public boolean isSimple() {
        return false;
    }

    @Override
    public boolean isEnum() {
        return true;
    }

    public boolean isQNameEnum() {
        return true;
    }

    @Override
    public ValidationResult accept(BaseValidator validator) {
        return new ValidationResult();
    }
}

