/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.contract.jaxb;

import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.ParameterDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.type.DeclaredType;
import com.sun.mirror.type.MirroredTypeException;
import com.sun.mirror.type.TypeMirror;
import java.util.Collection;
import javax.xml.bind.annotation.XmlElementDecl;
import javax.xml.namespace.QName;
import net.sf.jelly.apt.Context;
import net.sf.jelly.apt.decorations.declaration.DecoratedMethodDeclaration;
import org.codehaus.enunciate.contract.jaxb.ElementDeclaration;
import org.codehaus.enunciate.contract.jaxb.Registry;
import org.codehaus.enunciate.contract.jaxb.types.XmlType;
import org.codehaus.enunciate.contract.jaxb.types.XmlTypeException;
import org.codehaus.enunciate.contract.jaxb.types.XmlTypeFactory;
import org.codehaus.enunciate.contract.validation.ValidationException;

public class LocalElementDeclaration
extends DecoratedMethodDeclaration
implements ElementDeclaration {
    private final TypeDeclaration elementTypeDeclaration;
    private final XmlElementDecl elementDecl;
    private final Registry registry;

    public LocalElementDeclaration(MethodDeclaration delegate, Registry registry) {
        super(delegate);
        this.registry = registry;
        this.elementDecl = (XmlElementDecl)delegate.getAnnotation(XmlElementDecl.class);
        if (this.elementDecl == null) {
            throw new IllegalArgumentException(this.getPosition() + ": a local element declaration must be annotated with @XmlElementDecl.");
        }
        Collection params = this.getParameters();
        if (params.size() != 1) {
            throw new IllegalArgumentException(this.getPosition() + ": a local element declaration must have only one parameter.");
        }
        ParameterDeclaration param = (ParameterDeclaration)params.iterator().next();
        if (!(param.getType() instanceof DeclaredType)) {
            throw new IllegalArgumentException(this.getPosition() + ": parameter type must be a declared type.");
        }
        this.elementTypeDeclaration = ((DeclaredType)param.getType()).getDeclaration();
    }

    @Override
    public String getName() {
        return this.elementDecl.name();
    }

    @Override
    public String getNamespace() {
        String namespace = this.elementDecl.namespace();
        if ("##default".equals(namespace)) {
            namespace = this.registry.getSchema().getNamespace();
        }
        return "".equals(namespace) ? null : namespace;
    }

    @Override
    public QName getQname() {
        return new QName(this.getNamespace(), this.getName());
    }

    public TypeDeclaration getElementScope() {
        TypeDeclaration declaration;
        block3: {
            declaration = null;
            try {
                if (this.elementDecl.scope() != XmlElementDecl.GLOBAL.class) {
                    Class typeClass = this.elementDecl.scope();
                    declaration = this.getEnv().getTypeDeclaration(typeClass.getName());
                }
            }
            catch (MirroredTypeException e) {
                TypeMirror typeMirror = e.getTypeMirror();
                if (!(typeMirror instanceof DeclaredType)) break block3;
                declaration = ((DeclaredType)typeMirror).getDeclaration();
            }
        }
        return declaration;
    }

    public String getSubstitutionHeadName() {
        String shn = this.elementDecl.substitutionHeadName();
        if ("".equals(shn)) {
            shn = null;
        }
        return shn;
    }

    public String getSubstitutionHeadNamespace() {
        String shn = this.elementDecl.substitutionHeadNamespace();
        if ("##default".equals(shn)) {
            shn = this.registry.getSchema().getNamespace();
        }
        return shn;
    }

    public QName getSubstitutionGroupQName() {
        String localPart = this.getSubstitutionHeadName();
        if (localPart == null) {
            return null;
        }
        return new QName(this.getSubstitutionHeadNamespace(), localPart);
    }

    public String getDefaultValue() {
        String defaultValue = this.elementDecl.defaultValue();
        if ("\u0000".equals(defaultValue)) {
            defaultValue = null;
        }
        return defaultValue;
    }

    public TypeDeclaration getElementTypeDeclaration() {
        return this.elementTypeDeclaration;
    }

    public XmlType getElementXmlType() {
        try {
            return XmlTypeFactory.getXmlType(((ParameterDeclaration)this.getParameters().iterator().next()).getType());
        }
        catch (XmlTypeException e) {
            throw new ValidationException(this.getPosition(), "Method " + this.getSimpleName() + " of " + this.registry.getQualifiedName() + ": " + e.getMessage());
        }
    }

    protected AnnotationProcessorEnvironment getEnv() {
        return Context.getCurrentEnvironment();
    }
}

