/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.contract.jaxb;

import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.EnumConstantDeclaration;
import com.sun.mirror.declaration.EnumDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.type.MirroredTypeException;
import com.sun.mirror.type.PrimitiveType;
import com.sun.mirror.type.TypeMirror;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import net.sf.jelly.apt.Context;
import net.sf.jelly.apt.decorations.DeclarationDecorator;
import org.codehaus.enunciate.contract.jaxb.SimpleTypeDefinition;
import org.codehaus.enunciate.contract.jaxb.types.KnownXmlType;
import org.codehaus.enunciate.contract.jaxb.types.XmlType;
import org.codehaus.enunciate.contract.jaxb.types.XmlTypeException;
import org.codehaus.enunciate.contract.jaxb.types.XmlTypeFactory;
import org.codehaus.enunciate.contract.validation.BaseValidator;
import org.codehaus.enunciate.contract.validation.ValidationException;
import org.codehaus.enunciate.contract.validation.ValidationResult;

public class EnumTypeDefinition
extends SimpleTypeDefinition {
    private final XmlEnum xmlEnum = (XmlEnum)this.getAnnotation(XmlEnum.class);
    private final Map<String, Object> enumValues = this.loadEnumValues();

    public EnumTypeDefinition(EnumDeclaration delegate) {
        super((ClassDeclaration)delegate);
    }

    protected Map<String, Object> loadEnumValues() {
        LinkedHashMap<String, Object> enumValueMap = new LinkedHashMap<String, Object>();
        Collection enumConstants = ((EnumDeclaration)this.getDelegate()).getEnumConstants();
        HashSet<String> enumValues = new HashSet<String>(enumConstants.size());
        for (EnumConstantDeclaration enumConstant : enumConstants) {
            String value = enumConstant.getSimpleName();
            XmlEnumValue enumValue = (XmlEnumValue)enumConstant.getAnnotation(XmlEnumValue.class);
            if (enumValue != null) {
                value = enumValue.value();
            }
            if (!enumValues.add(value)) {
                throw new ValidationException(enumConstant.getPosition(), this.getQualifiedName() + ": duplicate enum value: " + value);
            }
            enumValueMap.put(enumConstant.getSimpleName(), value);
        }
        return enumValueMap;
    }

    public Collection<EnumConstantDeclaration> getEnumConstants() {
        Collection realConstants = DeclarationDecorator.decorate((Collection)((EnumDeclaration)this.delegate).getEnumConstants());
        ArrayList<EnumConstantDeclaration> filteredConstants = new ArrayList<EnumConstantDeclaration>();
        for (EnumConstantDeclaration realConstant : realConstants) {
            if (!this.enumValues.containsKey(realConstant.getSimpleName())) continue;
            filteredConstants.add(realConstant);
        }
        return filteredConstants;
    }

    @Override
    public XmlType getBaseType() {
        XmlType xmlType = KnownXmlType.STRING;
        if (this.xmlEnum != null) {
            try {
                try {
                    Class enumClass = this.xmlEnum.value();
                    xmlType = XmlTypeFactory.getXmlType(enumClass);
                }
                catch (MirroredTypeException e) {
                    xmlType = XmlTypeFactory.getXmlType(e.getTypeMirror());
                }
            }
            catch (XmlTypeException e) {
                throw new ValidationException(this.getPosition(), this.getQualifiedName() + ": " + e.getMessage());
            }
        }
        return xmlType;
    }

    public TypeMirror getEnumBaseClass() {
        try {
            Class enumClass = this.xmlEnum == null ? String.class : this.xmlEnum.value();
            return this.getEnumBaseClass(enumClass);
        }
        catch (MirroredTypeException e) {
            return e.getTypeMirror();
        }
    }

    protected TypeMirror getEnumBaseClass(Class enumClass) {
        if (enumClass.isPrimitive()) {
            if (Integer.TYPE == enumClass) {
                return this.getEnv().getTypeUtils().getPrimitiveType(PrimitiveType.Kind.INT);
            }
            if (Boolean.TYPE == enumClass) {
                return this.getEnv().getTypeUtils().getPrimitiveType(PrimitiveType.Kind.BOOLEAN);
            }
            if (Character.TYPE == enumClass) {
                return this.getEnv().getTypeUtils().getPrimitiveType(PrimitiveType.Kind.CHAR);
            }
            if (Byte.TYPE == enumClass) {
                return this.getEnv().getTypeUtils().getPrimitiveType(PrimitiveType.Kind.BYTE);
            }
            if (Short.TYPE == enumClass) {
                return this.getEnv().getTypeUtils().getPrimitiveType(PrimitiveType.Kind.SHORT);
            }
            if (Long.TYPE == enumClass) {
                return this.getEnv().getTypeUtils().getPrimitiveType(PrimitiveType.Kind.LONG);
            }
            if (Float.TYPE == enumClass) {
                return this.getEnv().getTypeUtils().getPrimitiveType(PrimitiveType.Kind.FLOAT);
            }
            if (Double.TYPE == enumClass) {
                return this.getEnv().getTypeUtils().getPrimitiveType(PrimitiveType.Kind.DOUBLE);
            }
            throw new IllegalStateException();
        }
        if (enumClass.isArray()) {
            TypeMirror componentType = this.getEnumBaseClass(enumClass.getComponentType());
            return this.getEnv().getTypeUtils().getArrayType(componentType);
        }
        TypeDeclaration decl = this.getEnv().getTypeDeclaration(enumClass.getName());
        return this.getEnv().getTypeUtils().getDeclaredType(decl, new TypeMirror[0]);
    }

    public Map<String, Object> getEnumValues() {
        return this.enumValues;
    }

    @Override
    public boolean isSimple() {
        return false;
    }

    @Override
    public boolean isEnum() {
        return this.getAnnotation(XmlJavaTypeAdapter.class) == null;
    }

    @Override
    public ValidationResult accept(BaseValidator validator) {
        return validator.validateEnumType(this);
    }

    protected AnnotationProcessorEnvironment getEnv() {
        return Context.getCurrentEnvironment();
    }
}

