/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.contract.jaxb;

import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.MemberDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.type.ArrayType;
import com.sun.mirror.type.DeclaredType;
import com.sun.mirror.type.MirroredTypeException;
import com.sun.mirror.type.PrimitiveType;
import com.sun.mirror.type.TypeMirror;
import com.sun.mirror.util.Types;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElementRefs;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.namespace.QName;
import net.sf.jelly.apt.Context;
import net.sf.jelly.apt.decorations.TypeMirrorDecorator;
import net.sf.jelly.apt.decorations.declaration.DecoratedTypeDeclaration;
import net.sf.jelly.apt.decorations.type.DecoratedTypeMirror;
import net.sf.jelly.apt.freemarker.FreemarkerModel;
import org.codehaus.enunciate.apt.EnunciateFreemarkerModel;
import org.codehaus.enunciate.contract.jaxb.Element;
import org.codehaus.enunciate.contract.jaxb.RootElementDeclaration;
import org.codehaus.enunciate.contract.jaxb.TypeDefinition;
import org.codehaus.enunciate.contract.jaxb.types.XmlType;
import org.codehaus.enunciate.contract.validation.ValidationException;
import org.codehaus.enunciate.json.JsonName;

public class ElementRef
extends Element {
    private final XmlElementRef xmlElementRef;
    private final Collection<ElementRef> choices;
    private final QName ref;
    private boolean isChoice = false;

    public ElementRef(MemberDeclaration delegate, TypeDefinition typedef) {
        super(delegate, typedef, null);
        AbstractCollection choices;
        XmlElementRef xmlElementRef = (XmlElementRef)this.getAnnotation(XmlElementRef.class);
        XmlElementRefs xmlElementRefs = (XmlElementRefs)this.getAnnotation(XmlElementRefs.class);
        if (xmlElementRefs != null) {
            XmlElementRef[] elementRefChoices = xmlElementRefs.value();
            if (elementRefChoices.length == 0) {
                xmlElementRefs = null;
            } else if (xmlElementRef == null && elementRefChoices.length == 1) {
                xmlElementRef = elementRefChoices[0];
                xmlElementRefs = null;
            }
        }
        this.xmlElementRef = xmlElementRef;
        if (xmlElementRefs != null) {
            choices = new ArrayList<ElementRef>();
            for (XmlElementRef elementRef : xmlElementRefs.value()) {
                choices.add(new ElementRef((MemberDeclaration)this.getDelegate(), this.getTypeDefinition(), elementRef));
            }
            this.ref = null;
        } else if (((DecoratedTypeMirror)this.getBareAccessorType()).isInstanceOf(JAXBElement.class.getName())) {
            choices = new ArrayList();
            choices.add(this);
            this.ref = new QName(xmlElementRef.namespace(), xmlElementRef.name());
        } else if (this.isCollectionType()) {
            choices = new CollectionOfElementRefChoices();
            this.ref = null;
        } else {
            choices = new ArrayList();
            choices.add(this);
            this.ref = this.loadRef();
        }
        this.choices = choices;
    }

    protected boolean isInstanceOf(ClassDeclaration classDeclaration, String fqn) {
        AnnotationProcessorEnvironment env = Context.getCurrentEnvironment();
        Types utils = env.getTypeUtils();
        DeclaredType declaredType = utils.getDeclaredType(env.getTypeDeclaration(classDeclaration.getQualifiedName()), new TypeMirror[0]);
        DecoratedTypeMirror decorated = (DecoratedTypeMirror)TypeMirrorDecorator.decorate((TypeMirror)declaredType);
        return decorated.isInstanceOf(fqn);
    }

    protected ElementRef(MemberDeclaration delegate, TypeDefinition typedef, XmlElementRef xmlElementRef) {
        super(delegate, typedef);
        this.xmlElementRef = xmlElementRef;
        this.choices = new ArrayList<ElementRef>();
        this.choices.add(this);
        this.ref = this.loadRef();
        this.isChoice = true;
    }

    private ElementRef(MemberDeclaration delegate, TypeDefinition typedef, RootElementDeclaration ref) {
        super(delegate, typedef);
        this.xmlElementRef = null;
        this.choices = new ArrayList<ElementRef>();
        this.choices.add(this);
        this.ref = new QName(ref.getNamespace(), ref.getName());
        this.isChoice = true;
    }

    protected QName loadRef() {
        DecoratedTypeMirror refType;
        String elementDeclaration;
        TypeDeclaration declaration = null;
        try {
            if (this.xmlElementRef != null && this.xmlElementRef.type() != XmlElementRef.DEFAULT.class) {
                Class typeClass = this.xmlElementRef.type();
                elementDeclaration = typeClass.getName();
                declaration = this.getEnv().getTypeDeclaration(typeClass.getName());
                refType = (DecoratedTypeMirror)TypeMirrorDecorator.decorate((TypeMirror)this.getEnv().getTypeUtils().getDeclaredType(declaration, new TypeMirror[0]));
            } else {
                TypeMirror accessorType = this.getBareAccessorType();
                elementDeclaration = accessorType.toString();
                if (accessorType instanceof DeclaredType) {
                    declaration = ((DeclaredType)accessorType).getDeclaration();
                }
                refType = (DecoratedTypeMirror)TypeMirrorDecorator.decorate((TypeMirror)accessorType);
            }
        }
        catch (MirroredTypeException e) {
            TypeMirror typeMirror = e.getTypeMirror();
            elementDeclaration = typeMirror.toString();
            if (typeMirror instanceof DeclaredType) {
                declaration = ((DeclaredType)typeMirror).getDeclaration();
            }
            refType = (DecoratedTypeMirror)TypeMirrorDecorator.decorate((TypeMirror)typeMirror);
        }
        QName refQName = null;
        if (refType.isInstanceOf(JAXBElement.class.getName())) {
            String namespace;
            String localName = this.xmlElementRef != null && !"##default".equals(this.xmlElementRef.name()) ? this.xmlElementRef.name() : null;
            String string = namespace = this.xmlElementRef != null ? this.xmlElementRef.namespace() : "";
            if (localName == null) {
                throw new ValidationException(this.getPosition(), "Member " + this.getName() + " of " + this.getTypeDefinition().getQualifiedName() + ": @XmlElementRef annotates a type JAXBElement without specifying the name of the JAXB element.");
            }
            refQName = new QName(namespace, localName);
        } else if (declaration instanceof ClassDeclaration && declaration.getAnnotation(XmlRootElement.class) != null) {
            ClassDeclaration classDeclaration = (ClassDeclaration)declaration;
            RootElementDeclaration refElement = new RootElementDeclaration(classDeclaration, ((EnunciateFreemarkerModel)FreemarkerModel.get()).findTypeDefinition(classDeclaration));
            refQName = new QName(refElement.getNamespace(), refElement.getName());
        }
        if (refQName == null) {
            throw new ValidationException(this.getPosition(), "Member " + this.getSimpleName() + " of " + this.getTypeDefinition().getQualifiedName() + ": " + elementDeclaration + " is neither JAXBElement nor a root element declaration.");
        }
        return refQName;
    }

    @Override
    public boolean isElementRefs() {
        return this.ref == null;
    }

    @Override
    public String getName() {
        if (this.isElementRefs()) {
            throw new UnsupportedOperationException("No single reference for this element: multiple choices.");
        }
        return this.ref.getLocalPart();
    }

    @Override
    public String getNamespace() {
        if (this.isElementRefs()) {
            throw new UnsupportedOperationException("No single reference for this element: multiple choices.");
        }
        return "".equals(this.ref.getNamespaceURI()) ? null : this.ref.getNamespaceURI();
    }

    @Override
    public QName getRef() {
        if (this.isElementRefs()) {
            throw new UnsupportedOperationException("No single reference for this element: multiple choices.");
        }
        return this.ref;
    }

    @Override
    public XmlType getBaseType() {
        throw new UnsupportedOperationException("There is no base type for an element ref.");
    }

    @Override
    public boolean isQNameType() {
        return false;
    }

    @Override
    public TypeMirror getAccessorType() {
        Object specifiedType = null;
        try {
            if (this.xmlElementRef != null && this.xmlElementRef.type() != XmlElementRef.DEFAULT.class) {
                Class clazz = this.xmlElementRef.type();
                specifiedType = this.getAccessorType(clazz);
            }
        }
        catch (MirroredTypeException e) {
            specifiedType = TypeMirrorDecorator.decorate((TypeMirror)e.getTypeMirror());
        }
        if (specifiedType != null) {
            if (!this.isChoice) {
                DecoratedTypeMirror accessorType = (DecoratedTypeMirror)super.getAccessorType();
                if (accessorType.isCollection()) {
                    AnnotationProcessorEnvironment ape = Context.getCurrentEnvironment();
                    Types types = ape.getTypeUtils();
                    specifiedType = specifiedType instanceof PrimitiveType ? types.getPrimitiveType(((PrimitiveType)specifiedType).getKind()) : types.getDeclaredType(ape.getTypeDeclaration(((DeclaredType)specifiedType).getDeclaration().getQualifiedName()), new TypeMirror[0]);
                    specifiedType = TypeMirrorDecorator.decorate((TypeMirror)types.getDeclaredType(ape.getTypeDeclaration(((DeclaredType)accessorType).getDeclaration().getQualifiedName()), new TypeMirror[]{specifiedType}));
                } else if (accessorType.isArray() && !(specifiedType instanceof ArrayType)) {
                    Types types = Context.getCurrentEnvironment().getTypeUtils();
                    if (specifiedType instanceof PrimitiveType) {
                        specifiedType = types.getPrimitiveType(((PrimitiveType)specifiedType).getKind());
                    } else {
                        TypeDeclaration decl = ((DeclaredType)specifiedType).getDeclaration();
                        while (decl instanceof DecoratedTypeDeclaration) {
                            decl = (TypeDeclaration)((DecoratedTypeDeclaration)decl).getDelegate();
                        }
                        specifiedType = types.getDeclaredType(decl, new TypeMirror[0]);
                    }
                    specifiedType = TypeMirrorDecorator.decorate((TypeMirror)types.getArrayType(specifiedType));
                }
            }
            return specifiedType;
        }
        return super.getAccessorType();
    }

    @Override
    public boolean isBinaryData() {
        return false;
    }

    @Override
    public boolean isSwaRef() {
        return false;
    }

    @Override
    public boolean isMTOMAttachment() {
        return false;
    }

    @Override
    public boolean isNillable() {
        return false;
    }

    @Override
    public boolean isRequired() {
        return false;
    }

    @Override
    public int getMinOccurs() {
        return this.isRequired() ? 1 : 0;
    }

    public Collection<ElementRef> getChoices() {
        return this.choices;
    }

    protected AnnotationProcessorEnvironment getEnv() {
        return Context.getCurrentEnvironment();
    }

    @Override
    public boolean isElementRef() {
        return true;
    }

    @Override
    public String getJsonMemberName() {
        JsonName jsonName = (JsonName)this.getAnnotation(JsonName.class);
        return jsonName == null ? (this.isElementRefs() ? this.getSimpleName() : this.getName()) : jsonName.value();
    }

    private class CollectionOfElementRefChoices
    extends AbstractCollection<ElementRef> {
        private CollectionOfElementRefChoices() {
        }

        @Override
        public Iterator<ElementRef> iterator() {
            return this.lookupRefs().iterator();
        }

        @Override
        public int size() {
            return this.lookupRefs().size();
        }

        private Collection<ElementRef> lookupRefs() {
            ArrayList<ElementRef> choices = new ArrayList<ElementRef>();
            HashSet<QName> qnamesAdded = new HashSet<QName>();
            TypeMirror typeMirror = ElementRef.this.getBareAccessorType();
            if (typeMirror instanceof DeclaredType) {
                String fqn = ((DeclaredType)typeMirror).getDeclaration().getQualifiedName();
                EnunciateFreemarkerModel model = (EnunciateFreemarkerModel)FreemarkerModel.get();
                for (RootElementDeclaration rootElement : model.getRootElementDeclarations()) {
                    if (!ElementRef.this.isInstanceOf((ClassDeclaration)rootElement, fqn) || !qnamesAdded.add(rootElement.getQname())) continue;
                    choices.add(new ElementRef((MemberDeclaration)ElementRef.this.getDelegate(), ElementRef.this.getTypeDefinition(), rootElement));
                }
            }
            return choices;
        }
    }
}

