/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.contract.jaxb;

import com.sun.mirror.util.SourcePosition;
import java.util.Comparator;
import javax.xml.bind.annotation.XmlAccessOrder;
import org.codehaus.enunciate.contract.jaxb.Element;
import org.codehaus.enunciate.contract.validation.ValidationException;

public class ElementComparator
implements Comparator<Element> {
    private final XmlAccessOrder accessOrder;
    private final String[] propOrder;

    public ElementComparator(String[] propOrder, XmlAccessOrder order) {
        this.accessOrder = order;
        this.propOrder = propOrder;
    }

    @Override
    public int compare(Element accessor1, Element accessor2) {
        int comparison;
        String propertyName1 = accessor1.getSimpleName();
        String propertyName2 = accessor2.getSimpleName();
        if (this.propOrder != null) {
            int propertyIndex1 = this.find(this.propOrder, propertyName1);
            int propertyIndex2 = this.find(this.propOrder, propertyName2);
            if (propertyIndex1 < 0) {
                throw new ValidationException(accessor1.getPosition(), "Property '" + propertyName1 + "' isn't included in the specified property order.");
            }
            if (propertyIndex2 < 0) {
                throw new ValidationException(accessor2.getPosition(), "Property '" + propertyName2 + "' isn't included in the specified property order.");
            }
            return propertyIndex1 - propertyIndex2;
        }
        if (this.accessOrder == XmlAccessOrder.ALPHABETICAL) {
            return propertyName1.compareTo(propertyName2);
        }
        SourcePosition position1 = accessor1.getPosition();
        SourcePosition position2 = accessor2.getPosition();
        if (position1 != null && position2 != null) {
            comparison = position1.line() - position2.line();
            if (comparison == 0) {
                comparison = accessor1.getPosition().column() - accessor2.getPosition().column();
            }
        } else {
            comparison = accessor1.hashCode() - accessor2.hashCode();
        }
        return comparison;
    }

    protected int find(String[] propOrder, String propertyName) {
        for (int i = 0; i < propOrder.length; ++i) {
            if (!propOrder[i].equalsIgnoreCase(propertyName)) continue;
            return i;
        }
        return -1;
    }
}

