/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.contract.jaxb;

import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.MemberDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.type.ArrayType;
import com.sun.mirror.type.DeclaredType;
import com.sun.mirror.type.MirroredTypeException;
import com.sun.mirror.type.PrimitiveType;
import com.sun.mirror.type.TypeMirror;
import com.sun.mirror.util.Types;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlNsForm;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.namespace.QName;
import net.sf.jelly.apt.Context;
import net.sf.jelly.apt.decorations.TypeMirrorDecorator;
import net.sf.jelly.apt.decorations.declaration.DecoratedTypeDeclaration;
import net.sf.jelly.apt.decorations.type.DecoratedTypeMirror;
import org.codehaus.enunciate.contract.jaxb.Accessor;
import org.codehaus.enunciate.contract.jaxb.RootElementDeclaration;
import org.codehaus.enunciate.contract.jaxb.TypeDefinition;
import org.codehaus.enunciate.contract.jaxb.types.XmlClassType;
import org.codehaus.enunciate.contract.jaxb.types.XmlType;
import org.codehaus.enunciate.contract.jaxb.types.XmlTypeException;
import org.codehaus.enunciate.contract.jaxb.types.XmlTypeFactory;
import org.codehaus.enunciate.contract.validation.ValidationException;
import org.codehaus.enunciate.json.JsonName;

public class Element
extends Accessor {
    private final XmlElement xmlElement;
    private final Collection<Element> choices;
    private boolean isChoice = false;

    public Element(MemberDeclaration delegate, TypeDefinition typedef) {
        super(delegate, typedef);
        XmlElement xmlElement = (XmlElement)this.getAnnotation(XmlElement.class);
        XmlElements xmlElements = (XmlElements)this.getAnnotation(XmlElements.class);
        if (xmlElements != null) {
            XmlElement[] elementChoices = xmlElements.value();
            if (elementChoices.length == 0) {
                xmlElements = null;
            } else if (xmlElement == null && elementChoices.length == 1) {
                xmlElement = elementChoices[0];
                xmlElements = null;
            }
        }
        this.xmlElement = xmlElement;
        this.choices = new ArrayList<Element>();
        if (xmlElements != null) {
            for (XmlElement element : xmlElements.value()) {
                try {
                    Class clazz = element.type();
                    if (clazz == null || clazz == XmlElement.DEFAULT.class) {
                        throw new ValidationException(this.getPosition(), "Member " + this.getName() + " of " + typedef.getQualifiedName() + ": an element choice must have its type specified.");
                    }
                    if (clazz.isArray() || Collection.class.isAssignableFrom(clazz)) {
                        throw new ValidationException(this.getPosition(), "Member " + this.getName() + " of " + typedef.getQualifiedName() + ": an element choice must not be a collection or an array.");
                    }
                }
                catch (MirroredTypeException e) {
                    // empty catch block
                }
                this.choices.add(new Element((MemberDeclaration)this.getDelegate(), this.getTypeDefinition(), element));
            }
        } else {
            this.choices.add(this);
        }
    }

    protected Element(MemberDeclaration delegate, TypeDefinition typedef, XmlElement xmlElement) {
        super(delegate, typedef);
        this.xmlElement = xmlElement;
        this.choices = new ArrayList<Element>();
        this.choices.add(this);
        this.isChoice = true;
    }

    @Override
    public String getName() {
        String propertyName = this.getSimpleName();
        if (this.xmlElement != null && !"##default".equals(this.xmlElement.name())) {
            propertyName = this.xmlElement.name();
        }
        return propertyName;
    }

    @Override
    public String getNamespace() {
        String namespace = null;
        if (this.getForm() == XmlNsForm.QUALIFIED) {
            namespace = this.getTypeDefinition().getNamespace();
        }
        if (this.xmlElement != null && !"##default".equals(this.xmlElement.namespace())) {
            namespace = this.xmlElement.namespace();
        }
        return namespace;
    }

    public XmlNsForm getForm() {
        XmlNsForm elementForm = this.getTypeDefinition().getSchema().getElementFormDefault();
        if (elementForm == null || elementForm == XmlNsForm.UNSET) {
            elementForm = XmlNsForm.UNQUALIFIED;
        }
        return elementForm;
    }

    @Override
    public QName getRef() {
        TypeDefinition baseTypeDef;
        QName ref = null;
        boolean qualified = this.getForm() == XmlNsForm.QUALIFIED;
        String typeNamespace = this.getTypeDefinition().getNamespace();
        typeNamespace = typeNamespace == null ? "" : typeNamespace;
        String elementNamespace = this.isWrapped() ? this.getWrapperNamespace() : this.getNamespace();
        String string = elementNamespace = elementNamespace == null ? "" : elementNamespace;
        if (!(elementNamespace.equals(typeNamespace) || !qualified && "".equals(elementNamespace))) {
            return new QName(elementNamespace, this.isWrapped() ? this.getWrapperName() : this.getName());
        }
        XmlType baseType = this.getBaseType();
        if (baseType.isAnonymous() && baseType instanceof XmlClassType && (baseTypeDef = ((XmlClassType)baseType).getTypeDefinition()).getAnnotation(XmlRootElement.class) != null) {
            RootElementDeclaration rootElement = new RootElementDeclaration((ClassDeclaration)baseTypeDef.getDelegate(), baseTypeDef);
            ref = new QName(rootElement.getNamespace(), rootElement.getName());
        }
        return ref;
    }

    @Override
    public TypeMirror getAccessorType() {
        Object specifiedType = null;
        try {
            if (this.xmlElement != null && this.xmlElement.type() != XmlElement.DEFAULT.class) {
                Class clazz = this.xmlElement.type();
                specifiedType = this.getAccessorType(clazz);
            }
        }
        catch (MirroredTypeException e) {
            specifiedType = TypeMirrorDecorator.decorate((TypeMirror)e.getTypeMirror());
        }
        if (specifiedType != null) {
            if (!this.isChoice) {
                DecoratedTypeMirror accessorType = (DecoratedTypeMirror)super.getAccessorType();
                if (accessorType.isCollection()) {
                    AnnotationProcessorEnvironment ape = Context.getCurrentEnvironment();
                    Types types = ape.getTypeUtils();
                    specifiedType = specifiedType instanceof PrimitiveType ? types.getPrimitiveType(((PrimitiveType)specifiedType).getKind()) : types.getDeclaredType(ape.getTypeDeclaration(((DeclaredType)specifiedType).getDeclaration().getQualifiedName()), new TypeMirror[0]);
                    specifiedType = TypeMirrorDecorator.decorate((TypeMirror)types.getDeclaredType(ape.getTypeDeclaration(((DeclaredType)accessorType).getDeclaration().getQualifiedName()), new TypeMirror[]{specifiedType}));
                } else if (accessorType.isArray() && !(specifiedType instanceof ArrayType)) {
                    Types types = Context.getCurrentEnvironment().getTypeUtils();
                    if (specifiedType instanceof PrimitiveType) {
                        specifiedType = types.getPrimitiveType(((PrimitiveType)specifiedType).getKind());
                    } else {
                        TypeDeclaration decl = ((DeclaredType)specifiedType).getDeclaration();
                        while (decl instanceof DecoratedTypeDeclaration) {
                            decl = (TypeDeclaration)((DecoratedTypeDeclaration)decl).getDelegate();
                        }
                        specifiedType = types.getDeclaredType(decl, new TypeMirror[0]);
                    }
                    specifiedType = TypeMirrorDecorator.decorate((TypeMirror)types.getArrayType(specifiedType));
                }
            }
            return specifiedType;
        }
        return super.getAccessorType();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected TypeMirror getAccessorType(Class clazz) {
        PrimitiveType undecorated;
        AnnotationProcessorEnvironment env = Context.getCurrentEnvironment();
        if (clazz.isPrimitive()) {
            if (Boolean.TYPE == clazz) {
                undecorated = env.getTypeUtils().getPrimitiveType(PrimitiveType.Kind.BOOLEAN);
                return TypeMirrorDecorator.decorate((TypeMirror)undecorated);
            } else if (Byte.TYPE == clazz) {
                undecorated = env.getTypeUtils().getPrimitiveType(PrimitiveType.Kind.BYTE);
                return TypeMirrorDecorator.decorate((TypeMirror)undecorated);
            } else if (Character.TYPE == clazz) {
                undecorated = env.getTypeUtils().getPrimitiveType(PrimitiveType.Kind.CHAR);
                return TypeMirrorDecorator.decorate((TypeMirror)undecorated);
            } else if (Double.TYPE == clazz) {
                undecorated = env.getTypeUtils().getPrimitiveType(PrimitiveType.Kind.DOUBLE);
                return TypeMirrorDecorator.decorate((TypeMirror)undecorated);
            } else if (Float.TYPE == clazz) {
                undecorated = env.getTypeUtils().getPrimitiveType(PrimitiveType.Kind.FLOAT);
                return TypeMirrorDecorator.decorate((TypeMirror)undecorated);
            } else if (Integer.TYPE == clazz) {
                undecorated = env.getTypeUtils().getPrimitiveType(PrimitiveType.Kind.INT);
                return TypeMirrorDecorator.decorate((TypeMirror)undecorated);
            } else if (Long.TYPE == clazz) {
                undecorated = env.getTypeUtils().getPrimitiveType(PrimitiveType.Kind.LONG);
                return TypeMirrorDecorator.decorate((TypeMirror)undecorated);
            } else {
                if (Short.TYPE != clazz) throw new IllegalArgumentException("Unknown primitive type: " + clazz.getName());
                undecorated = env.getTypeUtils().getPrimitiveType(PrimitiveType.Kind.SHORT);
            }
            return TypeMirrorDecorator.decorate((TypeMirror)undecorated);
        } else if (clazz.isArray()) {
            undecorated = env.getTypeUtils().getArrayType(this.getAccessorType(clazz.getComponentType()));
            return TypeMirrorDecorator.decorate((TypeMirror)undecorated);
        } else {
            TypeDeclaration typeDeclaration = env.getTypeDeclaration(clazz.getName());
            undecorated = env.getTypeUtils().getDeclaredType(typeDeclaration, new TypeMirror[0]);
        }
        return TypeMirrorDecorator.decorate((TypeMirror)undecorated);
    }

    @Override
    public XmlType getBaseType() {
        if (this.xmlElement != null) {
            Class typeClass = null;
            TypeMirror typeMirror = null;
            try {
                typeClass = this.xmlElement.type();
            }
            catch (MirroredTypeException e) {
                typeMirror = e.getTypeMirror();
            }
            try {
                if (typeClass == null) {
                    return XmlTypeFactory.getXmlType(typeMirror);
                }
                if (typeClass != XmlElement.DEFAULT.class) {
                    return XmlTypeFactory.getXmlType(typeClass);
                }
            }
            catch (XmlTypeException e) {
                throw new ValidationException(this.getPosition(), "Member " + this.getName() + " of " + this.getTypeDefinition().getQualifiedName() + e.getMessage());
            }
        }
        return super.getBaseType();
    }

    public boolean isNillable() {
        boolean nillable = false;
        if (this.xmlElement != null) {
            nillable = this.xmlElement.nillable();
        }
        return nillable;
    }

    public boolean isRequired() {
        boolean required = false;
        if (this.xmlElement != null) {
            required = this.xmlElement.required();
        }
        return required;
    }

    public int getMinOccurs() {
        if (this.isRequired()) {
            return 1;
        }
        TypeMirror accessorType = this.getAccessorType();
        boolean primitive = accessorType instanceof PrimitiveType;
        if (!primitive && accessorType instanceof ArrayType) {
            TypeMirror componentType = ((ArrayType)accessorType).getComponentType();
            primitive = componentType instanceof PrimitiveType && ((PrimitiveType)componentType).getKind() != PrimitiveType.Kind.BYTE;
        }
        return primitive ? 1 : 0;
    }

    public String getMaxOccurs() {
        return this.isCollectionType() ? "unbounded" : "1";
    }

    public String getDefaultValue() {
        String defaultValue = null;
        if (this.xmlElement != null && !"\u0000".equals(this.xmlElement.defaultValue())) {
            defaultValue = this.xmlElement.defaultValue();
        }
        return defaultValue;
    }

    public Collection<? extends Element> getChoices() {
        return this.choices;
    }

    public boolean isWrapped() {
        return this.isCollectionType() && this.getAnnotation(XmlElementWrapper.class) != null;
    }

    public String getWrapperName() {
        String name = this.getSimpleName();
        XmlElementWrapper xmlElementWrapper = (XmlElementWrapper)this.getAnnotation(XmlElementWrapper.class);
        if (xmlElementWrapper != null && !"##default".equals(xmlElementWrapper.name())) {
            name = xmlElementWrapper.name();
        }
        return name;
    }

    public String getWrapperNamespace() {
        XmlElementWrapper xmlElementWrapper;
        String namespace = null;
        if (this.getForm() == XmlNsForm.QUALIFIED) {
            namespace = this.getTypeDefinition().getNamespace();
        }
        if ((xmlElementWrapper = (XmlElementWrapper)this.getAnnotation(XmlElementWrapper.class)) != null && !"##default".equals(xmlElementWrapper.namespace())) {
            namespace = xmlElementWrapper.namespace();
        }
        return namespace;
    }

    public boolean isWrapperNillable() {
        boolean nillable = false;
        XmlElementWrapper xmlElementWrapper = (XmlElementWrapper)this.getAnnotation(XmlElementWrapper.class);
        if (xmlElementWrapper != null) {
            nillable = xmlElementWrapper.nillable();
        }
        return nillable;
    }

    public boolean isElementRefs() {
        return false;
    }

    @Override
    public String getJsonMemberName() {
        JsonName jsonName = (JsonName)this.getAnnotation(JsonName.class);
        return jsonName == null ? (this.isWrapped() ? this.getWrapperName() : this.getName()) : jsonName.value();
    }
}

