/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.contract.jaxb;

import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.FieldDeclaration;
import com.sun.mirror.declaration.MemberDeclaration;
import com.sun.mirror.declaration.Modifier;
import com.sun.mirror.type.AnnotationType;
import java.util.Collection;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import net.sf.jelly.apt.decorations.declaration.DecoratedMethodDeclaration;
import net.sf.jelly.apt.decorations.declaration.PropertyDeclaration;

public class AccessorFilter {
    private final XmlAccessType accessType;

    public AccessorFilter(XmlAccessType accessType) {
        this.accessType = accessType;
        if (accessType == null) {
            throw new IllegalArgumentException("An access type must be specified.");
        }
    }

    public XmlAccessType getAccessType() {
        return this.accessType;
    }

    public boolean accept(MemberDeclaration declaration) {
        if (this.isXmlTransient((Declaration)declaration)) {
            return false;
        }
        if (declaration instanceof PropertyDeclaration) {
            PropertyDeclaration property = (PropertyDeclaration)declaration;
            for (String annotationName : property.getAnnotations().keySet()) {
                if (!annotationName.startsWith("javax.xml.bind.annotation")) continue;
                return true;
            }
            DecoratedMethodDeclaration getter = property.getGetter();
            if (getter == null) {
                return false;
            }
            DecoratedMethodDeclaration setter = property.getSetter();
            if (setter == null) {
                return false;
            }
            if (!getter.getModifiers().contains(Modifier.PUBLIC)) {
                return false;
            }
            if (!setter.getModifiers().contains(Modifier.PUBLIC)) {
                return false;
            }
            return this.accessType != XmlAccessType.NONE && this.accessType != XmlAccessType.FIELD || this.explicitlyDeclaredAccessor(declaration);
        }
        if (declaration instanceof FieldDeclaration) {
            if (declaration.getModifiers().contains(Modifier.STATIC) || declaration.getModifiers().contains(Modifier.TRANSIENT)) {
                return false;
            }
            if (this.accessType == XmlAccessType.NONE || this.accessType == XmlAccessType.PROPERTY) {
                return this.explicitlyDeclaredAccessor(declaration);
            }
            if (this.accessType == XmlAccessType.PUBLIC_MEMBER) {
                return declaration.getModifiers().contains(Modifier.PUBLIC) || this.explicitlyDeclaredAccessor(declaration);
            }
            return true;
        }
        return false;
    }

    protected boolean explicitlyDeclaredAccessor(MemberDeclaration declaration) {
        Collection annotationMirrors = declaration.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            AnnotationTypeDeclaration annotationDeclaration;
            AnnotationType annotationType = annotationMirror.getAnnotationType();
            if (annotationType == null || (annotationDeclaration = annotationType.getDeclaration()) == null || !annotationDeclaration.getQualifiedName().startsWith(XmlElement.class.getPackage().getName())) continue;
            return !annotationDeclaration.getQualifiedName().equals(XmlTransient.class.getName());
        }
        return false;
    }

    protected boolean isXmlTransient(Declaration declaration) {
        return declaration.getAnnotation(XmlTransient.class) != null;
    }
}

