/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.contract.jaxb;

import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.FieldDeclaration;
import com.sun.mirror.declaration.MemberDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.type.ArrayType;
import com.sun.mirror.type.ClassType;
import com.sun.mirror.type.DeclaredType;
import com.sun.mirror.type.MirroredTypeException;
import com.sun.mirror.type.MirroredTypesException;
import com.sun.mirror.type.PrimitiveType;
import com.sun.mirror.type.TypeMirror;
import com.sun.mirror.util.Types;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.bind.annotation.XmlAttachmentRef;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlIDREF;
import javax.xml.bind.annotation.XmlInlineBinaryData;
import javax.xml.bind.annotation.XmlList;
import javax.xml.bind.annotation.XmlMimeType;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.namespace.QName;
import net.sf.jelly.apt.Context;
import net.sf.jelly.apt.decorations.DeclarationDecorator;
import net.sf.jelly.apt.decorations.TypeMirrorDecorator;
import net.sf.jelly.apt.decorations.declaration.DecoratedClassDeclaration;
import net.sf.jelly.apt.decorations.declaration.DecoratedMemberDeclaration;
import net.sf.jelly.apt.decorations.declaration.PropertyDeclaration;
import net.sf.jelly.apt.decorations.type.DecoratedTypeMirror;
import org.codehaus.enunciate.ClientName;
import org.codehaus.enunciate.contract.jaxb.TypeDefinition;
import org.codehaus.enunciate.contract.jaxb.adapters.Adaptable;
import org.codehaus.enunciate.contract.jaxb.adapters.AdapterType;
import org.codehaus.enunciate.contract.jaxb.adapters.AdapterUtil;
import org.codehaus.enunciate.contract.jaxb.types.KnownXmlType;
import org.codehaus.enunciate.contract.jaxb.types.XmlType;
import org.codehaus.enunciate.contract.jaxb.types.XmlTypeException;
import org.codehaus.enunciate.contract.jaxb.types.XmlTypeFactory;
import org.codehaus.enunciate.contract.jaxb.util.JAXBUtil;
import org.codehaus.enunciate.contract.validation.ValidationException;
import org.codehaus.enunciate.qname.XmlQNameEnumRef;
import org.codehaus.enunciate.util.MapType;
import org.codehaus.enunciate.util.MapTypeUtil;

public abstract class Accessor
extends DecoratedMemberDeclaration
implements Adaptable {
    private final TypeDefinition typeDefinition;
    private final AdapterType adapterType;

    public Accessor(MemberDeclaration delegate, TypeDefinition typeDef) {
        super(delegate);
        if (!(delegate instanceof FieldDeclaration) && !(delegate instanceof PropertyDeclaration)) {
            throw new IllegalArgumentException("Only a field or a property can be a JAXB accessor.");
        }
        this.typeDefinition = typeDef;
        this.adapterType = AdapterUtil.findAdapterType((Declaration)this);
    }

    public abstract String getName();

    public abstract String getNamespace();

    public String getClientSimpleName() {
        String clientSimpleName = this.getSimpleName();
        ClientName clientName = (ClientName)this.getAnnotation(ClientName.class);
        if (clientName != null) {
            clientSimpleName = clientName.value();
        }
        return clientSimpleName;
    }

    public TypeMirror getAccessorType() {
        Declaration delegate = this.getDelegate();
        Object accessorType = delegate instanceof FieldDeclaration ? ((FieldDeclaration)delegate).getType() : ((PropertyDeclaration)delegate).getPropertyType();
        TypeMirror bareCollection = JAXBUtil.getNormalizedCollection(accessorType);
        if (bareCollection != null) {
            accessorType = bareCollection;
        } else {
            MapType mapType = MapTypeUtil.findMapType(accessorType);
            if (mapType != null) {
                accessorType = mapType;
            }
        }
        return accessorType;
    }

    public TypeMirror getBareAccessorType() {
        return this.isCollectionType() ? this.getCollectionItemType() : this.getAccessorType();
    }

    public XmlType getBaseType() {
        if (this.isXmlID()) {
            return KnownXmlType.ID;
        }
        if (this.isXmlIDREF()) {
            return KnownXmlType.IDREF;
        }
        if (this.isSwaRef()) {
            return KnownXmlType.SWAREF;
        }
        try {
            XmlType xmlType = XmlTypeFactory.findSpecifiedType(this);
            return xmlType != null ? xmlType : XmlTypeFactory.getXmlType(this.getAccessorType());
        }
        catch (XmlTypeException e) {
            throw new ValidationException(this.getPosition(), "Accessor " + this.getName() + " of " + this.getTypeDefinition().getQualifiedName() + ": " + e.getMessage());
        }
    }

    public QName getRef() {
        return null;
    }

    public TypeDefinition getTypeDefinition() {
        return this.typeDefinition;
    }

    public boolean isXmlList() {
        return this.getAnnotation(XmlList.class) != null;
    }

    public boolean isXmlID() {
        return this.getAnnotation(XmlID.class) != null;
    }

    public boolean isXmlIDREF() {
        return this.getAnnotation(XmlIDREF.class) != null;
    }

    public boolean isBinaryData() {
        return this.isSwaRef() || KnownXmlType.BASE64_BINARY.getQname().equals(this.getBaseType().getQname());
    }

    public boolean isQNameType() {
        return this.getBaseType() == KnownXmlType.QNAME;
    }

    public boolean isSwaRef() {
        return this.getAnnotation(XmlAttachmentRef.class) != null && this.getAccessorType() instanceof DeclaredType && ((DeclaredType)this.getAccessorType()).getDeclaration() != null && "javax.activation.DataHandler".equals(((DeclaredType)this.getAccessorType()).getDeclaration().getQualifiedName());
    }

    public boolean isMTOMAttachment() {
        return this.getAnnotation(XmlInlineBinaryData.class) == null && KnownXmlType.BASE64_BINARY.getQname().equals(this.getBaseType().getQname());
    }

    public String getMimeType() {
        XmlMimeType mimeType = (XmlMimeType)this.getAnnotation(XmlMimeType.class);
        if (mimeType != null) {
            return mimeType.value();
        }
        return null;
    }

    public boolean isCollectionType() {
        if (this.isXmlList()) {
            return false;
        }
        DecoratedTypeMirror accessorType = this.isAdapted() ? (DecoratedTypeMirror)TypeMirrorDecorator.decorate((TypeMirror)this.getAdapterType().getAdaptingType(this.getAccessorType())) : (DecoratedTypeMirror)TypeMirrorDecorator.decorate((TypeMirror)this.getAccessorType());
        if (accessorType.isArray()) {
            TypeMirror componentType = ((ArrayType)accessorType).getComponentType();
            return !(componentType instanceof PrimitiveType) || ((PrimitiveType)componentType).getKind() != PrimitiveType.Kind.BYTE;
        }
        return accessorType.isCollection();
    }

    public TypeMirror getCollectionItemType() {
        DecoratedTypeMirror accessorType = this.isAdapted() ? (DecoratedTypeMirror)TypeMirrorDecorator.decorate((TypeMirror)this.getAdapterType().getAdaptingType(this.getAccessorType())) : (DecoratedTypeMirror)TypeMirrorDecorator.decorate((TypeMirror)this.getAccessorType());
        if (accessorType.isArray()) {
            return ((ArrayType)accessorType).getComponentType();
        }
        if (accessorType.isCollection()) {
            Iterator itemTypes = ((DeclaredType)accessorType).getActualTypeArguments().iterator();
            if (!itemTypes.hasNext()) {
                AnnotationProcessorEnvironment env = Context.getCurrentEnvironment();
                Types typeUtils = env.getTypeUtils();
                return TypeMirrorDecorator.decorate((TypeMirror)typeUtils.getDeclaredType(env.getTypeDeclaration(Object.class.getName()), new TypeMirror[0]));
            }
            return (TypeMirror)itemTypes.next();
        }
        return null;
    }

    public MemberDeclaration getAccessorForXmlID() {
        TypeMirror accessorType;
        if (this.isXmlIDREF() && (accessorType = this.getBareAccessorType()) instanceof ClassType) {
            return this.getXmlIDAccessor((ClassType)accessorType);
        }
        return null;
    }

    private MemberDeclaration getXmlIDAccessor(ClassType classType) {
        ClassDeclaration declaration = classType.getDeclaration();
        if (declaration == null || Object.class.getName().equals(declaration.getQualifiedName())) {
            return null;
        }
        DecoratedClassDeclaration decoratedDeclaration = (DecoratedClassDeclaration)DeclarationDecorator.decorate((Declaration)declaration);
        for (FieldDeclaration field : decoratedDeclaration.getFields()) {
            if (field.getAnnotation(XmlID.class) == null) continue;
            return field;
        }
        for (PropertyDeclaration property : decoratedDeclaration.getProperties()) {
            if (property.getAnnotation(XmlID.class) == null) continue;
            return property;
        }
        return this.getXmlIDAccessor(classType.getSuperclass());
    }

    public Collection<TypeMirror> getSeeAlsos() {
        ArrayList<DeclaredType> seeAlsos = null;
        XmlSeeAlso seeAlsoInfo = (XmlSeeAlso)this.getAnnotation(XmlSeeAlso.class);
        if (seeAlsoInfo != null) {
            seeAlsos = new ArrayList<DeclaredType>();
            try {
                AnnotationProcessorEnvironment env = Context.getCurrentEnvironment();
                for (Class clazz : seeAlsoInfo.value()) {
                    TypeDeclaration typeDeclaration = env.getTypeDeclaration(clazz.getName());
                    DeclaredType undecorated = env.getTypeUtils().getDeclaredType(typeDeclaration, new TypeMirror[0]);
                    seeAlsos.add(undecorated);
                }
            }
            catch (MirroredTypesException e) {
                seeAlsos.addAll(e.getTypeMirrors());
            }
        }
        return seeAlsos;
    }

    @Override
    public boolean isAdapted() {
        return this.adapterType != null;
    }

    @Override
    public AdapterType getAdapterType() {
        return this.adapterType;
    }

    public boolean isAttribute() {
        return false;
    }

    public boolean isValue() {
        return false;
    }

    public boolean isElementRef() {
        return false;
    }

    public boolean isReferencesQNameEnum() {
        return this.getAnnotation(XmlQNameEnumRef.class) != null;
    }

    public TypeMirror getQNameEnumRef() {
        XmlQNameEnumRef enumRef = (XmlQNameEnumRef)this.getAnnotation(XmlQNameEnumRef.class);
        TypeMirror qnameEnumType = null;
        if (enumRef != null) {
            AnnotationProcessorEnvironment env = Context.getCurrentEnvironment();
            try {
                TypeDeclaration decl = env.getTypeDeclaration(enumRef.value().getName());
                qnameEnumType = env.getTypeUtils().getDeclaredType(decl, new TypeMirror[0]);
            }
            catch (MirroredTypeException e) {
                qnameEnumType = e.getTypeMirror();
            }
        }
        return qnameEnumType;
    }

    public Set<String> getReferencedFrom() {
        TreeSet<String> referenceFrom = new TreeSet<String>();
        for (String location : this.typeDefinition.getReferencedFrom()) {
            referenceFrom.add("type definition " + this.typeDefinition.getQualifiedName() + " referenced from " + location);
        }
        return referenceFrom;
    }

    public abstract String getJsonMemberName();
}

