/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jelly.apt.freemarker.FreemarkerModel;
import org.codehaus.enunciate.apt.EnunciateFreemarkerModel;
import org.codehaus.enunciate.config.SchemaInfo;
import org.codehaus.enunciate.contract.jaxws.EndpointInterface;

public class WsdlInfo {
    private String id;
    private String targetNamespace;
    private final Collection<EndpointInterface> endpointInterfaces = new ArrayList<EndpointInterface>();
    private final HashMap<String, Object> properties = new HashMap();

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public void setTargetNamespace(String targetNamespace) {
        this.targetNamespace = targetNamespace;
    }

    public Collection<EndpointInterface> getEndpointInterfaces() {
        return this.endpointInterfaces;
    }

    public void setProperty(String property, Object value) {
        this.properties.put(property, value);
    }

    public Object getProperty(String property) {
        return this.properties.get(property);
    }

    public HashMap<String, Object> getProperties() {
        return this.properties;
    }

    public Set<String> getImportedNamespaces() {
        Collection<EndpointInterface> endpointInterfaces = this.getEndpointInterfaces();
        if (endpointInterfaces == null || endpointInterfaces.size() == 0) {
            throw new IllegalStateException("WSDL for " + this.getTargetNamespace() + " has no endpoint interfaces!");
        }
        HashSet<String> importedNamespaces = new HashSet<String>();
        importedNamespaces.add("http://schemas.xmlsoap.org/wsdl/");
        importedNamespaces.add("http://schemas.xmlsoap.org/wsdl/http/");
        importedNamespaces.add("http://schemas.xmlsoap.org/wsdl/mime/");
        importedNamespaces.add("http://schemas.xmlsoap.org/wsdl/soap/");
        importedNamespaces.add("http://schemas.xmlsoap.org/soap/encoding/");
        importedNamespaces.add("http://www.w3.org/2001/XMLSchema");
        for (EndpointInterface endpointInterface : endpointInterfaces) {
            importedNamespaces.addAll(endpointInterface.getReferencedNamespaces());
        }
        return importedNamespaces;
    }

    public List<SchemaInfo> getImportedSchemas() {
        Set<String> importedNamespaces = this.getImportedNamespaces();
        importedNamespaces.remove(this.getTargetNamespace());
        ArrayList<SchemaInfo> schemas = new ArrayList<SchemaInfo>();
        for (String ns : importedNamespaces) {
            SchemaInfo schema = this.lookupSchema(ns);
            if (schema == null) continue;
            schemas.add(schema);
        }
        return schemas;
    }

    public SchemaInfo getAssociatedSchema() {
        return this.lookupSchema(this.getTargetNamespace());
    }

    protected SchemaInfo lookupSchema(String namespace) {
        if ("".equals(namespace)) {
            namespace = null;
        }
        return this.getNamespacesToSchemas().get(namespace);
    }

    protected Map<String, SchemaInfo> getNamespacesToSchemas() {
        return this.getModel().getNamespacesToSchemas();
    }

    protected EnunciateFreemarkerModel getModel() {
        return (EnunciateFreemarkerModel)FreemarkerModel.get();
    }
}

