/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.config;

import com.sun.mirror.declaration.TypeDeclaration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.namespace.QName;
import net.sf.jelly.apt.freemarker.FreemarkerModel;
import org.codehaus.enunciate.apt.EnunciateFreemarkerModel;
import org.codehaus.enunciate.contract.jaxb.Attribute;
import org.codehaus.enunciate.contract.jaxb.Element;
import org.codehaus.enunciate.contract.jaxb.ImplicitChildElement;
import org.codehaus.enunciate.contract.jaxb.ImplicitRootElement;
import org.codehaus.enunciate.contract.jaxb.ImplicitSchemaAttribute;
import org.codehaus.enunciate.contract.jaxb.ImplicitSchemaElement;
import org.codehaus.enunciate.contract.jaxb.LocalElementDeclaration;
import org.codehaus.enunciate.contract.jaxb.QNameEnumTypeDefinition;
import org.codehaus.enunciate.contract.jaxb.Registry;
import org.codehaus.enunciate.contract.jaxb.RootElementDeclaration;
import org.codehaus.enunciate.contract.jaxb.Schema;
import org.codehaus.enunciate.contract.jaxb.TypeDefinition;
import org.codehaus.enunciate.contract.jaxb.Value;
import org.codehaus.enunciate.contract.jaxb.types.MapXmlType;
import org.codehaus.enunciate.contract.jaxb.types.XmlClassType;
import org.codehaus.enunciate.contract.jaxb.types.XmlType;
import org.codehaus.enunciate.util.TypeDeclarationComparator;

public class SchemaInfo {
    private String id;
    private String namespace;
    private final Collection<ImplicitSchemaElement> implicitSchemaElements = new TreeSet<ImplicitSchemaElement>(new ImplicitSchemaElementComparator());
    private final Collection<ImplicitSchemaAttribute> implicitSchemaAttributes = new TreeSet<ImplicitSchemaAttribute>(new ImplicitSchemaAttributeComparator());
    private final Collection<TypeDefinition> typeDefinitions = new TreeSet<TypeDeclaration>(new TypeDeclarationComparator());
    private final Collection<RootElementDeclaration> globalElements = new TreeSet<TypeDeclaration>(new TypeDeclarationComparator());
    private final Collection<Registry> registries = new ArrayList<Registry>();
    private final Collection<LocalElementDeclaration> localElementDeclarations = new ArrayList<LocalElementDeclaration>();
    private final TreeSet<Schema> packages = new TreeSet();
    private final HashMap<String, Object> properties = new HashMap();

    public boolean isEmptyNamespace() {
        return this.getNamespace() == null || "".equals(this.getNamespace());
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public Collection<TypeDefinition> getTypeDefinitions() {
        return this.typeDefinitions;
    }

    public Collection<ImplicitSchemaElement> getImplicitSchemaElements() {
        return this.implicitSchemaElements;
    }

    public Collection<ImplicitSchemaAttribute> getImplicitSchemaAttributes() {
        return this.implicitSchemaAttributes;
    }

    public Collection<RootElementDeclaration> getGlobalElements() {
        return this.globalElements;
    }

    public Collection<Registry> getRegistries() {
        return this.registries;
    }

    public Collection<LocalElementDeclaration> getLocalElementDeclarations() {
        return this.localElementDeclarations;
    }

    public Set<Schema> getPackages() {
        return this.packages;
    }

    public String getElementFormDefault() {
        for (Schema pckg : this.getPackages()) {
            if (pckg.getElementFormDefault() == null) continue;
            return pckg.getElementFormDefault().toString().toLowerCase();
        }
        return null;
    }

    public String getAttributeFormDefault() {
        for (Schema pckg : this.getPackages()) {
            if (pckg.getAttributeFormDefault() == null) continue;
            return pckg.getAttributeFormDefault().toString().toLowerCase();
        }
        return null;
    }

    public void setProperty(String property, Object value) {
        this.properties.put(property, value);
    }

    public Object getProperty(String property) {
        return this.properties.get(property);
    }

    public HashMap<String, Object> getProperties() {
        return this.properties;
    }

    public Set<String> getReferencedNamespaces() {
        QName typeQName;
        HashSet<String> referencedNamespaces = new HashSet<String>();
        for (TypeDefinition typeDefinition : this.getTypeDefinitions()) {
            this.addReferencedNamespaces(typeDefinition, referencedNamespaces);
        }
        for (RootElementDeclaration rootElement : this.getGlobalElements()) {
            referencedNamespaces.add(rootElement.getNamespace());
            referencedNamespaces.add(rootElement.getTypeDefinition().getNamespace());
        }
        for (ImplicitSchemaElement schemaElement : this.implicitSchemaElements) {
            typeQName = schemaElement.getTypeQName();
            if (typeQName != null) {
                referencedNamespaces.add(typeQName.getNamespaceURI());
            }
            if (!(schemaElement instanceof ImplicitRootElement)) continue;
            for (ImplicitChildElement childElement : ((ImplicitRootElement)schemaElement).getChildElements()) {
                this.addReferencedNamespaces(childElement.getXmlType(), referencedNamespaces);
            }
        }
        for (ImplicitSchemaAttribute schemaAttribute : this.implicitSchemaAttributes) {
            typeQName = schemaAttribute.getTypeQName();
            if (typeQName == null) continue;
            referencedNamespaces.add(typeQName.getNamespaceURI());
        }
        for (LocalElementDeclaration localElementDeclaration : this.localElementDeclarations) {
            typeQName = localElementDeclaration.getElementXmlType().getQname();
            if (typeQName == null) continue;
            referencedNamespaces.add(typeQName.getNamespaceURI());
        }
        referencedNamespaces.add(this.getNamespace());
        referencedNamespaces.remove("http://www.w3.org/2001/XMLSchema");
        if (referencedNamespaces.remove(null)) {
            referencedNamespaces.add("");
        }
        return referencedNamespaces;
    }

    private void addReferencedNamespaces(TypeDefinition typeDefinition, Set<String> referencedNamespaces) {
        for (Attribute attribute : typeDefinition.getAttributes()) {
            QName ref = attribute.getRef();
            if (ref != null) {
                referencedNamespaces.add(ref.getNamespaceURI());
                continue;
            }
            this.addReferencedNamespaces(attribute.getBaseType(), referencedNamespaces);
        }
        for (Element element : typeDefinition.getElements()) {
            for (Element element2 : element.getChoices()) {
                QName ref = element2.getRef();
                if (ref != null) {
                    referencedNamespaces.add(ref.getNamespaceURI());
                    continue;
                }
                this.addReferencedNamespaces(element2.getBaseType(), referencedNamespaces);
            }
        }
        Value value = typeDefinition.getValue();
        if (value != null) {
            this.addReferencedNamespaces(value.getBaseType(), referencedNamespaces);
        }
        if (typeDefinition instanceof QNameEnumTypeDefinition) {
            for (Object qnameValue : ((QNameEnumTypeDefinition)typeDefinition).getEnumValues().values()) {
                QName qName = (QName)qnameValue;
                if (qName == null) continue;
                referencedNamespaces.add(qName.getNamespaceURI());
            }
        }
        this.addReferencedNamespaces(typeDefinition.getBaseType(), referencedNamespaces);
    }

    private void addReferencedNamespaces(XmlType xmlType, Set<String> referencedNamespaces) {
        if (!xmlType.isAnonymous()) {
            referencedNamespaces.add(xmlType.getNamespace());
        } else if (xmlType instanceof MapXmlType) {
            referencedNamespaces.add(((MapXmlType)xmlType).getKeyType().getNamespace());
            referencedNamespaces.add(((MapXmlType)xmlType).getValueType().getNamespace());
        } else if (xmlType instanceof XmlClassType) {
            this.addReferencedNamespaces(((XmlClassType)xmlType).getTypeDefinition(), referencedNamespaces);
        }
    }

    public List<SchemaInfo> getImportedSchemas() {
        Set<String> importedNamespaces = this.getReferencedNamespaces();
        importedNamespaces.remove(this.getNamespace() == null ? "" : this.getNamespace());
        ArrayList<SchemaInfo> schemas = new ArrayList<SchemaInfo>();
        for (String ns : importedNamespaces) {
            SchemaInfo schema = this.lookupSchema(ns);
            if (schema != null) {
                schemas.add(schema);
                continue;
            }
            SchemaInfo schemaInfo = new SchemaInfo();
            schemaInfo.setNamespace(ns);
            schemas.add(schemaInfo);
        }
        return schemas;
    }

    protected SchemaInfo lookupSchema(String namespace) {
        if ("".equals(namespace)) {
            namespace = null;
        }
        return this.getNamespacesToSchemas().get(namespace);
    }

    protected Map<String, SchemaInfo> getNamespacesToSchemas() {
        return this.getModel().getNamespacesToSchemas();
    }

    protected EnunciateFreemarkerModel getModel() {
        return (EnunciateFreemarkerModel)FreemarkerModel.get();
    }

    private static class ImplicitSchemaAttributeComparator
    implements Comparator<ImplicitSchemaAttribute> {
        private ImplicitSchemaAttributeComparator() {
        }

        @Override
        public int compare(ImplicitSchemaAttribute attribute1, ImplicitSchemaAttribute attribute2) {
            return attribute1.getAttributeName().compareTo(attribute2.getAttributeName());
        }
    }

    private static class ImplicitSchemaElementComparator
    implements Comparator<ImplicitSchemaElement> {
        private ImplicitSchemaElementComparator() {
        }

        @Override
        public int compare(ImplicitSchemaElement element1, ImplicitSchemaElement element2) {
            return element1.getElementName().compareTo(element2.getElementName());
        }
    }
}

