/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.Rule;
import org.apache.commons.digester.RuleSet;
import org.apache.commons.digester.parser.GenericParser;
import org.codehaus.enunciate.config.APIImport;
import org.codehaus.enunciate.config.DeploymentModuleComparator;
import org.codehaus.enunciate.config.war.CopyResources;
import org.codehaus.enunciate.config.war.IncludeExcludeLibs;
import org.codehaus.enunciate.config.war.WebAppConfig;
import org.codehaus.enunciate.config.war.WebAppResource;
import org.codehaus.enunciate.contract.validation.DefaultValidator;
import org.codehaus.enunciate.contract.validation.Validator;
import org.codehaus.enunciate.main.webapp.FilterComponent;
import org.codehaus.enunciate.modules.BasicAppModule;
import org.codehaus.enunciate.modules.DeploymentModule;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class EnunciateConfiguration
implements ErrorHandler {
    private String label = "enunciate";
    private String description = null;
    private String generatedCodeLicenseFile = null;
    private String deploymentProtocol = "http";
    private String deploymentHost = "localhost:8080";
    private String deploymentContext = null;
    private String defaultSoapSubcontext = "/soap";
    private String defaultRestSubcontext = "/rest";
    private Validator validator = new DefaultValidator();
    private final SortedSet<DeploymentModule> modules;
    private final Map<String, String> namespaces = new HashMap<String, String>();
    private final Map<String, String> contentTypes = new HashMap<String, String>();
    private final Map<String, String> soapServices2Paths = new HashMap<String, String>();
    private final List<APIImport> apiImports = new ArrayList<APIImport>();
    private final Set<String> disabledRules = new TreeSet<String>();
    private final Set<String> apiIncludePatterns = new TreeSet<String>();
    private final Set<String> apiExcludePatterns = new TreeSet<String>();
    private final Set<String> customResourceParameterAnnotations = new TreeSet<String>();
    private boolean forceJAXWSSpecCompliance = false;
    private boolean allowEmptyNamespace = true;
    private boolean includeReferencedClasses = true;
    private boolean excludeUnreferencedClasses = true;
    private boolean includeReferenceTrailInErrors = false;
    private WebAppConfig webAppConfig;

    public EnunciateConfiguration() {
        this((ClassLoader)null);
    }

    public EnunciateConfiguration(ClassLoader loader) {
        this.modules = new TreeSet<DeploymentModule>(new DeploymentModuleComparator());
        Iterator<DeploymentModule> discoveredModules = this.discoverModules(loader);
        while (discoveredModules.hasNext()) {
            DeploymentModule discoveredModule = discoveredModules.next();
            this.modules.add(discoveredModule);
        }
        this.modules.add(new BasicAppModule());
    }

    protected Iterator<DeploymentModule> discoverModules(ClassLoader loader) {
        return loader == null ? ServiceLoader.load(DeploymentModule.class).iterator() : ServiceLoader.load(DeploymentModule.class, loader).iterator();
    }

    public EnunciateConfiguration(Collection<DeploymentModule> modules) {
        this.modules = new TreeSet<DeploymentModule>(new DeploymentModuleComparator());
        this.modules.addAll(modules);
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getGeneratedCodeLicenseFile() {
        return this.generatedCodeLicenseFile;
    }

    public void setGeneratedCodeLicenseFile(String generatedCodeLicenseFile) {
        this.generatedCodeLicenseFile = generatedCodeLicenseFile;
    }

    public Validator getValidator() {
        return this.validator;
    }

    public void setValidator(Validator validator) {
        this.validator = validator;
    }

    public Set<String> getDisabledRules() {
        return this.disabledRules;
    }

    public void addDisabledRule(String ruleId) {
        if (ruleId != null) {
            this.disabledRules.add(ruleId);
        }
    }

    public Set<String> getApiIncludePatterns() {
        return this.apiIncludePatterns;
    }

    public void addApiIncludePattern(String pattern) {
        if (pattern != null) {
            this.apiIncludePatterns.add(pattern);
        }
    }

    public Set<String> getApiExcludePatterns() {
        return this.apiExcludePatterns;
    }

    public void addApiExcludePattern(String pattern) {
        if (pattern != null) {
            this.apiExcludePatterns.add(pattern);
        }
    }

    public String getDeploymentProtocol() {
        return this.deploymentProtocol;
    }

    public void setDeploymentProtocol(String deploymentProtocol) {
        this.deploymentProtocol = deploymentProtocol;
    }

    public String getDeploymentHost() {
        return this.deploymentHost;
    }

    public void setDeploymentHost(String deploymentHost) {
        this.deploymentHost = deploymentHost;
    }

    public boolean isForceJAXWSSpecCompliance() {
        return this.forceJAXWSSpecCompliance;
    }

    public void setForceJAXWSSpecCompliance(boolean forceJAXWSSpecCompliance) {
        this.forceJAXWSSpecCompliance = forceJAXWSSpecCompliance;
    }

    public boolean isAllowEmptyNamespace() {
        return this.allowEmptyNamespace;
    }

    public void setAllowEmptyNamespace(boolean allowEmptyNamespace) {
        this.allowEmptyNamespace = allowEmptyNamespace;
    }

    public boolean isIncludeReferenceTrailInErrors() {
        return this.includeReferenceTrailInErrors;
    }

    public void setIncludeReferenceTrailInErrors(boolean includeReferenceTrailInErrors) {
        this.includeReferenceTrailInErrors = includeReferenceTrailInErrors;
    }

    public boolean isIncludeReferencedClasses() {
        return this.includeReferencedClasses;
    }

    public void setIncludeReferencedClasses(boolean includeReferencedClasses) {
        this.includeReferencedClasses = includeReferencedClasses;
    }

    public boolean isExcludeUnreferencedClasses() {
        return this.excludeUnreferencedClasses;
    }

    public void setExcludeUnreferencedClasses(boolean excludeUnreferencedClasses) {
        this.excludeUnreferencedClasses = excludeUnreferencedClasses;
    }

    public WebAppConfig getWebAppConfig() {
        return this.webAppConfig;
    }

    public void setWebAppConfig(WebAppConfig webAppConfig) {
        this.webAppConfig = webAppConfig;
    }

    public String getDeploymentContext() {
        return this.deploymentContext;
    }

    public void setDeploymentContext(String deploymentContext) {
        if (deploymentContext == null) {
            deploymentContext = "";
        }
        if (!"".equals(deploymentContext)) {
            if (!deploymentContext.startsWith("/")) {
                deploymentContext = "/" + deploymentContext;
            }
            while (deploymentContext.endsWith("/")) {
                deploymentContext = deploymentContext.substring(0, deploymentContext.length() - 1);
            }
        }
        this.deploymentContext = deploymentContext;
    }

    public void putNamespace(String namespace, String prefix) {
        this.namespaces.put(namespace, prefix);
    }

    public void putContentType(String type, String id) {
        this.contentTypes.put(type, id);
    }

    public String getDefaultSoapSubcontext() {
        return this.defaultSoapSubcontext;
    }

    public void setDefaultSoapSubcontext(String defaultSoapSubcontext) {
        if (defaultSoapSubcontext == null) {
            throw new IllegalArgumentException("The default SOAP context must not be null.");
        }
        if ("".equals(defaultSoapSubcontext)) {
            throw new IllegalArgumentException("The default SOAP context must not be the emtpy string.");
        }
        if (!defaultSoapSubcontext.startsWith("/")) {
            defaultSoapSubcontext = "/" + defaultSoapSubcontext;
        }
        while (defaultSoapSubcontext.endsWith("/")) {
            defaultSoapSubcontext = defaultSoapSubcontext.substring(0, defaultSoapSubcontext.length() - 1);
        }
        this.defaultSoapSubcontext = defaultSoapSubcontext;
    }

    public String getDefaultRestSubcontext() {
        return this.defaultRestSubcontext;
    }

    public void setDefaultRestSubcontext(String defaultRestSubcontext) {
        if (defaultRestSubcontext == null) {
            throw new IllegalArgumentException("The default REST context must not be null.");
        }
        if ("".equals(defaultRestSubcontext)) {
            throw new IllegalArgumentException("The default REST context must not be the emtpy string.");
        }
        if (!defaultRestSubcontext.startsWith("/")) {
            defaultRestSubcontext = "/" + defaultRestSubcontext;
        }
        while (defaultRestSubcontext.endsWith("/")) {
            defaultRestSubcontext = defaultRestSubcontext.substring(0, defaultRestSubcontext.length() - 1);
        }
        this.defaultRestSubcontext = defaultRestSubcontext;
    }

    public void addSoapEndpointLocation(String serviceName, String relativePath) {
        if (serviceName == null) {
            throw new IllegalArgumentException("A service name must be provided for a custom soap endpoint location.");
        }
        if (relativePath != null) {
            if ("".equals(relativePath)) {
                throw new IllegalArgumentException("A relative path for the custom soap location must be provided for the service name '" + serviceName + "'.");
            }
            if (!relativePath.startsWith("/")) {
                relativePath = "/" + relativePath;
            }
            while (relativePath.endsWith("/")) {
                relativePath = relativePath.substring(0, relativePath.length() - 1);
            }
            this.soapServices2Paths.put(serviceName, relativePath);
        }
    }

    public void addAPIImport(APIImport apiImport) {
        this.apiImports.add(apiImport);
    }

    public List<APIImport> getAPIImports() {
        return this.apiImports;
    }

    public Map<String, String> getNamespacesToPrefixes() {
        return this.namespaces;
    }

    public Map<String, String> getContentTypesToIds() {
        return this.contentTypes;
    }

    public Map<String, String> getSoapServices2Paths() {
        return this.soapServices2Paths;
    }

    public SortedSet<DeploymentModule> getAllModules() {
        return this.modules;
    }

    public void addModule(DeploymentModule module) {
        this.modules.add(module);
    }

    public Set<String> getCustomResourceParameterAnnotations() {
        return this.customResourceParameterAnnotations;
    }

    public void addCustomResourceParameterAnnotation(String annotation) {
        this.customResourceParameterAnnotations.add(annotation);
    }

    public List<DeploymentModule> getEnabledModules() {
        ArrayList<DeploymentModule> enabledModules = new ArrayList<DeploymentModule>();
        for (DeploymentModule module : this.getAllModules()) {
            if (module.isDisabled()) continue;
            enabledModules.add(module);
        }
        return enabledModules;
    }

    public void load(File file) throws IOException, SAXException {
        this.load(new FileInputStream(file));
    }

    public void load(InputStream in) throws IOException, SAXException {
        this.load(new InputStreamReader(in, "utf-8"));
    }

    public void load(Reader in) throws IOException, SAXException {
        Digester digester = this.createDigester();
        digester.setErrorHandler((ErrorHandler)this);
        digester.setValidating(false);
        digester.push((Object)this);
        digester.addSetProperties("enunciate");
        digester.addObjectCreate("enunciate/validator", "class", DefaultValidator.class);
        digester.addSetNext("enunciate/validator", "setValidator");
        digester.addSetProperties("enunciate/api-classes");
        digester.addCallMethod("enunciate/api-classes/include", "addApiIncludePattern", 1);
        digester.addCallParam("enunciate/api-classes/include", 0, "pattern");
        digester.addCallMethod("enunciate/api-classes/exclude", "addApiExcludePattern", 1);
        digester.addCallParam("enunciate/api-classes/exclude", 0, "pattern");
        digester.addCallMethod("enunciate/disable-rule", "addDisabledRule", 1);
        digester.addCallParam("enunciate/disable-rule", 0, "id");
        digester.addObjectCreate("enunciate/api-import", APIImport.class);
        digester.addSetProperties("enunciate/api-import", new String[]{"classname", "class", "pattern", "seekSource"}, new String[]{"pattern", "pattern", "pattern", "seekSource"});
        digester.addSetNext("enunciate/api-import", "addAPIImport");
        digester.addSetProperties("enunciate/deployment", new String[]{"protocol", "host", "context"}, new String[]{"deploymentProtocol", "deploymentHost", "deploymentContext"});
        digester.addCallMethod("enunciate/namespaces/namespace", "putNamespace", 2);
        digester.addCallParam("enunciate/namespaces/namespace", 0, "uri");
        digester.addCallParam("enunciate/namespaces/namespace", 1, "id");
        digester.addSetProperties("enunciate/services/rest");
        digester.addCallMethod("enunciate/services/rest/content-types/content-type", "putContentType", 2);
        digester.addCallParam("enunciate/services/rest/content-types/content-type", 0, "type");
        digester.addCallParam("enunciate/services/rest/content-types/content-type", 1, "id");
        digester.addCallMethod("enunciate/services/rest/custom-resource-parameter-annotation", "addCustomResourceParameterAnnotation", 1);
        digester.addCallParam("enunciate/services/rest/custom-resource-parameter-annotation", 0, "qualifiedName");
        digester.addSetProperties("enunciate/services/soap", "defaultSubcontext", "defaultSoapSubcontext");
        digester.addCallMethod("enunciate/services/soap/service", "addSoapEndpointLocation", 2);
        digester.addCallParam("enunciate/services/soap/service", 0, "name");
        digester.addCallParam("enunciate/services/soap/service", 1, "relativePath");
        digester.addObjectCreate("enunciate/webapp", WebAppConfig.class);
        digester.addSetProperties("enunciate/webapp");
        digester.addSetNext("enunciate/webapp", "setWebAppConfig");
        digester.addObjectCreate("enunciate/webapp/resource-env-ref", WebAppResource.class);
        digester.addSetProperties("enunciate/webapp/resource-env-ref");
        digester.addSetNext("enunciate/webapp/resource-env-ref", "addResourceEnvRef");
        digester.addObjectCreate("enunciate/webapp/resource-ref", WebAppResource.class);
        digester.addSetProperties("enunciate/webapp/resource-ref");
        digester.addSetNext("enunciate/webapp/resource-ref", "addResourceRef");
        digester.addObjectCreate("enunciate/webapp/env", WebAppResource.class);
        digester.addSetProperties("enunciate/webapp/env");
        digester.addSetNext("enunciate/webapp/env", "addEnvEntry");
        digester.addCallMethod("enunciate/webapp/attribute", "addWebXmlAttribute", 2);
        digester.addCallParam("enunciate/webapp/attribute", 0, "name");
        digester.addCallParam("enunciate/webapp/attribute", 1, "value");
        digester.addObjectCreate("enunciate/webapp/excludeJar", IncludeExcludeLibs.class);
        digester.addSetProperties("enunciate/webapp/excludeJar");
        digester.addSetNext("enunciate/webapp/excludeJar", "addExcludeLibs");
        digester.addObjectCreate("enunciate/webapp/excludeLibs", IncludeExcludeLibs.class);
        digester.addSetProperties("enunciate/webapp/excludeLibs");
        digester.addSetNext("enunciate/webapp/excludeLibs", "addExcludeLibs");
        digester.addObjectCreate("enunciate/webapp/includeLibs", IncludeExcludeLibs.class);
        digester.addSetProperties("enunciate/webapp/includeLibs");
        digester.addSetNext("enunciate/webapp/includeLibs", "addIncludeLibs");
        digester.addCallMethod("enunciate/webapp/manifest/attribute", "addManifestAttribute", 3);
        digester.addCallParam("enunciate/webapp/manifest/attribute", 0, "section");
        digester.addCallParam("enunciate/webapp/manifest/attribute", 1, "name");
        digester.addCallParam("enunciate/webapp/manifest/attribute", 2, "value");
        digester.addObjectCreate("enunciate/webapp/resources", CopyResources.class);
        digester.addSetProperties("enunciate/webapp/resources");
        digester.addSetNext("enunciate/webapp/resources", "addCopyResources");
        digester.addObjectCreate("enunciate/webapp/globalServletFilter", FilterComponent.class);
        digester.addSetProperties("enunciate/webapp/globalServletFilter");
        digester.addSetNext("enunciate/webapp/globalServletFilter", "addGlobalServletFilter");
        digester.addCallMethod("enunciate/webapp/globalServletFilter/init-param", "addInitParam", 2);
        digester.addCallParam("enunciate/webapp/globalServletFilter/init-param", 0, "name");
        digester.addCallParam("enunciate/webapp/globalServletFilter/init-param", 1, "value");
        for (DeploymentModule module : this.getAllModules()) {
            RuleSet configRules;
            String pattern = String.format("enunciate/modules/%s", module.getName());
            digester.addRule(pattern, (Rule)new PushModuleRule(module));
            digester.addSetProperties(pattern);
            if (module.getAliases() != null) {
                for (String alias : module.getAliases()) {
                    pattern = String.format("enunciate/modules/%s", alias);
                    digester.addRule(pattern, (Rule)new PushModuleRule(module));
                    digester.addSetProperties(pattern);
                }
            }
            if ((configRules = module.getConfigurationRules()) == null) continue;
            digester.addRuleSet(configRules);
        }
        digester.parse(in);
    }

    protected Digester createDigester() throws SAXException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(false);
            factory.setValidating(false);
            Properties properties = new Properties();
            properties.put("SAXParserFactory", factory);
            SAXParser parser = GenericParser.newSAXParser((Properties)properties);
            return new Digester(parser);
        }
        catch (ParserConfigurationException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void warning(SAXParseException warning) throws SAXException {
        System.err.println(warning.getMessage());
    }

    @Override
    public void error(SAXParseException error) throws SAXException {
        throw error;
    }

    @Override
    public void fatalError(SAXParseException fatal) throws SAXException {
        throw fatal;
    }

    private static class PushModuleRule
    extends Rule {
        private final DeploymentModule module;

        public PushModuleRule(DeploymentModule module) {
            this.module = module;
        }

        public void begin(String namespace, String name, Attributes attributes) throws Exception {
            this.getDigester().push((Object)this.module);
        }

        public void end(String namespace, String name) throws Exception {
            this.getDigester().pop();
        }
    }
}

