/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.apt;

import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.EnumDeclaration;
import com.sun.mirror.declaration.InterfaceDeclaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.PackageDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.type.AnnotationType;
import com.sun.mirror.type.ArrayType;
import com.sun.mirror.type.ClassType;
import com.sun.mirror.type.DeclaredType;
import com.sun.mirror.type.EnumType;
import com.sun.mirror.type.InterfaceType;
import com.sun.mirror.type.MirroredTypesException;
import com.sun.mirror.type.PrimitiveType;
import com.sun.mirror.type.ReferenceType;
import com.sun.mirror.type.TypeMirror;
import com.sun.mirror.type.TypeVariable;
import com.sun.mirror.type.VoidType;
import com.sun.mirror.type.WildcardType;
import com.sun.mirror.util.TypeVisitor;
import java.awt.Image;
import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.annotation.XmlNsForm;
import javax.xml.bind.annotation.XmlRegistry;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import net.sf.jelly.apt.Context;
import net.sf.jelly.apt.decorations.TypeMirrorDecorator;
import net.sf.jelly.apt.decorations.type.DecoratedClassType;
import net.sf.jelly.apt.decorations.type.DecoratedInterfaceType;
import net.sf.jelly.apt.decorations.type.DecoratedTypeMirror;
import net.sf.jelly.apt.freemarker.FreemarkerModel;
import org.codehaus.enunciate.apt.GenericTypeDefinition;
import org.codehaus.enunciate.apt.ImplicitAttributeRef;
import org.codehaus.enunciate.apt.ImplicitElementRef;
import org.codehaus.enunciate.apt.ImplicitWrappedElementRef;
import org.codehaus.enunciate.config.EnunciateConfiguration;
import org.codehaus.enunciate.config.SchemaInfo;
import org.codehaus.enunciate.config.WsdlInfo;
import org.codehaus.enunciate.contract.jaxb.Accessor;
import org.codehaus.enunciate.contract.jaxb.Attribute;
import org.codehaus.enunciate.contract.jaxb.ComplexTypeDefinition;
import org.codehaus.enunciate.contract.jaxb.Element;
import org.codehaus.enunciate.contract.jaxb.ElementDeclaration;
import org.codehaus.enunciate.contract.jaxb.ElementRef;
import org.codehaus.enunciate.contract.jaxb.EnumTypeDefinition;
import org.codehaus.enunciate.contract.jaxb.ImplicitChildElement;
import org.codehaus.enunciate.contract.jaxb.ImplicitSchemaAttribute;
import org.codehaus.enunciate.contract.jaxb.ImplicitSchemaElement;
import org.codehaus.enunciate.contract.jaxb.LocalElementDeclaration;
import org.codehaus.enunciate.contract.jaxb.QNameEnumTypeDefinition;
import org.codehaus.enunciate.contract.jaxb.Registry;
import org.codehaus.enunciate.contract.jaxb.RootElementDeclaration;
import org.codehaus.enunciate.contract.jaxb.Schema;
import org.codehaus.enunciate.contract.jaxb.SimpleTypeDefinition;
import org.codehaus.enunciate.contract.jaxb.TypeDefinition;
import org.codehaus.enunciate.contract.jaxb.Value;
import org.codehaus.enunciate.contract.jaxb.adapters.AdapterType;
import org.codehaus.enunciate.contract.jaxb.adapters.AdapterUtil;
import org.codehaus.enunciate.contract.jaxb.types.KnownXmlType;
import org.codehaus.enunciate.contract.jaxrs.JAXRSUtils;
import org.codehaus.enunciate.contract.jaxrs.ResourceEntityParameter;
import org.codehaus.enunciate.contract.jaxrs.ResourceMethod;
import org.codehaus.enunciate.contract.jaxrs.ResourceRepresentationMetadata;
import org.codehaus.enunciate.contract.jaxrs.RootResource;
import org.codehaus.enunciate.contract.jaxws.EndpointInterface;
import org.codehaus.enunciate.contract.jaxws.WebFault;
import org.codehaus.enunciate.contract.jaxws.WebMessage;
import org.codehaus.enunciate.contract.jaxws.WebMessagePart;
import org.codehaus.enunciate.contract.jaxws.WebMethod;
import org.codehaus.enunciate.contract.jaxws.WebParam;
import org.codehaus.enunciate.contract.jaxws.WebResult;
import org.codehaus.enunciate.contract.json.JsonAnyTypeDefinition;
import org.codehaus.enunciate.contract.json.JsonObjectTypeDefinition;
import org.codehaus.enunciate.contract.json.JsonRootElementDeclaration;
import org.codehaus.enunciate.contract.json.JsonSchemaInfo;
import org.codehaus.enunciate.contract.json.JsonSimpleTypeDefinition;
import org.codehaus.enunciate.contract.json.JsonType;
import org.codehaus.enunciate.contract.json.JsonTypeDefinition;
import org.codehaus.enunciate.contract.validation.ValidationException;
import org.codehaus.enunciate.doc.DocumentationExample;
import org.codehaus.enunciate.json.JsonRootType;
import org.codehaus.enunciate.json.JsonTypeMapping;
import org.codehaus.enunciate.json.JsonTypeMappings;
import org.codehaus.enunciate.qname.XmlQNameEnum;
import org.codehaus.enunciate.rest.MimeType;
import org.codehaus.enunciate.util.MapType;
import org.codehaus.enunciate.util.MapTypeUtil;
import org.codehaus.enunciate.util.TypeDeclarationComparator;

public class EnunciateFreemarkerModel
extends FreemarkerModel {
    private static final ThreadLocal<LinkedList<String>> REFERENCE_STACK = new ThreadLocal<LinkedList<String>>(){

        @Override
        protected LinkedList<String> initialValue() {
            return new LinkedList<String>();
        }
    };
    private static final Comparator<TypeDeclaration> CLASS_COMPARATOR = new TypeDeclarationComparator();
    int prefixIndex = 0;
    final Map<String, String> namespacesToPrefixes;
    final Map<String, String> contentTypesToIds;
    final Map<String, SchemaInfo> namespacesToSchemas;
    final Map<String, WsdlInfo> namespacesToWsdls;
    final Map<String, org.codehaus.enunciate.contract.jaxb.types.XmlType> knownTypes;
    final Map<String, JsonType> knownJsonTypes;
    final List<TypeDefinition> typeDefinitions = new ArrayList<TypeDefinition>();
    final List<RootElementDeclaration> rootElements = new ArrayList<RootElementDeclaration>();
    final List<EndpointInterface> endpointInterfaces = new ArrayList<EndpointInterface>();
    final List<RootResource> rootResources = new ArrayList<RootResource>();
    final List<TypeDeclaration> jaxrsProviders = new ArrayList<TypeDeclaration>();
    private File fileOutputDirectory = null;
    private String baseDeploymentAddress = null;
    private EnunciateConfiguration enunciateConfig = null;
    final Map<String, JsonSchemaInfo> idsToJsonSchemas;
    private File wadlFile = null;

    public EnunciateFreemarkerModel() {
        this.namespacesToPrefixes = this.loadKnownNamespaces();
        this.contentTypesToIds = this.loadKnownContentTypes();
        this.knownTypes = this.loadKnownTypes();
        this.knownJsonTypes = this.loadKnownJsonTypes();
        this.namespacesToSchemas = new HashMap<String, SchemaInfo>();
        this.namespacesToWsdls = new HashMap<String, WsdlInfo>();
        this.idsToJsonSchemas = new HashMap<String, JsonSchemaInfo>();
        this.setVariable("knownNamespaces", new ArrayList<String>(this.namespacesToPrefixes.keySet()));
        this.setVariable("ns2prefix", this.namespacesToPrefixes);
        this.setVariable("ns2schema", this.namespacesToSchemas);
        this.setVariable("ns2wsdl", this.namespacesToWsdls);
        this.setVariable("id2JsonSchema", this.idsToJsonSchemas);
        this.setVariable("contentTypes2Ids", this.contentTypesToIds);
        this.setVariable("rootResources", this.rootResources);
        this.setVariable("jaxrsProviders", this.jaxrsProviders);
        this.setVariable("baseDeploymentAddress", "");
    }

    protected HashMap<String, String> loadKnownContentTypes() {
        HashMap<String, String> contentTypes = new HashMap<String, String>();
        contentTypes.put("application/xml", "xml");
        return contentTypes;
    }

    protected Map<String, String> loadKnownNamespaces() {
        HashMap<String, String> knownNamespaces = new HashMap<String, String>();
        knownNamespaces.put("http://schemas.xmlsoap.org/wsdl/", "wsdl");
        knownNamespaces.put("http://schemas.xmlsoap.org/wsdl/http/", "http");
        knownNamespaces.put("http://schemas.xmlsoap.org/wsdl/mime/", "mime");
        knownNamespaces.put("http://schemas.xmlsoap.org/wsdl/soap/", "soap");
        knownNamespaces.put("http://schemas.xmlsoap.org/soap/encoding/", "soapenc");
        knownNamespaces.put("http://www.w3.org/2001/XMLSchema", "xs");
        knownNamespaces.put("http://www.w3.org/2001/XMLSchema-instance", "xsi");
        knownNamespaces.put("http://ws-i.org/profiles/basic/1.1/xsd", "wsi");
        knownNamespaces.put("http://wadl.dev.java.net/2009/02", "wadl");
        knownNamespaces.put("http://www.w3.org/XML/1998/namespace", "xml");
        return knownNamespaces;
    }

    private HashMap<String, JsonType> loadKnownJsonTypes() {
        HashMap<String, JsonType> knownJsonTypes = new HashMap<String, JsonType>();
        knownJsonTypes.put(Boolean.class.getName(), JsonSimpleTypeDefinition.BOOLEAN);
        knownJsonTypes.put(Boolean.TYPE.getName(), JsonSimpleTypeDefinition.BOOLEAN);
        knownJsonTypes.put(Float.class.getName(), JsonSimpleTypeDefinition.NUMBER);
        knownJsonTypes.put(Float.TYPE.getName(), JsonSimpleTypeDefinition.NUMBER);
        knownJsonTypes.put(Double.class.getName(), JsonSimpleTypeDefinition.NUMBER);
        knownJsonTypes.put(Double.TYPE.getName(), JsonSimpleTypeDefinition.NUMBER);
        knownJsonTypes.put(Character.class.getName(), JsonSimpleTypeDefinition.STRING);
        knownJsonTypes.put(Character.TYPE.getName(), JsonSimpleTypeDefinition.STRING);
        knownJsonTypes.put(Byte.class.getName(), JsonSimpleTypeDefinition.NUMBER);
        knownJsonTypes.put(Byte.TYPE.getName(), JsonSimpleTypeDefinition.NUMBER);
        knownJsonTypes.put(Short.class.getName(), JsonSimpleTypeDefinition.NUMBER);
        knownJsonTypes.put(Short.TYPE.getName(), JsonSimpleTypeDefinition.NUMBER);
        knownJsonTypes.put(Integer.class.getName(), JsonSimpleTypeDefinition.NUMBER);
        knownJsonTypes.put(Integer.TYPE.getName(), JsonSimpleTypeDefinition.NUMBER);
        knownJsonTypes.put(Long.class.getName(), JsonSimpleTypeDefinition.NUMBER);
        knownJsonTypes.put(Long.TYPE.getName(), JsonSimpleTypeDefinition.NUMBER);
        knownJsonTypes.put(String.class.getName(), JsonSimpleTypeDefinition.STRING);
        knownJsonTypes.put(BigInteger.class.getName(), JsonSimpleTypeDefinition.NUMBER);
        knownJsonTypes.put(BigDecimal.class.getName(), JsonSimpleTypeDefinition.NUMBER);
        knownJsonTypes.put(Calendar.class.getName(), JsonSimpleTypeDefinition.STRING);
        knownJsonTypes.put(Date.class.getName(), JsonSimpleTypeDefinition.STRING);
        knownJsonTypes.put(URI.class.getName(), JsonSimpleTypeDefinition.STRING);
        knownJsonTypes.put(Object.class.getName(), JsonAnyTypeDefinition.INSTANCE);
        knownJsonTypes.put(byte[].class.getName(), JsonSimpleTypeDefinition.STRING);
        knownJsonTypes.put(UUID.class.getName(), JsonSimpleTypeDefinition.STRING);
        knownJsonTypes.put(GregorianCalendar.class.getName(), JsonSimpleTypeDefinition.STRING);
        knownJsonTypes.put("javax.activation.DataHandler", JsonSimpleTypeDefinition.STRING);
        return knownJsonTypes;
    }

    protected Map<String, org.codehaus.enunciate.contract.jaxb.types.XmlType> loadKnownTypes() {
        HashMap<String, org.codehaus.enunciate.contract.jaxb.types.XmlType> knownTypes = new HashMap<String, org.codehaus.enunciate.contract.jaxb.types.XmlType>();
        knownTypes.put(Boolean.class.getName(), KnownXmlType.BOOLEAN);
        knownTypes.put(Byte.class.getName(), KnownXmlType.BYTE);
        knownTypes.put(Character.class.getName(), KnownXmlType.UNSIGNED_SHORT);
        knownTypes.put(Double.class.getName(), KnownXmlType.DOUBLE);
        knownTypes.put(Float.class.getName(), KnownXmlType.FLOAT);
        knownTypes.put(Integer.class.getName(), KnownXmlType.INT);
        knownTypes.put(Long.class.getName(), KnownXmlType.LONG);
        knownTypes.put(Short.class.getName(), KnownXmlType.SHORT);
        knownTypes.put(Boolean.TYPE.getName(), KnownXmlType.BOOLEAN);
        knownTypes.put(Byte.TYPE.getName(), KnownXmlType.BYTE);
        knownTypes.put(Double.TYPE.getName(), KnownXmlType.DOUBLE);
        knownTypes.put(Float.TYPE.getName(), KnownXmlType.FLOAT);
        knownTypes.put(Integer.TYPE.getName(), KnownXmlType.INT);
        knownTypes.put(Long.TYPE.getName(), KnownXmlType.LONG);
        knownTypes.put(Short.TYPE.getName(), KnownXmlType.SHORT);
        knownTypes.put(Character.TYPE.getName(), KnownXmlType.UNSIGNED_SHORT);
        knownTypes.put(String.class.getName(), KnownXmlType.STRING);
        knownTypes.put(BigInteger.class.getName(), KnownXmlType.INTEGER);
        knownTypes.put(BigDecimal.class.getName(), KnownXmlType.DECIMAL);
        knownTypes.put(Calendar.class.getName(), KnownXmlType.DATE_TIME);
        knownTypes.put(Date.class.getName(), KnownXmlType.DATE_TIME);
        knownTypes.put(QName.class.getName(), KnownXmlType.QNAME);
        knownTypes.put(URI.class.getName(), KnownXmlType.STRING);
        knownTypes.put(Duration.class.getName(), KnownXmlType.DURATION);
        knownTypes.put(Object.class.getName(), KnownXmlType.ANY_TYPE);
        knownTypes.put(byte[].class.getName(), KnownXmlType.BASE64_BINARY);
        knownTypes.put(Image.class.getName(), KnownXmlType.BASE64_BINARY);
        knownTypes.put("javax.activation.DataHandler", KnownXmlType.BASE64_BINARY);
        knownTypes.put(Source.class.getName(), KnownXmlType.BASE64_BINARY);
        knownTypes.put(UUID.class.getName(), KnownXmlType.STRING);
        knownTypes.put(XMLGregorianCalendar.class.getName(), KnownXmlType.DATE_TIME);
        knownTypes.put(GregorianCalendar.class.getName(), KnownXmlType.DATE_TIME);
        return knownTypes;
    }

    public Map<String, String> getNamespacesToPrefixes() {
        return this.namespacesToPrefixes;
    }

    public Map<String, String> getContentTypesToIds() {
        return this.contentTypesToIds;
    }

    public Map<String, SchemaInfo> getNamespacesToSchemas() {
        return this.namespacesToSchemas;
    }

    public Map<String, WsdlInfo> getNamespacesToWSDLs() {
        return this.namespacesToWsdls;
    }

    public Map<String, JsonSchemaInfo> getIdsToJsonSchemas() {
        return this.idsToJsonSchemas;
    }

    public List<RootResource> getRootResources() {
        return this.rootResources;
    }

    public List<TypeDeclaration> getJAXRSProviders() {
        return this.jaxrsProviders;
    }

    public void add(EndpointInterface ei) {
        String namespace = ei.getTargetNamespace();
        String prefix = this.addNamespace(namespace);
        WsdlInfo wsdlInfo = this.namespacesToWsdls.get(namespace);
        if (wsdlInfo == null) {
            wsdlInfo = new WsdlInfo();
            wsdlInfo.setId(prefix);
            this.namespacesToWsdls.put(namespace, wsdlInfo);
            wsdlInfo.setTargetNamespace(namespace);
        }
        for (WebMethod webMethod : ei.getWebMethods()) {
            for (WebMessage webMessage : webMethod.getMessages()) {
                for (WebMessagePart messagePart : webMessage.getParts()) {
                    if (!messagePart.isImplicitSchemaElement()) continue;
                    ImplicitSchemaElement implicitElement = (ImplicitSchemaElement)((Object)messagePart);
                    String particleNamespace = messagePart.getParticleQName().getNamespaceURI();
                    SchemaInfo schemaInfo = this.namespacesToSchemas.get(particleNamespace);
                    if (schemaInfo == null) {
                        schemaInfo = new SchemaInfo();
                        schemaInfo.setId(this.addNamespace(particleNamespace));
                        schemaInfo.setNamespace(particleNamespace);
                        this.namespacesToSchemas.put(particleNamespace, schemaInfo);
                    }
                    schemaInfo.getImplicitSchemaElements().add(implicitElement);
                }
            }
        }
        wsdlInfo.getEndpointInterfaces().add(ei);
        this.endpointInterfaces.add(ei);
        if (this.includeReferencedClasses()) {
            REFERENCE_STACK.get().addFirst("endpoint interface " + ei.getQualifiedName());
            this.addReferencedTypeDefinitions(ei);
            REFERENCE_STACK.get().removeFirst();
        }
    }

    protected boolean includeReferencedClasses() {
        return this.enunciateConfig == null || this.enunciateConfig.isIncludeReferencedClasses();
    }

    public void addJsonType(JsonTypeDefinition typeDefinition) {
        if (!this.knownJsonTypes.containsKey(typeDefinition.getQualifiedName())) {
            JsonSchemaInfo jsonSchemaInfo = this.schemaForType(typeDefinition.classDeclaration());
            if (!jsonSchemaInfo.getTypesByName().containsKey(typeDefinition.getTypeName())) {
                jsonSchemaInfo.getTypesByName().put(typeDefinition.getTypeName(), typeDefinition);
                this.knownJsonTypes.put(typeDefinition.getQualifiedName(), typeDefinition);
            }
            if (this.includeReferencedClasses() && (this.enunciateConfig == null || typeDefinition instanceof JsonObjectTypeDefinition)) {
                JsonObjectTypeDefinition objectTypeDefinition = (JsonObjectTypeDefinition)typeDefinition;
                for (JsonObjectTypeDefinition.JsonPropertyDeclaration property : objectTypeDefinition.getJsonPropertiesByName().values()) {
                    REFERENCE_STACK.get().addFirst("json property " + property.getSimpleName() + " of json object definition " + typeDefinition.getQualifiedName());
                    this.addReferencedJsonTypeDefinitions(property.getPropertyType());
                    REFERENCE_STACK.get().removeFirst();
                }
                ClassType superclass = objectTypeDefinition.getSuperclass();
                if (superclass != null) {
                    REFERENCE_STACK.get().addFirst("json type definition subclass " + typeDefinition.getQualifiedName());
                    this.addJsonType(JsonTypeDefinition.createTypeDefinition(superclass.getDeclaration()));
                    REFERENCE_STACK.get().removeFirst();
                }
            }
        }
    }

    public void add(TypeDefinition typeDef) {
        if (typeDef.getAnnotation(XmlTransient.class) == null) {
            int position;
            if (typeDef.getAnnotation(XmlRootElement.class) != null && Collections.binarySearch(this.rootElements, typeDef, CLASS_COMPARATOR) < 0) {
                this.add(new RootElementDeclaration((ClassDeclaration)typeDef.getDelegate(), typeDef));
            }
            if ((position = Collections.binarySearch(this.typeDefinitions, typeDef, CLASS_COMPARATOR)) < 0 && !this.isKnownType(typeDef)) {
                SchemaInfo referencedSchemaInfo;
                if (this.getEnunciateConfig() != null && this.getEnunciateConfig().isIncludeReferenceTrailInErrors()) {
                    typeDef.getReferencedFrom().add(this.currentReferenceLocation());
                }
                this.typeDefinitions.add(-position - 1, typeDef);
                this.add(typeDef.getSchema());
                String namespace = typeDef.getNamespace();
                String prefix = this.addNamespace(namespace);
                SchemaInfo schemaInfo = this.namespacesToSchemas.get(namespace);
                if (schemaInfo == null) {
                    schemaInfo = new SchemaInfo();
                    schemaInfo.setId(prefix);
                    schemaInfo.setNamespace(namespace);
                    this.namespacesToSchemas.put(namespace, schemaInfo);
                }
                schemaInfo.getTypeDefinitions().add(typeDef);
                REFERENCE_STACK.get().addFirst("\"see also\" annotation");
                this.addSeeAlsoTypeDefinitions((Declaration)typeDef);
                REFERENCE_STACK.get().removeFirst();
                for (Element element : typeDef.getElements()) {
                    ImplicitSchemaElement implicitElement;
                    if (this.includeReferencedClasses()) {
                        REFERENCE_STACK.get().addFirst("accessor " + element.getSimpleName() + " of type definition " + typeDef.getQualifiedName());
                        this.addReferencedTypeDefinitions(element);
                        REFERENCE_STACK.get().removeFirst();
                    }
                    if ((implicitElement = this.getImplicitElement(element)) == null) continue;
                    String implicitElementNamespace = element.isWrapped() ? element.getWrapperNamespace() : element.getNamespace();
                    referencedSchemaInfo = this.namespacesToSchemas.get(implicitElementNamespace);
                    if (referencedSchemaInfo == null) {
                        referencedSchemaInfo = new SchemaInfo();
                        referencedSchemaInfo.setId(this.addNamespace(implicitElementNamespace));
                        referencedSchemaInfo.setNamespace(implicitElementNamespace);
                        this.namespacesToSchemas.put(implicitElementNamespace, referencedSchemaInfo);
                    }
                    referencedSchemaInfo.getImplicitSchemaElements().add(implicitElement);
                }
                for (Attribute attribute : typeDef.getAttributes()) {
                    ImplicitSchemaAttribute implicitAttribute;
                    if (this.includeReferencedClasses()) {
                        REFERENCE_STACK.get().addFirst("accessor " + attribute.getSimpleName() + " of type definition " + typeDef.getQualifiedName());
                        this.addReferencedTypeDefinitions(attribute);
                        REFERENCE_STACK.get().removeFirst();
                    }
                    if ((implicitAttribute = this.getImplicitAttribute(attribute)) == null) continue;
                    String implicitAttributeNamespace = attribute.getNamespace();
                    referencedSchemaInfo = this.namespacesToSchemas.get(implicitAttributeNamespace);
                    if (referencedSchemaInfo == null) {
                        referencedSchemaInfo = new SchemaInfo();
                        referencedSchemaInfo.setId(this.addNamespace(implicitAttributeNamespace));
                        referencedSchemaInfo.setNamespace(implicitAttributeNamespace);
                        this.namespacesToSchemas.put(implicitAttributeNamespace, referencedSchemaInfo);
                    }
                    referencedSchemaInfo.getImplicitSchemaAttributes().add(implicitAttribute);
                }
                if (typeDef.getAnyAttributeQNameEnumRef() != null) {
                    REFERENCE_STACK.get().addFirst("qname enum ref on @XmlAnyAttribute of type definition " + typeDef.getQualifiedName());
                    this.addReferencedTypeDefinitions(typeDef.getAnyAttributeQNameEnumRef());
                    REFERENCE_STACK.get().removeFirst();
                }
                if (this.includeReferencedClasses()) {
                    Value value = typeDef.getValue();
                    if (value != null) {
                        REFERENCE_STACK.get().addFirst("accessor " + value.getSimpleName() + " of type definition " + typeDef.getQualifiedName());
                        this.addReferencedTypeDefinitions(value);
                        REFERENCE_STACK.get().removeFirst();
                    }
                    ClassType superClass = typeDef.getSuperclass();
                    if (!typeDef.isEnum() && superClass != null) {
                        REFERENCE_STACK.get().addFirst("type definition subclass " + typeDef.getQualifiedName());
                        this.addReferencedTypeDefinitions((TypeMirror)superClass);
                        REFERENCE_STACK.get().removeFirst();
                    }
                }
            }
        }
    }

    protected String currentReferenceLocation() {
        StringBuilder builder = new StringBuilder();
        Iterator step = REFERENCE_STACK.get().iterator();
        while (step.hasNext()) {
            String location = (String)step.next();
            builder.append(location);
            if (!step.hasNext()) continue;
            builder.append(" of ");
        }
        return builder.toString();
    }

    protected boolean isKnownType(TypeDefinition typeDef) {
        return this.knownTypes.containsKey(typeDef.getQualifiedName()) || JAXBElement.class.getName().equals(typeDef.getQualifiedName()) || ((DecoratedTypeMirror)typeDef.getSuperclass()).isInstanceOf(JAXBElement.class.getName());
    }

    protected void addReferencedTypeDefinitions(Accessor accessor) {
        this.addSeeAlsoTypeDefinitions((Declaration)accessor);
        TypeMirror enumRef = accessor.getQNameEnumRef();
        if (enumRef != null) {
            this.addReferencedTypeDefinitions(enumRef);
        }
    }

    protected void addReferencedTypeDefinitions(Attribute attribute) {
        this.addReferencedTypeDefinitions((Accessor)attribute);
        this.addReferencedTypeDefinitions((TypeMirror)(attribute.isAdapted() ? attribute.getAdapterType() : attribute.getAccessorType()));
    }

    protected void addReferencedTypeDefinitions(Value value) {
        this.addReferencedTypeDefinitions((Accessor)value);
        this.addReferencedTypeDefinitions((TypeMirror)(value.isAdapted() ? value.getAdapterType() : value.getAccessorType()));
    }

    protected void addReferencedTypeDefinitions(Element element) {
        this.addReferencedTypeDefinitions((Accessor)element);
        if (element instanceof ElementRef && element.isCollectionType()) {
            this.addReferencedTypeDefinitions(element.getAccessorType());
        } else {
            for (Element element2 : element.getChoices()) {
                this.addReferencedTypeDefinitions((TypeMirror)(element2.isAdapted() ? element2.getAdapterType() : element2.getAccessorType()));
            }
        }
    }

    protected ImplicitSchemaElement getImplicitElement(Element element) {
        if (!(element instanceof ElementRef)) {
            boolean qualified = element.getForm() == XmlNsForm.QUALIFIED;
            String typeNamespace = element.getTypeDefinition().getNamespace();
            typeNamespace = typeNamespace == null ? "" : typeNamespace;
            String elementNamespace = element.isWrapped() ? element.getWrapperNamespace() : element.getNamespace();
            String string = elementNamespace = elementNamespace == null ? "" : elementNamespace;
            if (!(elementNamespace.equals(typeNamespace) || !qualified && "".equals(elementNamespace))) {
                return element.isWrapped() ? new ImplicitWrappedElementRef(element) : new ImplicitElementRef(element);
            }
        }
        return null;
    }

    protected ImplicitSchemaAttribute getImplicitAttribute(Attribute attribute) {
        boolean qualified = attribute.getForm() == XmlNsForm.QUALIFIED;
        String typeNamespace = attribute.getTypeDefinition().getNamespace();
        typeNamespace = typeNamespace == null ? "" : typeNamespace;
        String attributeNamespace = attribute.getNamespace();
        String string = attributeNamespace = attributeNamespace == null ? "" : attributeNamespace;
        if (!(attributeNamespace.equals(typeNamespace) || !qualified && "".equals(attributeNamespace))) {
            return new ImplicitAttributeRef(attribute);
        }
        return null;
    }

    public void add(RootResource rootResource) {
        if (this.includeReferencedClasses()) {
            REFERENCE_STACK.get().addFirst("\"see also\" annotation of root resource " + rootResource.getQualifiedName());
            this.addSeeAlsoTypeDefinitions((Declaration)rootResource);
            REFERENCE_STACK.get().removeFirst();
            for (ResourceMethod resourceMethod : rootResource.getResourceMethods(true)) {
                REFERENCE_STACK.get().addFirst("resource method " + resourceMethod.getSimpleName() + " of root resource " + rootResource.getQualifiedName());
                this.addReferencedTypeDefinitions(resourceMethod);
                REFERENCE_STACK.get().removeFirst();
            }
        }
        this.rootResources.add(rootResource);
    }

    protected void addReferencedTypeDefinitions(ResourceMethod resourceMethod) {
        TypeMirror returnType;
        ResourceRepresentationMetadata outputPayload;
        REFERENCE_STACK.get().addFirst("\"see also\" annotation");
        this.addSeeAlsoTypeDefinitions((Declaration)resourceMethod);
        REFERENCE_STACK.get().removeFirst();
        ResourceEntityParameter ep = resourceMethod.getEntityParameter();
        if (ep != null) {
            ClassDeclaration classDeclaration;
            REFERENCE_STACK.get().addFirst("entity parameter " + ep.getSimpleName());
            TypeMirror type = ep.getType();
            if (type instanceof ClassType && (classDeclaration = ((ClassType)type).getDeclaration()) != null) {
                if (classDeclaration.getAnnotation(XmlRootElement.class) != null) {
                    RootElementDeclaration rootElement = new RootElementDeclaration(classDeclaration, this.createTypeDefinition(classDeclaration));
                    this.add(rootElement);
                }
                if (classDeclaration.getAnnotation(JsonRootType.class) != null) {
                    this.addJsonRootElement(new JsonRootElementDeclaration(JsonTypeDefinition.createTypeDefinition(classDeclaration)));
                }
            }
            REFERENCE_STACK.get().removeFirst();
        }
        if ((outputPayload = resourceMethod.getRepresentationMetadata()) != null && (returnType = outputPayload.getDelegate()) instanceof ClassType) {
            REFERENCE_STACK.get().addFirst("return type");
            ClassDeclaration classDeclaration = ((ClassType)returnType).getDeclaration();
            if (classDeclaration != null) {
                if (classDeclaration.getAnnotation(XmlRootElement.class) != null) {
                    RootElementDeclaration rootElement = new RootElementDeclaration(classDeclaration, this.createTypeDefinition(classDeclaration));
                    this.add(rootElement);
                }
                if (classDeclaration.getAnnotation(JsonRootType.class) != null) {
                    this.addJsonRootElement(new JsonRootElementDeclaration(JsonTypeDefinition.createTypeDefinition(classDeclaration)));
                }
            }
            REFERENCE_STACK.get().removeFirst();
        }
    }

    public void addJAXRSProvider(TypeDeclaration declaration) {
        Consumes consumes;
        this.jaxrsProviders.add(declaration);
        Produces produces = (Produces)declaration.getAnnotation(Produces.class);
        if (produces != null) {
            for (String contentType : JAXRSUtils.value(produces)) {
                try {
                    this.addContentType(MimeType.parse((String)contentType).toString());
                }
                catch (Exception e) {
                    this.addContentType(contentType);
                }
            }
        }
        if ((consumes = (Consumes)declaration.getAnnotation(Consumes.class)) != null) {
            for (String contentType : JAXRSUtils.value(consumes)) {
                try {
                    this.addContentType(MimeType.parse((String)contentType).toString());
                }
                catch (Exception e) {
                    this.addContentType(contentType);
                }
            }
        }
    }

    public void addJsonRootElement(RootElementDeclaration rootElement) {
        assert (rootElement != null) : "rootElement must not be null";
        if (rootElement.getAnnotation(XmlTransient.class) == null) {
            this.addJsonRootElement(new JsonRootElementDeclaration(this.createJsonTypeDefinition(rootElement.getTypeDefinition())));
        }
    }

    private JsonTypeDefinition createJsonTypeDefinition(TypeDefinition typeDefinition) {
        assert (typeDefinition != null) : "typeDefinition must not be null";
        JsonTypeDefinition jsonTypeDefinition = JsonTypeDefinition.createTypeDefinition((ClassDeclaration)typeDefinition);
        REFERENCE_STACK.get().addFirst("\"see also\" annotation");
        this.addJsonSeeAlsoTypeDefinitions((Declaration)typeDefinition);
        REFERENCE_STACK.get().removeFirst();
        for (Element element : typeDefinition.getElements()) {
            if (!this.includeReferencedClasses()) continue;
            REFERENCE_STACK.get().addFirst("accessor " + element.getSimpleName() + " of type definition " + typeDefinition.getQualifiedName());
            this.addJsonSeeAlsoTypeDefinitions((Declaration)element);
            for (Element element2 : element.getChoices()) {
                this.addReferencedJsonTypeDefinitions((TypeMirror)(element2.isAdapted() ? element2.getAdapterType() : element2.getAccessorType()));
            }
            REFERENCE_STACK.get().removeFirst();
        }
        for (Attribute attribute : typeDefinition.getAttributes()) {
            if (!this.includeReferencedClasses()) continue;
            REFERENCE_STACK.get().addFirst("accessor " + attribute.getSimpleName() + " of type definition " + typeDefinition.getQualifiedName());
            this.addJsonSeeAlsoTypeDefinitions((Declaration)attribute);
            this.addReferencedJsonTypeDefinitions((TypeMirror)(attribute.isAdapted() ? attribute.getAdapterType() : attribute.getAccessorType()));
            REFERENCE_STACK.get().removeFirst();
        }
        if (this.includeReferencedClasses()) {
            Value value = typeDefinition.getValue();
            if (value != null) {
                REFERENCE_STACK.get().addFirst("accessor " + value.getSimpleName() + " of type definition " + typeDefinition.getQualifiedName());
                this.addJsonSeeAlsoTypeDefinitions((Declaration)value);
                this.addReferencedJsonTypeDefinitions((TypeMirror)(value.isAdapted() ? value.getAdapterType() : value.getAccessorType()));
                REFERENCE_STACK.get().removeFirst();
            }
            ClassType superClass = typeDefinition.getSuperclass();
            if (!typeDefinition.isEnum() && superClass != null) {
                REFERENCE_STACK.get().addFirst("type definition subclass " + typeDefinition.getQualifiedName());
                this.addReferencedJsonTypeDefinitions((TypeMirror)superClass);
                REFERENCE_STACK.get().removeFirst();
            }
        }
        return jsonTypeDefinition;
    }

    public void addJsonRootElement(JsonRootElementDeclaration rootElementDeclaration) {
        JsonTypeDefinition typeDefinition = rootElementDeclaration.getTypeDefinition();
        this.addJsonType(typeDefinition);
        JsonSchemaInfo jsonSchemaInfo = this.schemaForType(typeDefinition.classDeclaration());
        jsonSchemaInfo.getTopLevelTypesByName().put(typeDefinition.getTypeName(), rootElementDeclaration);
    }

    private JsonSchemaInfo schemaForType(ClassDeclaration delegate) {
        String schemaId = JsonSchemaInfo.schemaIdForType(delegate);
        JsonSchemaInfo jsonSchemaInfo = this.getIdsToJsonSchemas().get(schemaId);
        if (jsonSchemaInfo == null) {
            PackageDeclaration schemaPackage = delegate.getPackage();
            jsonSchemaInfo = new JsonSchemaInfo(schemaPackage);
            this.getIdsToJsonSchemas().put(schemaId, jsonSchemaInfo);
            if (schemaPackage.getAnnotation(JsonTypeMapping.class) != null) {
                this.applyJsonTypeMapping((JsonTypeMapping)schemaPackage.getAnnotation(JsonTypeMapping.class));
            } else if (schemaPackage.getAnnotation(JsonTypeMappings.class) != null) {
                for (JsonTypeMapping jsonTypeMapping : ((JsonTypeMappings)schemaPackage.getAnnotation(JsonTypeMappings.class)).value()) {
                    this.applyJsonTypeMapping(jsonTypeMapping);
                }
            }
        }
        return jsonSchemaInfo;
    }

    private void applyJsonTypeMapping(JsonTypeMapping jsonTypeMapping) {
        assert (jsonTypeMapping != null) : "jsonTypeMapping must not be null";
        String jsonType = jsonTypeMapping.jsonType();
        if (jsonType.equalsIgnoreCase(JsonSimpleTypeDefinition.BOOLEAN.getTypeName())) {
            this.knownJsonTypes.put(jsonTypeMapping.javaType(), JsonSimpleTypeDefinition.BOOLEAN);
        } else if (jsonType.equalsIgnoreCase(JsonSimpleTypeDefinition.NUMBER.getTypeName())) {
            this.knownJsonTypes.put(jsonTypeMapping.javaType(), JsonSimpleTypeDefinition.NUMBER);
        } else if (jsonType.equalsIgnoreCase(JsonSimpleTypeDefinition.STRING.getTypeName())) {
            this.knownJsonTypes.put(jsonTypeMapping.javaType(), JsonSimpleTypeDefinition.STRING);
        } else if (jsonType.equalsIgnoreCase(JsonAnyTypeDefinition.INSTANCE.getTypeName())) {
            this.knownJsonTypes.put(jsonTypeMapping.javaType(), JsonAnyTypeDefinition.INSTANCE);
        } else {
            this.knownJsonTypes.put(jsonTypeMapping.javaType(), this.findJsonTypeDefinition(jsonType));
        }
    }

    public void add(RootElementDeclaration rootElement) {
        int position = Collections.binarySearch(this.rootElements, rootElement, CLASS_COMPARATOR);
        if (position < 0) {
            this.rootElements.add(-position - 1, rootElement);
            this.add(rootElement.getSchema());
            String namespace = rootElement.getNamespace();
            String prefix = this.addNamespace(namespace);
            SchemaInfo schemaInfo = this.namespacesToSchemas.get(namespace);
            if (schemaInfo == null) {
                schemaInfo = new SchemaInfo();
                schemaInfo.setId(prefix);
                schemaInfo.setNamespace(namespace);
                this.namespacesToSchemas.put(namespace, schemaInfo);
            }
            schemaInfo.getGlobalElements().add(rootElement);
            if (this.includeReferencedClasses()) {
                REFERENCE_STACK.get().addFirst("root element " + rootElement.getQualifiedName());
                this.addReferencedTypeDefinitions(rootElement);
                REFERENCE_STACK.get().removeFirst();
            }
        }
    }

    protected void addReferencedTypeDefinitions(RootElementDeclaration rootEl) {
        TypeDefinition typeDefinition = rootEl.getTypeDefinition();
        if (typeDefinition != null) {
            this.add(typeDefinition);
        } else {
            this.add(this.createTypeDefinition((ClassDeclaration)rootEl.getDelegate()));
        }
    }

    protected void addReferencedTypeDefinitions(EndpointInterface ei) {
        REFERENCE_STACK.get().addFirst("\"see also\" annotation");
        this.addSeeAlsoTypeDefinitions((Declaration)ei);
        REFERENCE_STACK.get().removeFirst();
        for (WebMethod webMethod : ei.getWebMethods()) {
            REFERENCE_STACK.get().addFirst("method " + webMethod.getSimpleName());
            this.addReferencedTypeDefinitions(webMethod);
            REFERENCE_STACK.get().removeFirst();
        }
    }

    protected void addReferencedTypeDefinitions(WebMethod webMethod) {
        REFERENCE_STACK.get().addFirst("\"see also\" annotation");
        this.addSeeAlsoTypeDefinitions((Declaration)webMethod);
        REFERENCE_STACK.get().removeFirst();
        WebResult result = webMethod.getWebResult();
        REFERENCE_STACK.get().addFirst("return type");
        this.addReferencedTypeDefinitions((TypeMirror)(result.isAdapted() ? result.getAdapterType() : result.getType()));
        REFERENCE_STACK.get().removeFirst();
        for (WebParam webParam : webMethod.getWebParameters()) {
            REFERENCE_STACK.get().addFirst("parameter " + webParam.getSimpleName());
            this.addReferencedTypeDefinitions((TypeMirror)(webParam.isAdapted() ? webParam.getAdapterType() : webParam.getType()));
            REFERENCE_STACK.get().removeFirst();
        }
        for (WebFault webFault : webMethod.getWebFaults()) {
            REFERENCE_STACK.get().addFirst("thrown fault " + webFault.getSimpleName());
            this.addReferencedTypeDefinitions(webFault);
            REFERENCE_STACK.get().removeFirst();
        }
    }

    protected void addReferencedTypeDefinitions(WebFault webFault) {
        if (webFault.isImplicitSchemaElement()) {
            for (ImplicitChildElement childElement : webFault.getChildElements()) {
                WebFault.FaultBeanChildElement fbce = (WebFault.FaultBeanChildElement)childElement;
                REFERENCE_STACK.get().addFirst("property " + fbce.getProperty().getSimpleName());
                this.addReferencedTypeDefinitions((TypeMirror)(fbce.isAdapted() ? fbce.getAdapterType() : fbce.getType()));
                REFERENCE_STACK.get().removeFirst();
            }
        } else {
            REFERENCE_STACK.get().addFirst("explicit fault bean");
            ClassType faultBeanType = webFault.getExplicitFaultBeanType();
            if (faultBeanType != null) {
                this.addReferencedTypeDefinitions((TypeMirror)faultBeanType);
            }
            REFERENCE_STACK.get().removeFirst();
        }
    }

    protected void addReferencedTypeDefinitions(TypeMirror type) {
        type.accept((TypeVisitor)new ReferencedXmlTypeDefinitionVisitor());
    }

    protected void addReferencedJsonTypeDefinitions(TypeMirror type) {
        type.accept((TypeVisitor)new ReferencedJsonTypeDefinitionVisitor());
    }

    protected void addSeeAlsoTypeDefinitions(Declaration declaration) {
        XmlSeeAlso seeAlso = (XmlSeeAlso)declaration.getAnnotation(XmlSeeAlso.class);
        if (seeAlso != null) {
            try {
                Class[] classes = seeAlso.value();
                AnnotationProcessorEnvironment ape = Context.getCurrentEnvironment();
                for (Class clazz : classes) {
                    ClassType type = (ClassType)ape.getTypeUtils().getDeclaredType(ape.getTypeDeclaration(clazz.getName()), new TypeMirror[0]);
                    ClassDeclaration typeDeclaration = type.getDeclaration();
                    if (typeDeclaration == null) continue;
                    this.addSeeAlsoReference(typeDeclaration);
                }
            }
            catch (MirroredTypesException e) {
                Collection mirrors = e.getTypeMirrors();
                for (TypeMirror mirror : mirrors) {
                    ClassDeclaration typeDeclaration;
                    if (!(mirror instanceof ClassType) || (typeDeclaration = ((ClassType)mirror).getDeclaration()) == null) continue;
                    this.addSeeAlsoReference(typeDeclaration);
                }
            }
        }
    }

    protected void addSeeAlsoReference(ClassDeclaration typeDeclaration) {
        if (typeDeclaration.getAnnotation(XmlRegistry.class) == null) {
            this.add(this.createTypeDefinition(typeDeclaration));
        }
    }

    protected void addJsonSeeAlsoTypeDefinitions(Declaration declaration) {
        assert (declaration != null) : "declaration must not be null";
        XmlSeeAlso seeAlso = (XmlSeeAlso)declaration.getAnnotation(XmlSeeAlso.class);
        if (seeAlso != null) {
            try {
                Class[] classes = seeAlso.value();
                AnnotationProcessorEnvironment ape = Context.getCurrentEnvironment();
                for (Class clazz : classes) {
                    ClassType type = (ClassType)ape.getTypeUtils().getDeclaredType(ape.getTypeDeclaration(clazz.getName()), new TypeMirror[0]);
                    ClassDeclaration typeDeclaration = type.getDeclaration();
                    if (typeDeclaration == null) continue;
                    this.addJsonType(JsonTypeDefinition.createTypeDefinition(typeDeclaration));
                }
            }
            catch (MirroredTypesException e) {
                Collection mirrors = e.getTypeMirrors();
                for (TypeMirror mirror : mirrors) {
                    ClassDeclaration typeDeclaration;
                    if (!(mirror instanceof ClassType) || (typeDeclaration = ((ClassType)mirror).getDeclaration()) == null) continue;
                    this.addJsonType(JsonTypeDefinition.createTypeDefinition(typeDeclaration));
                }
            }
        }
    }

    protected TypeDefinition createTypeDefinition(ClassDeclaration declaration) {
        if (this.isEnumType((TypeDeclaration)(declaration = this.narrowToAdaptingType(declaration)))) {
            if (declaration.getAnnotation(XmlQNameEnum.class) != null) {
                return new QNameEnumTypeDefinition((EnumDeclaration)declaration);
            }
            return new EnumTypeDefinition((EnumDeclaration)declaration);
        }
        if (this.isSimpleType((TypeDeclaration)declaration)) {
            return new SimpleTypeDefinition(declaration);
        }
        return new ComplexTypeDefinition(declaration);
    }

    protected ClassDeclaration narrowToAdaptingType(ClassDeclaration declaration) {
        AdapterType adapterType = AdapterUtil.findAdapterType((Declaration)declaration);
        if (adapterType != null) {
            TypeMirror adaptingType = adapterType.getAdaptingType();
            if (!(adaptingType instanceof ClassType)) {
                return declaration;
            }
            ClassDeclaration adaptingDeclaration = ((ClassType)adaptingType).getDeclaration();
            if (adaptingDeclaration == null) {
                throw new ValidationException(declaration.getPosition(), String.format("Class %s is being adapted by a type (%s) that doesn't seem to be on the classpath.", declaration.getQualifiedName(), adaptingType));
            }
            return adaptingDeclaration;
        }
        return declaration;
    }

    protected boolean isComplexType(TypeDeclaration declaration) {
        return !(declaration instanceof InterfaceDeclaration) && !this.isEnumType(declaration) && !this.isSimpleType(declaration);
    }

    protected boolean isEnumType(TypeDeclaration declaration) {
        return declaration instanceof EnumDeclaration;
    }

    protected boolean isSimpleType(TypeDeclaration declaration) {
        if (declaration instanceof InterfaceDeclaration) {
            if (declaration.getAnnotation(XmlType.class) != null) {
                throw new ValidationException(declaration.getPosition(), declaration.getQualifiedName() + ": an interface must not be annotated with @XmlType.");
            }
            return false;
        }
        if (this.isEnumType(declaration)) {
            return false;
        }
        ClassDeclaration classDeclaration = (ClassDeclaration)declaration;
        GenericTypeDefinition typeDef = new GenericTypeDefinition(classDeclaration);
        return typeDef.getValue() != null && this.hasNeitherAttributesNorElements(typeDef);
    }

    protected boolean hasNeitherAttributesNorElements(GenericTypeDefinition typeDef) {
        boolean none = typeDef.getAttributes().isEmpty() && typeDef.getElements().isEmpty();
        ClassDeclaration superDeclaration = ((ClassDeclaration)typeDef.getDelegate()).getSuperclass().getDeclaration();
        if (!Object.class.getName().equals(superDeclaration.getQualifiedName())) {
            none &= this.hasNeitherAttributesNorElements(new GenericTypeDefinition(superDeclaration));
        }
        return none;
    }

    public void add(Registry registry) {
        this.add(registry.getSchema());
        String namespace = registry.getSchema().getNamespace();
        String prefix = this.addNamespace(namespace);
        SchemaInfo schemaInfo = this.namespacesToSchemas.get(namespace);
        if (schemaInfo == null) {
            schemaInfo = new SchemaInfo();
            schemaInfo.setId(prefix);
            schemaInfo.setNamespace(namespace);
            this.namespacesToSchemas.put(namespace, schemaInfo);
        }
        schemaInfo.getRegistries().add(registry);
        REFERENCE_STACK.get().addFirst("registry " + registry.getQualifiedName());
        this.addReferencedTypeDefinitions(registry);
        for (LocalElementDeclaration led : registry.getLocalElementDeclarations()) {
            REFERENCE_STACK.get().addFirst("method " + led.getSimpleName());
            this.add(led);
            REFERENCE_STACK.get().removeFirst();
        }
        REFERENCE_STACK.get().removeFirst();
    }

    protected void addReferencedTypeDefinitions(Registry registry) {
        REFERENCE_STACK.get().addFirst("\"see also\" annotation");
        this.addSeeAlsoTypeDefinitions((Declaration)registry);
        REFERENCE_STACK.get().removeFirst();
        for (MethodDeclaration methodDeclaration : registry.getInstanceFactoryMethods()) {
            REFERENCE_STACK.get().addFirst("method " + methodDeclaration.getSimpleName());
            this.addReferencedTypeDefinitions(methodDeclaration.getReturnType());
            REFERENCE_STACK.get().removeFirst();
        }
    }

    public void add(LocalElementDeclaration led) {
        String namespace = led.getNamespace();
        String prefix = this.addNamespace(namespace);
        SchemaInfo schemaInfo = this.namespacesToSchemas.get(namespace);
        if (schemaInfo == null) {
            schemaInfo = new SchemaInfo();
            schemaInfo.setId(prefix);
            schemaInfo.setNamespace(namespace);
            this.namespacesToSchemas.put(namespace, schemaInfo);
        }
        schemaInfo.getLocalElementDeclarations().add(led);
        this.addReferencedTypeDefinitions(led);
    }

    protected void addReferencedTypeDefinitions(LocalElementDeclaration led) {
        TypeDeclaration typeDeclaration;
        this.addSeeAlsoTypeDefinitions(led);
        TypeDeclaration scope = led.getElementScope();
        if (scope instanceof ClassDeclaration) {
            REFERENCE_STACK.get().addFirst("scope");
            this.add(this.createTypeDefinition((ClassDeclaration)scope));
            REFERENCE_STACK.get().removeFirst();
        }
        if ((typeDeclaration = led.getElementTypeDeclaration()) instanceof ClassDeclaration) {
            this.add(this.createTypeDefinition((ClassDeclaration)typeDeclaration));
        }
    }

    public void add(Schema schema) {
        String namespace = schema.getNamespace();
        String prefix = this.addNamespace(namespace);
        this.namespacesToPrefixes.putAll(schema.getSpecifiedNamespacePrefixes());
        SchemaInfo schemaInfo = this.namespacesToSchemas.get(namespace);
        if (schemaInfo == null) {
            schemaInfo = new SchemaInfo();
            schemaInfo.setId(prefix);
            schemaInfo.setNamespace(namespace);
            this.namespacesToSchemas.put(namespace, schemaInfo);
        }
        if (schema.getElementFormDefault() != XmlNsForm.UNSET) {
            for (Schema pckg : schemaInfo.getPackages()) {
                if (pckg.getElementFormDefault() == null || schema.getElementFormDefault() == pckg.getElementFormDefault()) continue;
                throw new ValidationException(schema.getPosition(), schema.getQualifiedName() + ": inconsistent elementFormDefault declarations: " + pckg.getQualifiedName());
            }
        }
        if (schema.getAttributeFormDefault() != XmlNsForm.UNSET) {
            for (Schema pckg : schemaInfo.getPackages()) {
                if (pckg.getAttributeFormDefault() == null || schema.getAttributeFormDefault() == pckg.getAttributeFormDefault()) continue;
                throw new ValidationException(schema.getPosition(), schema.getQualifiedName() + ": inconsistent attributeFormDefault declarations: " + pckg.getQualifiedName());
            }
        }
        schemaInfo.getPackages().add(schema);
    }

    public String addNamespace(String namespace) {
        String prefix = this.namespacesToPrefixes.get(namespace);
        if (prefix == null) {
            prefix = this.generatePrefix(namespace);
            this.namespacesToPrefixes.put(namespace, prefix);
        }
        return prefix;
    }

    public void addContentType(String contentType) {
        String id;
        if (!this.contentTypesToIds.containsKey(contentType) && (id = this.getDefaultContentTypeId(contentType)) != null) {
            this.contentTypesToIds.put(contentType, id);
        }
    }

    protected String getDefaultContentTypeId(String contentType) {
        int plus;
        int lastSlash;
        String id = contentType;
        if (id.endsWith("/")) {
            throw new IllegalArgumentException("Illegal content type: " + id);
        }
        int semiColon = id.indexOf(59);
        if (semiColon > -1) {
            id = id.substring(0, semiColon);
        }
        if ((lastSlash = id.lastIndexOf(47)) > -1) {
            id = id.substring(lastSlash + 1);
        }
        if ((plus = id.indexOf(43)) > -1) {
            id = id.substring(0, plus);
        }
        if (id.contains("*")) {
            return null;
        }
        return id;
    }

    protected String generatePrefix(String namespace) {
        String prefix = "ns" + this.prefixIndex++;
        while (this.namespacesToPrefixes.values().contains(prefix)) {
            prefix = "ns" + this.prefixIndex++;
        }
        return prefix;
    }

    public org.codehaus.enunciate.contract.jaxb.types.XmlType getKnownType(DeclaredType declaredType) {
        org.codehaus.enunciate.contract.jaxb.types.XmlType knownType = null;
        TypeDeclaration declaration = declaredType.getDeclaration();
        if (declaration != null && this.knownTypes.containsKey(declaration.getQualifiedName())) {
            knownType = this.getKnownType(declaration);
        }
        return knownType;
    }

    public org.codehaus.enunciate.contract.jaxb.types.XmlType getKnownType(TypeDeclaration declaration) {
        if (declaration.getAnnotation(XmlTransient.class) != null) {
            return KnownXmlType.ANY_TYPE;
        }
        return this.knownTypes.get(declaration.getQualifiedName());
    }

    public JsonType findJsonTypeDefinition(String qualifiedName) {
        return this.knownJsonTypes.get(qualifiedName);
    }

    public JsonType findJsonTypeDefinition(ClassDeclaration declaration) {
        assert (declaration != null);
        return this.knownJsonTypes.get(declaration.getQualifiedName());
    }

    public TypeDefinition findTypeDefinition(ClassDeclaration declaration) {
        int index = Collections.binarySearch(this.typeDefinitions, declaration, CLASS_COMPARATOR);
        if (index >= 0) {
            return this.typeDefinitions.get(index);
        }
        return null;
    }

    public JsonRootElementDeclaration findJsonRootElementDeclaration(ClassDeclaration declaration) {
        assert (declaration != null);
        JsonType jsonTypeDefinition = this.knownJsonTypes.get(declaration.getQualifiedName());
        if (jsonTypeDefinition == null) {
            return null;
        }
        String schemaId = JsonSchemaInfo.schemaIdForType(declaration);
        return this.idsToJsonSchemas.get(schemaId).getTopLevelTypesByName().get(jsonTypeDefinition.getTypeName());
    }

    public RootElementDeclaration findRootElementDeclaration(ClassDeclaration declaration) {
        int index = Collections.binarySearch(this.rootElements, declaration, CLASS_COMPARATOR);
        if (index >= 0) {
            return this.rootElements.get(index);
        }
        return null;
    }

    public LocalElementDeclaration findLocalElementDeclaration(ClassDeclaration declaration) {
        if (declaration.getPackage() != null) {
            String packageName = declaration.getPackage().getQualifiedName();
            for (SchemaInfo schemaInfo : this.namespacesToSchemas.values()) {
                for (Registry registry : schemaInfo.getRegistries()) {
                    if (!registry.getSchema().getQualifiedName().equals(packageName)) continue;
                    for (LocalElementDeclaration localElement : registry.getLocalElementDeclarations()) {
                        if (localElement.getElementTypeDeclaration() == null || !localElement.getElementTypeDeclaration().getQualifiedName().equals(declaration.getQualifiedName())) continue;
                        return localElement;
                    }
                }
            }
        }
        return null;
    }

    public ElementDeclaration findElementDeclaration(ClassDeclaration declaration) {
        RootElementDeclaration rootDeclaration = this.findRootElementDeclaration(declaration);
        return rootDeclaration == null ? this.findLocalElementDeclaration(declaration) : rootDeclaration;
    }

    public ResourceMethod findExampleResourceMethod() {
        ResourceMethod example = null;
        List<RootResource> resources = this.getRootResources();
        for (RootResource root : resources) {
            List<ResourceMethod> methods = root.getResourceMethods(true);
            for (ResourceMethod method : methods) {
                if (method.getAnnotation(DocumentationExample.class) != null && !((DocumentationExample)method.getAnnotation(DocumentationExample.class)).exclude()) {
                    return method;
                }
                if (method.getRepresentationMetadata() == null || method.getRepresentationMetadata().getXmlElement() == null) continue;
                if (method.getEntityParameter() != null && method.getEntityParameter().getXmlElement() != null) {
                    return method;
                }
                example = example == null ? method : example;
            }
        }
        return example;
    }

    public WebMethod findExampleWebMethod() {
        WebMethod example = null;
        for (EndpointInterface ei : this.endpointInterfaces) {
            for (WebMethod method : ei.getWebMethods()) {
                if (method.getAnnotation(DocumentationExample.class) != null && !((DocumentationExample)method.getAnnotation(DocumentationExample.class)).exclude()) {
                    return method;
                }
                if (method.getWebResult() != null && method.getWebResult().getType() instanceof DeclaredType && (example == null || example.getWebResult() == null || !(example.getWebResult().getType() instanceof DeclaredType))) {
                    example = method;
                    continue;
                }
                example = example == null ? method : example;
            }
        }
        return example;
    }

    public List<TypeDefinition> getTypeDefinitions() {
        return this.typeDefinitions;
    }

    public List<EndpointInterface> getEndpointInterfaces() {
        return this.endpointInterfaces;
    }

    public List<RootElementDeclaration> getRootElementDeclarations() {
        return this.rootElements;
    }

    public File getFileOutputDirectory() {
        return this.fileOutputDirectory;
    }

    public void setFileOutputDirectory(File fileOutputDirectory) {
        this.fileOutputDirectory = fileOutputDirectory;
    }

    public File getWadlFile() {
        return this.wadlFile;
    }

    public void setWadlFile(File wadlFile) {
        this.wadlFile = wadlFile;
        this.setVariable("wadlFile", wadlFile);
        this.setVariable("wadlFilename", wadlFile.getName());
    }

    public String getBaseDeploymentAddress() {
        return this.baseDeploymentAddress;
    }

    public void setBaseDeploymentAddress(String baseDeploymentAddress) {
        this.baseDeploymentAddress = baseDeploymentAddress;
        this.setVariable("baseDeploymentAddress", baseDeploymentAddress);
    }

    public EnunciateConfiguration getEnunciateConfig() {
        return this.enunciateConfig;
    }

    public void setEnunciateConfig(EnunciateConfiguration enunciateConfig) {
        this.enunciateConfig = enunciateConfig;
    }

    private class ReferencedXmlTypeDefinitionVisitor
    extends DefaultReferencedTypeVisitor {
        private final LinkedList<String> referenceStack;

        private ReferencedXmlTypeDefinitionVisitor() {
            this.referenceStack = new LinkedList();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitClassType(ClassType classType) {
            if (classType instanceof AdapterType) {
                ((AdapterType)classType).getAdaptingType().accept((TypeVisitor)this);
            } else if (MapTypeUtil.findMapType((TypeMirror)classType) == null) {
                DecoratedClassType decorated = (DecoratedClassType)TypeMirrorDecorator.decorate((TypeMirror)classType);
                String qualifiedName = decorated.getDeclaration().getQualifiedName();
                if (decorated.getDeclaration() != null && Object.class.getName().equals(qualifiedName)) {
                    return;
                }
                if (this.referenceStack.contains(qualifiedName)) {
                    return;
                }
                this.referenceStack.addFirst(qualifiedName);
                try {
                    Collection typeArgs;
                    ClassDeclaration declaration;
                    if (!decorated.isCollection() && !decorated.isInstanceOf(JAXBElement.class.getName()) && (declaration = classType.getDeclaration()) != null) {
                        EnunciateFreemarkerModel.this.add(EnunciateFreemarkerModel.this.createTypeDefinition(declaration));
                    }
                    if ((typeArgs = classType.getActualTypeArguments()) != null) {
                        for (TypeMirror typeArg : typeArgs) {
                            typeArg.accept((TypeVisitor)this);
                        }
                    }
                }
                finally {
                    this.referenceStack.removeFirst();
                }
            }
        }

        @Override
        public void visitEnumType(EnumType enumType) {
            EnumDeclaration enumDeclaration = enumType.getDeclaration();
            if (enumDeclaration != null) {
                EnunciateFreemarkerModel.this.add(EnunciateFreemarkerModel.this.createTypeDefinition((ClassDeclaration)enumDeclaration));
            }
        }
    }

    private class ReferencedJsonTypeDefinitionVisitor
    extends DefaultReferencedTypeVisitor {
        private final LinkedList<String> referenceStack;

        private ReferencedJsonTypeDefinitionVisitor() {
            this.referenceStack = new LinkedList();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitClassType(ClassType classType) {
            DecoratedClassType decorated = (DecoratedClassType)TypeMirrorDecorator.decorate((TypeMirror)classType);
            if (decorated.getDeclaration() != null && Object.class.getName().equals(decorated.getDeclaration().getQualifiedName())) {
                return;
            }
            String qualifiedName = decorated.getDeclaration().getQualifiedName();
            if (this.referenceStack.contains(qualifiedName)) {
                return;
            }
            this.referenceStack.addFirst(qualifiedName);
            try {
                Collection typeArgs;
                ClassDeclaration declaration;
                if (!decorated.isCollection() && (declaration = classType.getDeclaration()) != null) {
                    EnunciateFreemarkerModel.this.addJsonType(JsonTypeDefinition.createTypeDefinition(declaration));
                }
                if ((typeArgs = classType.getActualTypeArguments()) != null) {
                    for (TypeMirror typeArg : typeArgs) {
                        typeArg.accept((TypeVisitor)this);
                    }
                }
            }
            finally {
                this.referenceStack.removeFirst();
            }
        }

        @Override
        public void visitEnumType(EnumType enumType) {
            EnumDeclaration enumDeclaration = enumType.getDeclaration();
            if (enumDeclaration != null) {
                EnunciateFreemarkerModel.this.addJsonType(JsonTypeDefinition.createTypeDefinition((ClassDeclaration)enumDeclaration));
            }
        }
    }

    private abstract class DefaultReferencedTypeVisitor
    implements TypeVisitor {
        private DefaultReferencedTypeVisitor() {
        }

        public void visitTypeMirror(TypeMirror typeMirror) {
        }

        public void visitPrimitiveType(PrimitiveType primitiveType) {
        }

        public void visitVoidType(VoidType voidType) {
        }

        public void visitReferenceType(ReferenceType referenceType) {
        }

        public void visitDeclaredType(DeclaredType declaredType) {
        }

        public void visitAnnotationType(AnnotationType annotationType) {
        }

        public void visitClassType(ClassType arg0) {
        }

        public void visitEnumType(EnumType arg0) {
        }

        public void visitInterfaceType(InterfaceType interfaceType) {
            Collection typeArgs;
            MapType mapType = MapTypeUtil.findMapType((TypeMirror)interfaceType);
            if (mapType != null) {
                mapType.getKeyType().accept((TypeVisitor)this);
                mapType.getValueType().accept((TypeVisitor)this);
            } else if (((DecoratedInterfaceType)TypeMirrorDecorator.decorate((TypeMirror)interfaceType)).isCollection() && (typeArgs = interfaceType.getActualTypeArguments()) != null) {
                for (TypeMirror typeArg : typeArgs) {
                    typeArg.accept((TypeVisitor)this);
                }
            }
        }

        public void visitArrayType(ArrayType arrayType) {
            arrayType.getComponentType().accept((TypeVisitor)this);
        }

        public void visitTypeVariable(TypeVariable typeVariable) {
            Iterator bounds = typeVariable.getDeclaration().getBounds().iterator();
            if (bounds.hasNext()) {
                ((ReferenceType)bounds.next()).accept((TypeVisitor)this);
            }
        }

        public void visitWildcardType(WildcardType wildcardType) {
            Iterator upperBounds = wildcardType.getUpperBounds().iterator();
            if (upperBounds.hasNext()) {
                ((ReferenceType)upperBounds.next()).accept((TypeVisitor)this);
            }
        }
    }
}

