/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.apt;

import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.apt.Messager;
import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.InterfaceDeclaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.type.AnnotationType;
import com.sun.mirror.type.ClassType;
import com.sun.mirror.type.TypeMirror;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModelException;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeSet;
import javax.jws.WebService;
import javax.ws.rs.HttpMethod;
import javax.ws.rs.Path;
import javax.ws.rs.ext.Provider;
import javax.xml.bind.annotation.XmlRegistry;
import javax.xml.bind.annotation.XmlRootElement;
import net.sf.jelly.apt.Context;
import net.sf.jelly.apt.decorations.TypeMirrorDecorator;
import net.sf.jelly.apt.decorations.type.DecoratedTypeMirror;
import net.sf.jelly.apt.freemarker.FreemarkerModel;
import net.sf.jelly.apt.freemarker.FreemarkerProcessor;
import net.sf.jelly.apt.freemarker.FreemarkerTransform;
import org.codehaus.enunciate.EnunciateException;
import org.codehaus.enunciate.XmlTransient;
import org.codehaus.enunciate.apt.EnunciateFreemarkerModel;
import org.codehaus.enunciate.apt.EnunciateModelAware;
import org.codehaus.enunciate.apt.EnunciateTypeDeclarationListener;
import org.codehaus.enunciate.apt.ModelValidationException;
import org.codehaus.enunciate.config.EnunciateConfiguration;
import org.codehaus.enunciate.contract.jaxb.Registry;
import org.codehaus.enunciate.contract.jaxb.RootElementDeclaration;
import org.codehaus.enunciate.contract.jaxb.TypeDefinition;
import org.codehaus.enunciate.contract.jaxrs.RootResource;
import org.codehaus.enunciate.contract.jaxws.EndpointImplementation;
import org.codehaus.enunciate.contract.jaxws.EndpointInterface;
import org.codehaus.enunciate.contract.json.JsonRootElementDeclaration;
import org.codehaus.enunciate.contract.json.JsonTypeDefinition;
import org.codehaus.enunciate.contract.validation.ConfigurableRules;
import org.codehaus.enunciate.contract.validation.EmptyNamespaceValidator;
import org.codehaus.enunciate.contract.validation.ValidationMessage;
import org.codehaus.enunciate.contract.validation.ValidationResult;
import org.codehaus.enunciate.contract.validation.Validator;
import org.codehaus.enunciate.contract.validation.ValidatorChain;
import org.codehaus.enunciate.json.JsonRootType;
import org.codehaus.enunciate.json.JsonType;
import org.codehaus.enunciate.main.Enunciate;
import org.codehaus.enunciate.modules.DeploymentModule;
import org.codehaus.enunciate.template.freemarker.EnunciateFileTransform;
import org.codehaus.enunciate.template.freemarker.ForEachBindingTypeTransform;
import org.codehaus.enunciate.template.freemarker.ForEachEndpointInterfaceTransform;
import org.codehaus.enunciate.template.freemarker.ForEachJsonSchemaTransform;
import org.codehaus.enunciate.template.freemarker.ForEachResourceMethodListByPathTransform;
import org.codehaus.enunciate.template.freemarker.ForEachSchemaTransform;
import org.codehaus.enunciate.template.freemarker.ForEachServiceEndpointTransform;
import org.codehaus.enunciate.template.freemarker.ForEachThrownWebFaultTransform;
import org.codehaus.enunciate.template.freemarker.ForEachWebFaultTransform;
import org.codehaus.enunciate.template.freemarker.ForEachWebMessageTransform;
import org.codehaus.enunciate.template.freemarker.ForEachWebMethodTransform;
import org.codehaus.enunciate.template.freemarker.ForEachWsdlTransform;
import org.codehaus.enunciate.util.AntPatternMatcher;

public class EnunciateAnnotationProcessor
extends FreemarkerProcessor {
    private EnunciateException ee = null;
    private IOException ioe = null;
    private RuntimeException re = null;
    private final Enunciate enunciate;
    private final String[] additionalApiClasses;

    EnunciateAnnotationProcessor() throws EnunciateException {
        this(new Enunciate(new String[0], new EnunciateConfiguration()), new String[0]);
    }

    public EnunciateAnnotationProcessor(Enunciate enunciate, String ... additionalApiClasses) throws EnunciateException {
        super(null);
        if (enunciate == null) {
            throw new EnunciateException("An enunciate mechanism must be specified.");
        }
        if (enunciate.getConfig() == null) {
            throw new EnunciateException("An enunciate mechanism must have a configuration (even if its the default configuration).");
        }
        this.enunciate = enunciate;
        this.additionalApiClasses = additionalApiClasses;
    }

    public void process() {
        try {
            EnunciateFreemarkerModel model = this.getRootModel();
            EnunciateConfiguration config = this.enunciate.getConfig();
            for (DeploymentModule module : config.getAllModules()) {
                if (!(module instanceof EnunciateModelAware)) continue;
                ((EnunciateModelAware)((Object)module)).initModel(model);
            }
            for (DeploymentModule module : config.getEnabledModules()) {
                this.debug("Invoking %s step for module %s", new Object[]{Enunciate.Target.GENERATE, module.getName()});
                module.step(Enunciate.Target.GENERATE);
            }
        }
        catch (TemplateException e) {
            this.process(e);
        }
        catch (IOException e) {
            this.process(e);
        }
        catch (EnunciateException e) {
            this.process(e);
        }
        catch (RuntimeException re) {
            this.process(re);
        }
    }

    protected EnunciateFreemarkerModel getRootModel() throws TemplateModelException {
        EnunciateConfiguration config = this.enunciate.getConfig();
        EnunciateFreemarkerModel model = (EnunciateFreemarkerModel)super.getRootModel();
        model.setEnunciateConfig(config);
        TypeDeclaration[] additionalApiDefinitions = this.loadAdditionalApiDefinitions();
        AnnotationProcessorEnvironment env = Context.getCurrentEnvironment();
        ArrayList<TypeDeclaration> typeDeclarations = new ArrayList<TypeDeclaration>(env.getTypeDeclarations());
        typeDeclarations.addAll(Arrays.asList(additionalApiDefinitions));
        this.trimNotIncludedClasses(typeDeclarations);
        this.removeExcludedClasses(typeDeclarations);
        for (String ns : config.getNamespacesToPrefixes().keySet()) {
            String prefix = config.getNamespacesToPrefixes().get(ns);
            model.getNamespacesToPrefixes().put(ns, prefix);
            this.debug("Assigning namespace prefix %s to namespace %s as specified in the config.", prefix, ns);
        }
        for (String ct : config.getContentTypesToIds().keySet()) {
            String id = config.getContentTypesToIds().get(ct);
            model.getContentTypesToIds().put(ct, id);
            this.debug("Assigning id '%s' to content type '%s' as specified in the config.", id, ct);
        }
        if (config.getGeneratedCodeLicenseFile() != null) {
            File licenseFile = this.enunciate.resolvePath(config.getGeneratedCodeLicenseFile());
            try {
                model.put("generatedCodeLicense", this.enunciate.readFile(licenseFile));
            }
            catch (IOException e) {
                this.warn("Unable to read code license file %s: %s.", licenseFile.getAbsolutePath(), e.getMessage());
            }
        }
        String baseURL = config.getDeploymentProtocol() + "://" + config.getDeploymentHost();
        if (config.getDeploymentContext() != null) {
            baseURL = baseURL + config.getDeploymentContext();
        } else if (config.getLabel() != null && !"".equals(config.getLabel())) {
            baseURL = baseURL + "/" + config.getLabel();
        }
        model.setBaseDeploymentAddress(baseURL);
        ArrayList<EnunciateTypeDeclarationListener> typeDeclarationListeners = new ArrayList<EnunciateTypeDeclarationListener>();
        for (DeploymentModule module : config.getAllModules()) {
            if (!(module instanceof EnunciateTypeDeclarationListener)) continue;
            typeDeclarationListeners.add((EnunciateTypeDeclarationListener)((Object)module));
        }
        this.debug("Reading classes to enunciate...", new Object[0]);
        ArrayList<EndpointInterface> eis = new ArrayList<EndpointInterface>();
        for (TypeDeclaration declaration : typeDeclarations) {
            boolean isEndpointInterface = this.isEndpointInterface(declaration);
            boolean isJAXRSRootResource = this.isJAXRSRootResource(declaration);
            boolean isJAXRSSupport = this.isJAXRSSupport(declaration);
            if (isEndpointInterface || isJAXRSRootResource || isJAXRSSupport) {
                if (isEndpointInterface) {
                    EndpointInterface endpointInterface = new EndpointInterface(declaration, additionalApiDefinitions);
                    this.debug("%s to be considered as an endpoint interface.", declaration.getQualifiedName());
                    for (EndpointImplementation implementation : endpointInterface.getEndpointImplementations()) {
                        this.debug("%s is the implementation of endpoint interface %s.", implementation.getQualifiedName(), endpointInterface.getQualifiedName());
                    }
                    eis.add(endpointInterface);
                }
                if (isJAXRSRootResource) {
                    RootResource rootResource = new RootResource(declaration);
                    this.debug("%s to be considered as a JAX-RS root resource.", declaration.getQualifiedName());
                    model.add(rootResource);
                }
                if (isJAXRSSupport) {
                    if (declaration.getAnnotation(Provider.class) != null) {
                        this.debug("%s to be considered as a JAX-RS provider.", declaration.getQualifiedName());
                        model.addJAXRSProvider(declaration);
                    } else {
                        this.debug("%s to be considered a JAX-RS support class.", declaration.getQualifiedName());
                    }
                }
            } else if (this.isRegistry(declaration)) {
                this.debug("%s to be considered as an XML registry.", declaration.getQualifiedName());
                Registry registry = new Registry((ClassDeclaration)declaration);
                model.add(registry);
            } else {
                boolean jsonType;
                boolean xmlType = this.isPotentialXmlSchemaType(declaration);
                if (xmlType) {
                    TypeDefinition typeDef = this.createTypeDefinition((ClassDeclaration)declaration, model);
                    this.loadTypeDef(typeDef, model);
                }
                if (jsonType = this.isPotentialJsonSchemaType(declaration)) {
                    JsonTypeDefinition typeDefinition = JsonTypeDefinition.createTypeDefinition((ClassDeclaration)declaration);
                    this.loadJsonTypeDef(typeDefinition, model);
                }
                if (!xmlType && !jsonType) {
                    this.onUnhandledDeclaration(model, declaration);
                }
            }
            for (EnunciateTypeDeclarationListener declarationListener : typeDeclarationListeners) {
                declarationListener.onTypeDeclarationInspected(declaration);
            }
        }
        for (EndpointInterface ei : eis) {
            model.add(ei);
        }
        this.validate(model);
        return model;
    }

    protected void onUnhandledDeclaration(EnunciateFreemarkerModel model, TypeDeclaration declaration) {
        this.debug("%s is neither an endpoint interface, rest endpoint, or a schema type, so it'll be ignored.", declaration.getQualifiedName());
    }

    protected void removeExcludedClasses(Collection<TypeDeclaration> typeDeclarations) {
        EnunciateConfiguration config = this.enunciate.getConfig();
        AntPatternMatcher matcher = new AntPatternMatcher();
        matcher.setPathSeparator(".");
        if (!config.getApiExcludePatterns().isEmpty()) {
            Iterator<TypeDeclaration> typeDeclarationIt = typeDeclarations.iterator();
            while (typeDeclarationIt.hasNext()) {
                TypeDeclaration typeDeclaration = typeDeclarationIt.next();
                boolean exclude = false;
                if (config.getApiExcludePatterns().contains(typeDeclaration.getQualifiedName())) {
                    exclude = true;
                    this.debug("%s was explicitly excluded.", typeDeclaration.getQualifiedName());
                } else {
                    for (String excludePattern : config.getApiExcludePatterns()) {
                        if (!matcher.match(excludePattern, typeDeclaration.getQualifiedName())) continue;
                        exclude = true;
                        this.debug("%s matches exclude pattern %s.", typeDeclaration.getQualifiedName(), excludePattern);
                        break;
                    }
                }
                if (exclude) {
                    typeDeclarationIt.remove();
                    continue;
                }
                this.debug("%s NOT to be excluded as an API class because it didn't match any exclude pattern.", typeDeclaration);
            }
        }
    }

    protected void trimNotIncludedClasses(Collection<TypeDeclaration> typeDeclarations) {
        EnunciateConfiguration config = this.enunciate.getConfig();
        AntPatternMatcher matcher = new AntPatternMatcher();
        matcher.setPathSeparator(".");
        if (!config.getApiIncludePatterns().isEmpty()) {
            Iterator<TypeDeclaration> typeDeclarationIt = typeDeclarations.iterator();
            while (typeDeclarationIt.hasNext()) {
                TypeDeclaration typeDeclaration = typeDeclarationIt.next();
                boolean include = false;
                if (config.getApiIncludePatterns().contains(typeDeclaration.getQualifiedName())) {
                    include = true;
                    this.debug("%s was explicitly included.", typeDeclaration.getQualifiedName());
                } else {
                    for (String includePattern : config.getApiIncludePatterns()) {
                        if (!matcher.match(includePattern, typeDeclaration.getQualifiedName())) continue;
                        include = true;
                        this.debug("%s matches include pattern %s.", typeDeclaration.getQualifiedName(), includePattern);
                        break;
                    }
                }
                if (include) continue;
                this.debug("%s NOT to be included as an API class because it didn't match any include pattern.", typeDeclaration);
                typeDeclarationIt.remove();
            }
        }
    }

    protected TypeDeclaration[] loadAdditionalApiDefinitions() {
        AnnotationProcessorEnvironment environment = Context.getCurrentEnvironment();
        ArrayList<TypeDeclaration> additionalApiDefinitions = new ArrayList<TypeDeclaration>();
        if (this.additionalApiClasses != null) {
            for (String additionalApiClass : this.additionalApiClasses) {
                TypeDeclaration declaration = environment.getTypeDeclaration(additionalApiClass);
                if (declaration != null) {
                    additionalApiDefinitions.add(declaration);
                    continue;
                }
                this.enunciate.warn("Unable to load type definition for imported API class '%s'.", additionalApiClass);
            }
        }
        return additionalApiDefinitions.toArray(new TypeDeclaration[additionalApiDefinitions.size()]);
    }

    protected void loadJsonTypeDef(JsonTypeDefinition typeDefinition, EnunciateFreemarkerModel model) {
        if (typeDefinition != null) {
            if (this.enunciate.getConfig() != null && !this.enunciate.getConfig().isExcludeUnreferencedClasses()) {
                this.debug("%s to be considered as a %s", typeDefinition.getTypeName(), typeDefinition.getClass().getSimpleName());
                model.addJsonType(typeDefinition);
                if (typeDefinition.getDelegate().getAnnotation(JsonRootType.class) != null) {
                    this.debug("%s to be considered as a root element", typeDefinition.getTypeName());
                    model.addJsonRootElement(new JsonRootElementDeclaration(typeDefinition));
                }
            } else {
                this.debug("%s is a potential schema type definition, but we're not going to add it directly to the model. (It could still be indirectly added, though.)", typeDefinition.getTypeName());
            }
        }
    }

    protected void loadTypeDef(TypeDefinition typeDef, EnunciateFreemarkerModel model) {
        if (typeDef != null) {
            if (this.enunciate.getConfig() != null && !this.enunciate.getConfig().isExcludeUnreferencedClasses()) {
                this.debug("%s to be considered as a %s (qname:{%s}%s).", typeDef.getQualifiedName(), ((Object)((Object)typeDef)).getClass().getSimpleName(), typeDef.getNamespace() == null ? "" : typeDef.getNamespace(), typeDef.getName() == null ? "(anonymous)" : typeDef.getName());
                model.add(typeDef);
            } else {
                this.debug("%s is a potential schema type definition, but we're not going to add it directly to the model. (It could still be indirectly added, though.)", typeDef.getQualifiedName());
            }
            RootElementDeclaration rootElement = this.createRootElementDeclaration((ClassDeclaration)typeDef.getDelegate(), typeDef);
            if (rootElement != null) {
                this.debug("%s to be considered as a root element", typeDef.getQualifiedName());
                model.add(rootElement);
            }
        }
    }

    protected void validate(EnunciateFreemarkerModel model) throws ModelValidationException {
        StringBuilder text;
        ValidationResult validationResult;
        Validator coreValidator;
        this.debug("Validating the model...", new Object[0]);
        Messager messager = this.getMessager();
        ValidatorChain validator = new ValidatorChain();
        EnunciateConfiguration config = this.enunciate.getConfig();
        TreeSet<String> disabledRules = new TreeSet<String>(config.getDisabledRules());
        if (this.enunciate.isModuleEnabled("rest")) {
            disabledRules.add("disabled.rest.module");
        }
        if ((coreValidator = config.getValidator()) instanceof ConfigurableRules) {
            ((ConfigurableRules)((Object)coreValidator)).disableRules(disabledRules);
        }
        validator.addValidator("core", coreValidator);
        this.debug("Default validator added to the chain.", new Object[0]);
        for (DeploymentModule module : config.getEnabledModules()) {
            Validator moduleValidator = module.getValidator();
            if (moduleValidator == null) continue;
            if (moduleValidator instanceof ConfigurableRules) {
                ((ConfigurableRules)((Object)moduleValidator)).disableRules(disabledRules);
            }
            validator.addValidator(module.getName(), moduleValidator);
            this.debug("Validator for module %s added to the chain.", module.getName());
        }
        if (!config.isAllowEmptyNamespace()) {
            validator.addValidator("emptyns", new EmptyNamespaceValidator());
        }
        if ((validationResult = this.validate(model, validator)).hasWarnings()) {
            this.warn("Validation result has warnings.", new Object[0]);
            for (ValidationMessage warning : validationResult.getWarnings()) {
                if (disabledRules.contains("all.warnings") || disabledRules.contains(String.valueOf(warning.getLabel()) + ".warnings")) continue;
                text = new StringBuilder();
                if (warning.getLabel() != null) {
                    text.append('[').append(warning.getLabel()).append("] ");
                }
                text.append(warning.getText());
                if (warning.getPosition() != null) {
                    messager.printWarning(warning.getPosition(), text.toString());
                    continue;
                }
                messager.printWarning(text.toString());
            }
        }
        if (validationResult.hasErrors()) {
            this.warn("Validation result has errors.", new Object[0]);
            for (ValidationMessage error : validationResult.getErrors()) {
                text = new StringBuilder();
                if (error.getLabel() != null) {
                    text.append('[').append(error.getLabel()).append("] ");
                }
                text.append(error.getText());
                if (error.getPosition() != null) {
                    messager.printError(error.getPosition(), text.toString());
                    continue;
                }
                messager.printError(text.toString());
            }
            throw new ModelValidationException();
        }
    }

    protected Messager getMessager() {
        return Context.getCurrentEnvironment().getMessager();
    }

    protected FreemarkerModel newRootModel() {
        return new EnunciateFreemarkerModel();
    }

    protected boolean isRegistry(TypeDeclaration declaration) {
        return declaration.getAnnotation(XmlRegistry.class) != null;
    }

    protected boolean isPotentialJsonSchemaType(TypeDeclaration declaration) {
        return declaration instanceof ClassDeclaration && (declaration.getAnnotation(JsonType.class) != null || declaration.getAnnotation(JsonRootType.class) != null);
    }

    protected boolean isPotentialXmlSchemaType(TypeDeclaration declaration) {
        if (!(declaration instanceof ClassDeclaration)) {
            this.debug("%s isn't a potential schema type because it's not a class.", declaration.getQualifiedName());
            return false;
        }
        if (declaration.getPackage() != null && declaration.getPackage().getAnnotation(XmlTransient.class) != null) {
            this.debug("%s isn't a potential schema type because its package is annotated as XmlTransient.", declaration.getQualifiedName());
            return false;
        }
        Collection annotationMirrors = declaration.getAnnotationMirrors();
        boolean explicitXMLTypeOrElement = false;
        for (AnnotationMirror mirror : annotationMirrors) {
            AnnotationTypeDeclaration annotationDeclaration = mirror.getAnnotationType().getDeclaration();
            if (annotationDeclaration == null) continue;
            String fqn = annotationDeclaration.getQualifiedName();
            if (XmlTransient.class.getName().equals(fqn) || "javax.xml.bind.annotation.XmlTransient".equals(fqn) || fqn.startsWith("javax.xml.ws") || fqn.startsWith("javax.ws.rs") || fqn.startsWith("javax.jws")) {
                this.debug("%s isn't a potential schema type because of annotation %s.", declaration.getQualifiedName(), fqn);
                return false;
            }
            explicitXMLTypeOrElement = "javax.xml.bind.annotation.XmlType".equals(fqn) || "javax.xml.bind.annotation.XmlRootElement".equals(fqn);
        }
        return explicitXMLTypeOrElement || !this.isThrowable(declaration);
    }

    protected boolean isThrowable(TypeDeclaration declaration) {
        if (!(declaration instanceof ClassDeclaration)) {
            return false;
        }
        if (Throwable.class.getName().equals(declaration.getQualifiedName())) {
            return false;
        }
        ClassType superClass = ((ClassDeclaration)declaration).getSuperclass();
        return ((DecoratedTypeMirror)TypeMirrorDecorator.decorate((TypeMirror)superClass)).isInstanceOf(Throwable.class.getName());
    }

    public boolean isEndpointInterface(TypeDeclaration declaration) {
        WebService ws = (WebService)declaration.getAnnotation(WebService.class);
        return declaration.getAnnotation(XmlTransient.class) == null && ws != null && (declaration instanceof InterfaceDeclaration || ws.endpointInterface() == null || "".equals(ws.endpointInterface()));
    }

    public boolean isJAXRSRootResource(TypeDeclaration declaration) {
        return declaration.getAnnotation(XmlTransient.class) == null && declaration.getAnnotation(Path.class) != null;
    }

    public boolean isJAXRSSupport(TypeDeclaration declaration) {
        if (declaration.getAnnotation(XmlTransient.class) != null) {
            return false;
        }
        Collection methods = declaration.getMethods();
        for (MethodDeclaration method : methods) {
            for (AnnotationMirror mirror : method.getAnnotationMirrors()) {
                AnnotationType type = mirror.getAnnotationType();
                if (type.getDeclaration() == null || type.getDeclaration().getAnnotation(HttpMethod.class) == null) continue;
                return true;
            }
        }
        return declaration.getAnnotation(Provider.class) != null;
    }

    public TypeDefinition createTypeDefinition(ClassDeclaration declaration, EnunciateFreemarkerModel model) {
        return model.createTypeDefinition(declaration);
    }

    public RootElementDeclaration createRootElementDeclaration(ClassDeclaration declaration, TypeDefinition typeDefinition) {
        if (!this.isRootSchemaElement((TypeDeclaration)declaration)) {
            return null;
        }
        return new RootElementDeclaration(declaration, typeDefinition);
    }

    protected boolean isRootSchemaElement(TypeDeclaration declaration) {
        return declaration.getAnnotation(XmlRootElement.class) != null;
    }

    public Collection<FreemarkerTransform> getTransforms() {
        String namespace = (String)Context.getCurrentEnvironment().getOptions().get("-AEnunciateFreemarkerLibraryNS");
        Collection transforms = super.getTransforms();
        transforms.add(new ForEachServiceEndpointTransform(namespace));
        transforms.add(new ForEachBindingTypeTransform(namespace));
        transforms.add(new ForEachEndpointInterfaceTransform(namespace));
        transforms.add(new ForEachThrownWebFaultTransform(namespace));
        transforms.add(new ForEachWebFaultTransform(namespace));
        transforms.add(new ForEachWebMessageTransform(namespace));
        transforms.add(new ForEachWebMethodTransform(namespace));
        transforms.add(new ForEachWsdlTransform(namespace));
        transforms.add(new ForEachSchemaTransform(namespace));
        transforms.add(new ForEachJsonSchemaTransform(namespace));
        transforms.add(new ForEachResourceMethodListByPathTransform(namespace));
        EnunciateFileTransform fileTransform = new EnunciateFileTransform(namespace);
        transforms.add(fileTransform);
        return transforms;
    }

    protected ValidationResult validate(EnunciateFreemarkerModel model, Validator validator) {
        return validator.validate(model);
    }

    protected void process(TemplateException e) {
        if (!(e instanceof ModelValidationException)) {
            Messager messager = this.getMessager();
            StringWriter stackTrace = new StringWriter();
            e.printStackTrace(new PrintWriter(stackTrace));
            messager.printError(stackTrace.toString());
        }
        this.ee = new EnunciateException(e);
    }

    protected void process(EnunciateException e) {
        this.ee = e;
    }

    protected void process(IOException e) {
        this.ioe = e;
    }

    protected void process(RuntimeException e) {
        this.re = e;
    }

    public void throwAnyErrors() throws EnunciateException, IOException {
        if (this.ee != null) {
            throw this.ee;
        }
        if (this.ioe != null) {
            throw this.ioe;
        }
        if (this.re != null) {
            throw this.re;
        }
    }

    public void info(String message, Object ... formatArgs) {
        this.enunciate.info(message, formatArgs);
    }

    public void debug(String message, Object ... formatArgs) {
        this.enunciate.debug(message, formatArgs);
    }

    public void warn(String message, Object ... formatArgs) {
        this.enunciate.warn(message, formatArgs);
    }
}

