/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.timeline.internal;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.index.SerialMergeScheduler;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.SearcherFactory;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.MMapDirectory;
import org.apache.lucene.store.NIOFSDirectory;
import org.apache.lucene.store.SimpleFSDirectory;
import org.apache.lucene.util.Version;
import org.sonatype.sisu.goodies.common.ComponentSupport;
import org.sonatype.timeline.TimelineCallback;
import org.sonatype.timeline.TimelineConfiguration;
import org.sonatype.timeline.TimelineFilter;
import org.sonatype.timeline.TimelineRecord;

public class DefaultTimelineIndexer
extends ComponentSupport {
    private static final String TIMESTAMP = "_t";
    private static final String TYPE = "_1";
    private static final String SUBTYPE = "_2";
    private static final DateTools.Resolution TIMELINE_RESOLUTION = DateTools.Resolution.SECOND;
    private final String luceneFSDirectoryType;
    private Directory directory;
    private IndexWriter indexWriter;
    private SearcherManager searcherManager;
    private int generation = 0;
    private static final int PURGE_BATCH_SIZE = 1000000;

    public DefaultTimelineIndexer(String luceneFSDirectoryType) {
        this.luceneFSDirectoryType = luceneFSDirectoryType;
    }

    protected void start(TimelineConfiguration configuration) throws IOException {
        this.closeIndexWriter();
        if (this.directory != null) {
            this.directory.close();
        }
        this.directory = this.openFSDirectory(configuration.getIndexDirectory());
        if (IndexReader.indexExists((Directory)this.directory) && IndexWriter.isLocked((Directory)this.directory)) {
            IndexWriter.unlock((Directory)this.directory);
        }
        IndexWriterConfig config = new IndexWriterConfig(Version.LUCENE_36, (Analyzer)new StandardAnalyzer(Version.LUCENE_36));
        config.setMergeScheduler((MergeScheduler)new SerialMergeScheduler());
        config.setRAMBufferSizeMB(2.0);
        this.indexWriter = new IndexWriter(this.directory, config);
        this.indexWriter.commit();
        this.searcherManager = new SearcherManager(this.indexWriter, false, new SearcherFactory());
        ++this.generation;
    }

    private FSDirectory openFSDirectory(File location) throws IOException {
        if (this.luceneFSDirectoryType == null) {
            return new NIOFSDirectory(location);
        }
        if ("mmap".equals(this.luceneFSDirectoryType)) {
            return new MMapDirectory(location);
        }
        if ("nio".equals(this.luceneFSDirectoryType)) {
            return new NIOFSDirectory(location);
        }
        if ("simple".equals(this.luceneFSDirectoryType)) {
            return new SimpleFSDirectory(location);
        }
        throw new IllegalArgumentException("''" + this.luceneFSDirectoryType + "'' is not valid/supported Lucene FSDirectory type. Only ''mmap'', ''nio'' and ''simple'' are allowed");
    }

    protected void stop() throws IOException {
        this.closeIndexWriter();
        if (this.directory != null) {
            this.directory.close();
            this.directory = null;
        }
    }

    protected void add(TimelineRecord record) throws IOException {
        this.addAll(record);
    }

    protected void addAll(TimelineRecord ... records) throws IOException {
        for (TimelineRecord rec : records) {
            this.indexWriter.addDocument(this.createDocument(rec));
        }
        this.indexWriter.commit();
    }

    protected void addBatch(TimelineRecord record) throws IOException {
        this.indexWriter.addDocument(this.createDocument(record));
    }

    protected void finishBatch() throws IOException {
        this.indexWriter.commit();
        this.searcherManager.maybeRefresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void retrieve(long fromTime, long toTime, Set<String> types, Set<String> subTypes, int from, int count, TimelineFilter filter, TimelineCallback callback) throws IOException {
        if (count == 0) {
            return;
        }
        this.searcherManager.maybeRefresh();
        IndexSearcher searcher = (IndexSearcher)this.searcherManager.acquire();
        try {
            if (searcher.maxDoc() == 0) {
                return;
            }
            TopFieldDocs topDocs = filter == null ? searcher.search(this.buildQuery(fromTime, toTime, types, subTypes), null, from + count, new Sort(new SortField(TIMESTAMP, 6, true))) : searcher.search(this.buildQuery(fromTime, toTime, types, subTypes), null, Integer.MAX_VALUE, new Sort(new SortField(TIMESTAMP, 6, true)));
            if (topDocs.scoreDocs.length == 0) {
                return;
            }
            int i = 0;
            int returned = 0;
            while (i < topDocs.scoreDocs.length) {
                if (returned >= count) {
                } else {
                    Document doc = searcher.doc(topDocs.scoreDocs[i++].doc);
                    TimelineRecord data = this.buildData(doc);
                    if (filter != null && !filter.accept(data)) {
                        data = null;
                        continue;
                    }
                    if (from > 0) {
                        --from;
                        continue;
                    }
                    ++returned;
                    if (callback.processNext(data)) continue;
                }
                break;
            }
        }
        finally {
            this.searcherManager.release((Object)searcher);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int purge(long fromTime, long toTime, Set<String> types, Set<String> subTypes) throws IOException {
        this.searcherManager.maybeRefresh();
        IndexSearcher searcher = (IndexSearcher)this.searcherManager.acquire();
        try {
            if (searcher.maxDoc() == 0) {
                int n = 0;
                return n;
            }
            Query q = this.buildQuery(fromTime, toTime, types, subTypes);
            this.log.debug("purge query='{}'", (Object)q);
            int deletedCount = 0;
            TopDocs topDocs = searcher.search(q, 1000000);
            while (topDocs.scoreDocs.length > 0) {
                for (ScoreDoc scoreDoc : topDocs.scoreDocs) {
                    Document doc = searcher.doc(scoreDoc.doc);
                    this.indexWriter.deleteDocuments(new Term(TIMESTAMP, doc.get(TIMESTAMP)));
                    ++deletedCount;
                }
                this.log.debug("purged so far: {}", (Object)deletedCount);
                topDocs = searcher.searchAfter(topDocs.scoreDocs[topDocs.scoreDocs.length - 1], q, 1000000);
            }
            if (deletedCount == 0) {
                int n = 0;
                return n;
            }
            this.indexWriter.commit();
            this.indexWriter.optimize();
            this.indexWriter.deleteUnusedFiles();
            int n = deletedCount;
            return n;
        }
        finally {
            this.searcherManager.release((Object)searcher);
        }
    }

    protected void closeIndexWriter() throws IOException {
        if (this.searcherManager != null) {
            this.searcherManager.close();
            this.searcherManager = null;
        }
        if (this.indexWriter != null) {
            this.indexWriter.commit();
            this.indexWriter.close();
            this.indexWriter = null;
        }
    }

    protected Document createDocument(TimelineRecord record) {
        Document doc = new Document();
        doc.add((Fieldable)new Field(TIMESTAMP, DateTools.timeToString((long)record.getTimestamp(), (DateTools.Resolution)TIMELINE_RESOLUTION), Field.Store.YES, Field.Index.NOT_ANALYZED));
        doc.add((Fieldable)new Field(TYPE, record.getType(), Field.Store.YES, Field.Index.NOT_ANALYZED));
        doc.add((Fieldable)new Field(SUBTYPE, record.getSubType(), Field.Store.YES, Field.Index.NOT_ANALYZED));
        for (Map.Entry<String, String> dataEntry : record.getData().entrySet()) {
            doc.add((Fieldable)new Field(dataEntry.getKey(), dataEntry.getValue(), Field.Store.YES, Field.Index.ANALYZED));
        }
        return doc;
    }

    protected Query buildQuery(long from, long to, Set<String> types, Set<String> subTypes) {
        if (this.isEmptySet(types) && this.isEmptySet(subTypes)) {
            return new TermRangeQuery(TIMESTAMP, DateTools.timeToString((long)from, (DateTools.Resolution)TIMELINE_RESOLUTION), DateTools.timeToString((long)to, (DateTools.Resolution)TIMELINE_RESOLUTION), true, true);
        }
        BooleanQuery result = new BooleanQuery();
        result.add((Query)new TermRangeQuery(TIMESTAMP, DateTools.timeToString((long)from, (DateTools.Resolution)TIMELINE_RESOLUTION), DateTools.timeToString((long)to, (DateTools.Resolution)TIMELINE_RESOLUTION), true, true), BooleanClause.Occur.MUST);
        if (!this.isEmptySet(types)) {
            BooleanQuery typeQ = new BooleanQuery();
            for (String type : types) {
                typeQ.add((Query)new TermQuery(new Term(TYPE, type)), BooleanClause.Occur.SHOULD);
            }
            result.add((Query)typeQ, BooleanClause.Occur.MUST);
        }
        if (!this.isEmptySet(subTypes)) {
            BooleanQuery subTypeQ = new BooleanQuery();
            for (String subType : subTypes) {
                subTypeQ.add((Query)new TermQuery(new Term(SUBTYPE, subType)), BooleanClause.Occur.SHOULD);
            }
            result.add((Query)subTypeQ, BooleanClause.Occur.MUST);
        }
        return result;
    }

    protected boolean isEmptySet(Set<String> set) {
        return set == null || set.size() == 0;
    }

    protected TimelineRecord buildData(Document doc) {
        long timestamp = -1L;
        String tsString = doc.get(TIMESTAMP);
        if (tsString != null) {
            try {
                timestamp = DateTools.stringToTime((String)tsString);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        String type = doc.get(TYPE);
        String subType = doc.get(SUBTYPE);
        if (StringUtils.isBlank((String)type) && StringUtils.isBlank((String)subType)) {
            type = "SYSTEM";
            subType = "Legacy";
        }
        HashMap<String, String> data = new HashMap<String, String>();
        for (Fieldable field : doc.getFields()) {
            if (field.name().startsWith("_")) continue;
            data.put(field.name(), field.stringValue());
        }
        return new TimelineRecord(timestamp, type, subType, data);
    }
}

