/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.timeline.internal;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.util.file.DirSupport;
import org.sonatype.sisu.goodies.common.ComponentSupport;
import org.sonatype.timeline.Timeline;
import org.sonatype.timeline.TimelineCallback;
import org.sonatype.timeline.TimelineConfiguration;
import org.sonatype.timeline.TimelineFilter;
import org.sonatype.timeline.TimelineRecord;
import org.sonatype.timeline.internal.DefaultTimelineIndexer;
import org.sonatype.timeline.internal.DefaultTimelinePersistor;
import org.sonatype.timeline.internal.RepairBatch;

@Singleton
@Named(value="default")
public class DefaultTimeline
extends ComponentSupport
implements Timeline {
    private volatile boolean started = false;
    private final DefaultTimelinePersistor persistor = new DefaultTimelinePersistor();
    private final DefaultTimelineIndexer indexer;
    private final ReentrantReadWriteLock timelineLock;
    private volatile boolean indexerIsDead = false;

    @Inject
    public DefaultTimeline(@Nullable @Named(value="${lucene.fsdirectory.type}") String luceneFSDirectoryType) {
        this.indexer = new DefaultTimelineIndexer(luceneFSDirectoryType);
        this.timelineLock = new ReentrantReadWriteLock();
    }

    protected DefaultTimelineIndexer getIndexer() {
        return this.indexer;
    }

    protected DefaultTimelinePersistor getPersistor() {
        return this.persistor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(TimelineConfiguration configuration) throws IOException {
        block7: {
            this.log.debug("Starting Timeline...");
            this.timelineLock.writeLock().lock();
            try {
                if (this.started) break block7;
                this.persistor.setConfiguration(configuration);
                try {
                    this.indexer.start(configuration);
                }
                catch (IOException e) {
                    this.log.info("Timeline index got corrupted, trying to repair it.", (Throwable)e);
                    this.indexer.stop();
                    DirSupport.empty((Path)configuration.getIndexDirectory().toPath());
                    try {
                        this.indexer.start(configuration);
                        RepairBatch rb = new RepairBatch(this.indexer);
                        this.persistor.readAllSinceDays(configuration.getRepairDaysCountRestored(), rb);
                        rb.finish();
                        this.log.info("Timeline index is succesfully repaired, the last " + configuration.getRepairDaysCountRestored() + " days were restored.");
                    }
                    catch (Exception ex) {
                        this.markIndexerDead(ex);
                    }
                }
                this.started = true;
                this.log.info("Started Timeline...");
            }
            finally {
                this.timelineLock.writeLock().unlock();
            }
        }
    }

    @Override
    public void stop() throws IOException {
        this.log.debug("Stopping Timeline...");
        this.timelineLock.writeLock().lock();
        try {
            if (this.started) {
                this.started = false;
                this.indexer.stop();
                this.log.info("Stopped Timeline...");
            }
        }
        finally {
            this.timelineLock.writeLock().unlock();
        }
    }

    public boolean isStarted() {
        return this.started;
    }

    @Override
    public void add(TimelineRecord ... records) {
        if (!this.started) {
            return;
        }
        try {
            this.persistor.persist(records);
            this.addToIndexer(records);
        }
        catch (IOException e) {
            this.log.warn("Failed to add a timeline record", (Throwable)e);
        }
    }

    @Override
    public int purgeOlderThan(final int days) {
        if (this.started) {
            return this.doShared(new Work<Integer>(){

                @Override
                public Integer doIt() throws IOException {
                    try {
                        DefaultTimeline.this.persistor.purge(days);
                    }
                    catch (IOException e) {
                        DefaultTimeline.this.log.warn("Failed to purge a timeline persisted records", (Throwable)e);
                    }
                    return DefaultTimeline.this.indexer.purge(0L, System.currentTimeMillis() - TimeUnit.DAYS.toMillis(days), null, null);
                }
            });
        }
        return 0;
    }

    @Override
    public void retrieve(int fromItem, int count, Set<String> types, Set<String> subTypes, TimelineFilter filter, TimelineCallback callback) {
        if (!this.started) {
            return;
        }
        this.retrieveFromIndexer(0L, System.currentTimeMillis(), fromItem, count, types, subTypes, filter, callback);
    }

    protected void addToIndexer(final TimelineRecord ... records) {
        this.doShared(new Work<Void>(){

            @Override
            public Void doIt() throws IOException {
                DefaultTimeline.this.indexer.addAll(records);
                return null;
            }
        });
    }

    protected void retrieveFromIndexer(final long fromTime, final long toTime, final int from, final int count, final Set<String> types, final Set<String> subTypes, final TimelineFilter filter, final TimelineCallback callback) {
        this.doShared(new Work<Void>(){

            @Override
            public Void doIt() throws IOException {
                DefaultTimeline.this.indexer.retrieve(fromTime, toTime, types, subTypes, from, count, filter, callback);
                return null;
            }
        });
    }

    protected <E> E doShared(Work<E> work) {
        block7: {
            if (this.timelineLock.readLock().tryLock()) {
                try {
                    E e;
                    if (!this.started || this.indexerIsDead) break block7;
                    try {
                        e = work.doIt();
                    }
                    catch (IOException e2) {
                        this.markIndexerDead(e2);
                        break block7;
                    }
                    return e;
                }
                finally {
                    this.timelineLock.readLock().unlock();
                }
            }
        }
        return null;
    }

    protected void markIndexerDead(Exception e) {
        if (!this.indexerIsDead) {
            this.log.warn("Timeline index got corrupted and is disabled. Repair will be tried on next boot.", (Throwable)e);
            this.indexerIsDead = true;
            try {
                this.indexer.stop();
            }
            catch (IOException ex) {
                this.log.warn("Timeline index can't be stopped cleanly after it's corruption.", (Throwable)ex);
            }
        }
    }

    protected static interface Work<E> {
        public E doIt() throws IOException;
    }
}

