/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.timeline;

import java.util.HashMap;
import java.util.Map;

public class TimelineRecord {
    private final long timestamp;
    private final String type;
    private final String subType;
    private final HashMap<String, String> data;

    public TimelineRecord(long timestamp, String type, String subType, Map<String, String> data) {
        if (type == null || type.trim().length() == 0 || subType == null || subType.trim().length() == 0) {
            throw new IllegalArgumentException("TimelineRecord type or subType must not be blank/null");
        }
        this.timestamp = timestamp;
        this.type = type;
        this.subType = subType;
        this.data = data == null ? new HashMap() : new HashMap<String, String>(data);
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getType() {
        return this.type;
    }

    public String getSubType() {
        return this.subType;
    }

    public Map<String, String> getData() {
        return this.data;
    }
}

