/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.timeline;

import java.io.File;

public class TimelineConfiguration {
    public static final int DEFAULT_REPAIR_DAYS_TO_RESTORE = 30;
    public static final int DEFAULT_ROLLING_INTERVAL_MILLIS = 86400;
    private final File persistDirectory;
    private final File indexDirectory;
    private final int persistRollingIntervalMillis;
    private final int repairDaysCountRestored;

    public TimelineConfiguration(File persistDirectory, File indexDirectory, int persistRollingIntervalMillis, int repairDaysCountRestored) {
        this.persistDirectory = persistDirectory;
        this.indexDirectory = indexDirectory;
        this.persistRollingIntervalMillis = persistRollingIntervalMillis;
        this.repairDaysCountRestored = repairDaysCountRestored;
    }

    public TimelineConfiguration(File persistDirectory, File indexDirectory) {
        this(persistDirectory, indexDirectory, 86400, 30);
    }

    public TimelineConfiguration(File baseDir) {
        this(new File(baseDir, "persist"), new File(baseDir, "index"), 86400, 30);
    }

    public File getPersistDirectory() {
        return this.persistDirectory;
    }

    public File getIndexDirectory() {
        return this.indexDirectory;
    }

    public int getPersistRollingIntervalMillis() {
        return this.persistRollingIntervalMillis;
    }

    public int getRepairDaysCountRestored() {
        return this.repairDaysCountRestored;
    }
}

