/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.timeline;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.configuration.application.ApplicationConfiguration;
import org.sonatype.nexus.timeline.Entry;
import org.sonatype.nexus.timeline.NexusTimeline;
import org.sonatype.nexus.timeline.PredicateTimelineFilter;
import org.sonatype.nexus.util.file.DirSupport;
import org.sonatype.sisu.goodies.common.ComponentSupport;
import org.sonatype.timeline.Timeline;
import org.sonatype.timeline.TimelineCallback;
import org.sonatype.timeline.TimelineConfiguration;
import org.sonatype.timeline.TimelineRecord;

@Named
@Singleton
public class DefaultNexusTimeline
extends ComponentSupport
implements NexusTimeline {
    private static final String TIMELINE_BASEDIR = "timeline";
    private final Timeline timeline;
    private final ApplicationConfiguration applicationConfiguration;

    @Inject
    public DefaultNexusTimeline(Timeline timeline, ApplicationConfiguration applicationConfiguration) {
        this.timeline = (Timeline)Preconditions.checkNotNull((Object)timeline);
        this.applicationConfiguration = (ApplicationConfiguration)Preconditions.checkNotNull((Object)applicationConfiguration);
        try {
            this.log.info("Initializing Nexus Timeline...");
            this.moveLegacyTimeline();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to move legacy Timeline!", e);
        }
        try {
            this.log.info("Starting Nexus Timeline...");
            this.updateConfiguration();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to initialize Timeline!", e);
        }
    }

    @Override
    public void shutdown() {
        try {
            this.log.info("Stopping Nexus Timeline...");
            this.timeline.stop();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to cleanly stop Timeline!", e);
        }
    }

    private void moveLegacyTimeline() throws IOException {
        File timelineDir;
        File legacyIndexDir = timelineDir = this.applicationConfiguration.getWorkingDirectory(TIMELINE_BASEDIR);
        File newIndexDir = new File(timelineDir, "index");
        File[] legacyIndexFiles = legacyIndexDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isFile();
            }
        });
        if (legacyIndexFiles == null || legacyIndexFiles.length == 0) {
            return;
        }
        if (newIndexDir.exists() && newIndexDir.listFiles().length > 0) {
            return;
        }
        this.log.info("Moving legacy timeline index from '" + legacyIndexDir.getAbsolutePath() + "' to '" + newIndexDir.getAbsolutePath() + "'.");
        DirSupport.mkdir((Path)newIndexDir.toPath());
        for (File legacyIndexFile : legacyIndexFiles) {
            if (!Files.isRegularFile(legacyIndexFile.toPath(), new LinkOption[0])) continue;
            Files.move(legacyIndexFile.toPath(), new File(newIndexDir, legacyIndexFile.getName()).toPath(), new CopyOption[0]);
        }
    }

    private void updateConfiguration() throws IOException {
        TimelineConfiguration config = new TimelineConfiguration(this.applicationConfiguration.getWorkingDirectory(TIMELINE_BASEDIR));
        this.timeline.start(config);
    }

    @Override
    public void add(long timestamp, String type, String subType, Map<String, String> data) {
        this.timeline.add(new TimelineRecord(timestamp, type, subType, data));
    }

    @Override
    public void retrieve(int fromItem, int count, Set<String> types, Set<String> subtypes, Predicate<Entry> filter, TimelineCallback cb) {
        if (filter != null) {
            this.timeline.retrieve(fromItem, count, types, subtypes, new PredicateTimelineFilter(filter), cb);
        } else {
            this.timeline.retrieve(fromItem, count, types, subtypes, null, cb);
        }
    }

    @Override
    public void purgeOlderThan(int days) {
        this.timeline.purgeOlderThan(days);
    }
}

