/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rest.feeds.sources;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.feeds.SystemEvent;
import org.sonatype.nexus.rest.feeds.sources.AbstractSystemFeedSource;

@Named(value="systemRepositoryStatusChanges")
@Singleton
public class SystemRepositoryStatusChangesFeedSource
extends AbstractSystemFeedSource {
    public static final String CHANNEL_KEY = "systemRepositoryStatusChanges";

    @Override
    public List<SystemEvent> getEventList(Integer from, Integer count, Map<String, String> params) {
        return this.getFeedRecorder().getSystemEvents(new HashSet<String>(Arrays.asList("REPO_LSTATUS_CHANGES", "REPO_PSTATUS_CHANGES", "REPO_PSTATUS_AUTO_CHANGES")), from, count, null);
    }

    @Override
    public String getFeedKey() {
        return CHANNEL_KEY;
    }

    @Override
    public String getFeedName() {
        return this.getDescription();
    }

    @Override
    public String getDescription() {
        return "Repository Status Changes in Nexus (user interventions and automatic).";
    }

    @Override
    public String getTitle() {
        return "Repository Status Changes";
    }
}

