/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rest.feeds.sources;

import java.util.List;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.feeds.SystemEvent;
import org.sonatype.nexus.rest.feeds.sources.AbstractSystemFeedSource;

@Named(value="systemChanges")
@Singleton
public class SystemFeedSource
extends AbstractSystemFeedSource {
    public static final String CHANNEL_KEY = "systemChanges";

    @Override
    public List<SystemEvent> getEventList(Integer from, Integer count, Map<String, String> params) {
        return this.getFeedRecorder().getSystemEvents(null, from, count, null);
    }

    @Override
    public String getFeedKey() {
        return CHANNEL_KEY;
    }

    @Override
    public String getFeedName() {
        return this.getDescription();
    }

    @Override
    public String getDescription() {
        return "System changes in Nexus.";
    }

    @Override
    public String getTitle() {
        return "System changes";
    }
}

