/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rest.feeds.sources;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.feeds.NexusArtifactEvent;
import org.sonatype.nexus.feeds.RepositoryIdTimelineFilter;
import org.sonatype.nexus.rest.feeds.sources.AbstractNexusReleaseArtifactEventFeedSource;

@Named(value="recentlyChangedReleaseArtifacts")
@Singleton
public class RecentChangedReleaseArtifactFeedSource
extends AbstractNexusReleaseArtifactEventFeedSource {
    public static final String CHANNEL_KEY = "recentlyChangedReleaseArtifacts";

    @Override
    public String getFeedKey() {
        return CHANNEL_KEY;
    }

    @Override
    public String getFeedName() {
        return this.getDescription();
    }

    @Override
    public String getDescription() {
        return "Recent release artifact storage changes in all Nexus repositories (caches, deployments, deletions).";
    }

    @Override
    public List<NexusArtifactEvent> getEventList(Integer from, Integer count, Map<String, String> params) {
        Set<String> repositoryIds = this.getRepoIdsFromParams(params);
        RepositoryIdTimelineFilter filter = repositoryIds == null || repositoryIds.isEmpty() ? null : new RepositoryIdTimelineFilter(repositoryIds);
        return this.getFeedRecorder().getNexusArtifectEvents(new HashSet<String>(Arrays.asList("cached", "deployed", "deleted")), from, count, filter);
    }

    @Override
    public String getTitle() {
        return "Recent release artifact storage changes";
    }
}

