/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rest.feeds.sources;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.feeds.NexusArtifactEvent;
import org.sonatype.nexus.feeds.RepositoryIdTimelineFilter;
import org.sonatype.nexus.rest.feeds.sources.AbstractNexusItemEventFeedSource;
import org.sonatype.nexus.rest.feeds.sources.SyndEntryBuilder;

@Named(value="recentlyCachedOrDeployedFiles")
@Singleton
public class RecentCachedOrDeployedFileFeedSource
extends AbstractNexusItemEventFeedSource {
    private final SyndEntryBuilder<NexusArtifactEvent> entryBuilder;
    public static final String CHANNEL_KEY = "recentlyCachedOrDeployedFiles";

    @Inject
    public RecentCachedOrDeployedFileFeedSource(@Named(value="file") SyndEntryBuilder<NexusArtifactEvent> entryBuilder) {
        this.entryBuilder = entryBuilder;
    }

    @Override
    public String getFeedKey() {
        return CHANNEL_KEY;
    }

    @Override
    public String getFeedName() {
        return this.getDescription();
    }

    @Override
    public String getDescription() {
        return "New files in all Nexus repositories (cached or deployed).";
    }

    @Override
    public List<NexusArtifactEvent> getEventList(Integer from, Integer count, Map<String, String> params) {
        Set<String> repositoryIds = this.getRepoIdsFromParams(params);
        RepositoryIdTimelineFilter filter = repositoryIds == null || repositoryIds.isEmpty() ? null : new RepositoryIdTimelineFilter(repositoryIds);
        return this.getFeedRecorder().getNexusArtifectEvents(new HashSet<String>(Arrays.asList("cached", "deployed")), from, count, filter);
    }

    @Override
    public String getTitle() {
        return "New files";
    }

    @Override
    public SyndEntryBuilder<NexusArtifactEvent> getSyndEntryBuilder(NexusArtifactEvent event) {
        return this.entryBuilder;
    }
}

