/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rest.feeds.sources;

import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.feeds.NexusArtifactEvent;
import org.sonatype.nexus.proxy.maven.gav.Gav;
import org.sonatype.nexus.rest.feeds.sources.AbstractNexusItemEventEntryBuilder;

@Named(value="file")
@Singleton
public class NexusFileEventEntryBuilder
extends AbstractNexusItemEventEntryBuilder {
    @Override
    protected String buildTitle(NexusArtifactEvent event) {
        return this.buildFileName(event);
    }

    private String buildFileName(NexusArtifactEvent event) {
        return this.buildFilePath(event).substring(this.buildFilePath(event).lastIndexOf("/") + 1);
    }

    private String buildFilePath(NexusArtifactEvent event) {
        return event.getNexusItemInfo().getPath();
    }

    @Override
    protected String buildDescriptionMsgItem(NexusArtifactEvent event) {
        StringBuilder msg = new StringBuilder();
        msg.append("The file '");
        msg.append(this.buildFileName(event));
        msg.append("' in repository '");
        msg.append(this.getRepositoryName(event));
        msg.append("' with path '");
        msg.append(this.buildFilePath(event));
        msg.append("'");
        return msg.toString();
    }

    @Override
    public boolean shouldBuildEntry(NexusArtifactEvent event) {
        if (!super.shouldBuildEntry(event)) {
            return false;
        }
        Gav gav = this.buildGAV(event);
        if (gav != null && (gav.isHash() || gav.isSignature())) {
            return false;
        }
        String path = event.getNexusItemInfo().getPath();
        return !path.contains("maven-metadata.xml");
    }
}

