/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rest.feeds.sources;

import javax.inject.Named;
import javax.inject.Singleton;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.nexus.feeds.NexusArtifactEvent;
import org.sonatype.nexus.proxy.maven.gav.Gav;
import org.sonatype.nexus.rest.feeds.sources.AbstractNexusItemEventEntryBuilder;

@Named(value="artifact")
@Singleton
public class NexusArtifactEventEntryBuilder
extends AbstractNexusItemEventEntryBuilder {
    @Override
    protected String buildTitle(NexusArtifactEvent event) {
        return this.getGAVString(event);
    }

    @Override
    protected String buildDescriptionMsgItem(NexusArtifactEvent event) {
        StringBuilder msg = new StringBuilder();
        msg.append("The artifact '");
        msg.append(this.getGAVString(event));
        msg.append("' in repository '");
        msg.append(this.getRepositoryName(event));
        msg.append("'");
        return msg.toString();
    }

    private String getGAVString(NexusArtifactEvent event) {
        if (event.getNexusItemInfo() == null) {
            return "unknown:unknown:unknown";
        }
        Gav gav = this.buildGAV(event);
        if (gav == null) {
            return event.getNexusItemInfo().getPath();
        }
        StringBuilder result = new StringBuilder(gav.getGroupId()).append(":").append(gav.getArtifactId()).append(":").append(gav.getVersion() != null ? gav.getVersion() : "unknown");
        if (gav.getClassifier() != null) {
            result.append(":").append(gav.getClassifier());
        }
        return result.toString();
    }

    @Override
    public boolean shouldBuildEntry(NexusArtifactEvent event) {
        if (!super.shouldBuildEntry(event)) {
            return false;
        }
        Gav gav = this.buildGAV(event);
        if (gav == null) {
            return false;
        }
        if (gav.isHash() || gav.isSignature()) {
            return false;
        }
        if ("pom".equalsIgnoreCase(gav.getExtension())) {
            return true;
        }
        return !StringUtils.isEmpty((String)gav.getClassifier());
    }
}

