/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rest.feeds.sources;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.io.Closer;
import com.google.common.io.Files;
import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndContentImpl;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndEntryImpl;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndFeedImpl;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.restlet.data.MediaType;
import org.sonatype.nexus.log.LogManager;
import org.sonatype.nexus.rest.feeds.sources.AbstractFeedSource;

@Named(value="errorWarning")
@Singleton
public class ErrorWarningFeedSource
extends AbstractFeedSource {
    public static final String CHANNEL_KEY = "errorWarning";
    private static final List<String> LOGFILENAMES_TO_SCAN = Arrays.asList("nexus.log", "nexus.log.1");
    private final LogManager logManager;

    @Inject
    public ErrorWarningFeedSource(LogManager logManager) {
        this.logManager = (LogManager)Preconditions.checkNotNull((Object)logManager);
    }

    @Override
    public String getFeedKey() {
        return CHANNEL_KEY;
    }

    @Override
    public String getTitle() {
        return "Errors and Warnings";
    }

    @Override
    public String getDescription() {
        return "Errors and Warnings from Nexus log";
    }

    @Override
    public String getFeedName() {
        return this.getDescription();
    }

    @Override
    public SyndFeed getFeed(Integer from, Integer count, Map<String, String> params) throws IOException {
        String logFileName;
        File logFile;
        SyndFeedImpl feed = new SyndFeedImpl();
        feed.setTitle(this.getTitle());
        feed.setDescription(this.getDescription());
        feed.setAuthor(this.getNexusAuthor());
        feed.setPublishedDate(new Date());
        Iterable<String> logFilenamesToScan = this.getLogFilenamesToScan(params);
        int remainingCount = count != null ? count : 40;
        ArrayList entries = Lists.newArrayList();
        Iterator<String> iterator = logFilenamesToScan.iterator();
        while (iterator.hasNext() && (logFile = this.logManager.getLogFile(logFileName = iterator.next())) != null) {
            List<SyndEntry> logFileEntries = this.extractEntriesFromLogfile(logFile, remainingCount);
            remainingCount -= logFileEntries.size();
            entries.addAll(logFileEntries);
        }
        feed.setEntries((List)entries);
        return feed;
    }

    protected Iterable<String> getLogFilenamesToScan(Map<String, String> params) {
        String files;
        if (params.containsKey("fts") && !Strings.isNullOrEmpty((String)(files = params.get("fts")))) {
            return Splitter.on((char)',').omitEmptyStrings().split((CharSequence)files);
        }
        return LOGFILENAMES_TO_SCAN;
    }

    protected String getNexusAuthor() {
        return "Nexus " + this.getApplicationStatusSource().getSystemStatus().getVersion();
    }

    protected List<SyndEntry> extractEntriesFromLogfile(File logFile, int entriesToExtract) throws IOException {
        ArrayList entries = Lists.newArrayList();
        try (Closer closer = Closer.create();){
            BufferedReader reader = Files.newReader((File)logFile, (Charset)Charset.forName("UTF-8"));
            String logLine = reader.readLine();
            while (logLine != null) {
                if (logLine.contains(" WARN ") || logLine.contains(" ERROR ")) {
                    SyndEntryImpl entry = new SyndEntryImpl();
                    entry.setPublishedDate(new Date());
                    entry.setAuthor(this.getNexusAuthor());
                    entry.setLink("/");
                    if (logLine.contains(" ERROR ")) {
                        entry.setTitle("Error");
                    } else if (logLine.contains(" WARN ")) {
                        entry.setTitle("Warning");
                    }
                    StringBuilder contentValue = new StringBuilder();
                    contentValue.append(logLine);
                    SyndContentImpl content = new SyndContentImpl();
                    content.setType(MediaType.TEXT_PLAIN.toString());
                    content.setValue(contentValue.toString());
                    entry.setDescription((SyndContent)content);
                    entries.add(entry);
                    if (entries.size() > entriesToExtract) {
                        entries.remove(0);
                    }
                }
                logLine = reader.readLine();
            }
        }
        return Lists.reverse((List)entries);
    }
}

