/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rest.feeds.sources;

import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndContentImpl;
import com.sun.syndication.feed.synd.SyndEntryImpl;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndFeedImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.restlet.data.MediaType;
import org.sonatype.nexus.feeds.AuthcAuthzEvent;
import org.sonatype.nexus.rest.feeds.sources.AbstractFeedSource;

@Named(value="authcAuthz")
@Singleton
public class AuthcAuthzFeedSource
extends AbstractFeedSource {
    public static final String CHANNEL_KEY = "authcAuthz";

    @Override
    public String getFeedKey() {
        return CHANNEL_KEY;
    }

    @Override
    public String getFeedName() {
        return this.getDescription();
    }

    @Override
    public String getTitle() {
        return "Authentication and Authorization";
    }

    @Override
    public String getDescription() {
        return "Authentication and Authorization Events";
    }

    @Override
    public SyndFeed getFeed(Integer from, Integer count, Map<String, String> params) throws IOException {
        List<AuthcAuthzEvent> items = this.getFeedRecorder().getAuthcAuthzEvents(null, from, count, null);
        SyndFeedImpl feed = new SyndFeedImpl();
        feed.setTitle(this.getTitle());
        feed.setDescription(this.getDescription());
        feed.setAuthor("Nexus " + this.getApplicationStatusSource().getSystemStatus().getVersion());
        feed.setPublishedDate(new Date());
        ArrayList<SyndEntryImpl> entries = new ArrayList<SyndEntryImpl>(items.size());
        for (AuthcAuthzEvent item : items) {
            SyndEntryImpl entry = new SyndEntryImpl();
            if ("AUTHC".equals(item.getAction())) {
                entry.setTitle("Authentication");
            } else if ("AUTHZ".equals(item.getAction())) {
                entry.setTitle("Authorization");
            } else {
                entry.setTitle(item.getAction());
            }
            SyndContentImpl content = new SyndContentImpl();
            content.setType(MediaType.TEXT_PLAIN.toString());
            content.setValue(item.getMessage());
            entry.setPublishedDate(item.getEventDate());
            entry.setAuthor(feed.getAuthor());
            entry.setLink("/");
            entry.setDescription((SyndContent)content);
            entries.add(entry);
        }
        feed.setEntries(entries);
        return feed;
    }
}

