/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rest.feeds.sources;

import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndContentImpl;
import com.sun.syndication.feed.synd.SyndEntryImpl;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndFeedImpl;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.restlet.data.MediaType;
import org.sonatype.nexus.feeds.SystemEvent;
import org.sonatype.nexus.rest.feeds.sources.AbstractFeedSource;

public abstract class AbstractSystemFeedSource
extends AbstractFeedSource {
    public abstract List<SystemEvent> getEventList(Integer var1, Integer var2, Map<String, String> var3);

    @Override
    public SyndFeed getFeed(Integer from, Integer count, Map<String, String> params) {
        List<SystemEvent> items = this.getEventList(from, count, params);
        SyndFeedImpl feed = new SyndFeedImpl();
        feed.setTitle(this.getTitle());
        feed.setDescription(this.getDescription());
        feed.setAuthor("Nexus " + this.getApplicationStatusSource().getSystemStatus().getVersion());
        feed.setPublishedDate(new Date());
        ArrayList<SyndEntryImpl> entries = new ArrayList<SyndEntryImpl>(items.size());
        SyndEntryImpl entry = null;
        SyndContentImpl content = null;
        String username = null;
        String ipAddress = null;
        for (SystemEvent item : items) {
            username = item.getEventContext().containsKey("request.user") ? (String)item.getEventContext().get("request.user") : null;
            ipAddress = item.getEventContext().containsKey("request.address") ? (String)item.getEventContext().get("request.address") : null;
            StringBuilder msg = new StringBuilder(item.getMessage()).append(". ");
            if (username != null) {
                msg.append(" It was initiated by a request from user ").append(username).append(".");
            }
            if (ipAddress != null) {
                msg.append(" The request was originated from IP address ").append(ipAddress).append(".");
            }
            entry = new SyndEntryImpl();
            if ("BOOT".equals(item.getAction())) {
                entry.setTitle("Booting");
            } else if ("CONFIG".equals(item.getAction())) {
                entry.setTitle("Configuration change");
            } else if ("REPO_LSTATUS_CHANGES".equals(item.getAction())) {
                entry.setTitle("Repository local status change");
            } else if ("REPO_PSTATUS_CHANGES".equals(item.getAction())) {
                entry.setTitle("Repository proxy mode change");
            } else if ("REPO_PSTATUS_AUTO_CHANGES".equals(item.getAction())) {
                entry.setTitle("Repository proxy mode change (user intervention may be needed!)");
            } else if ("REINDEX".equals(item.getAction())) {
                entry.setTitle("Reindexing");
            } else if ("PUBLISHINDEX".equals(item.getAction())) {
                entry.setTitle("Publishing indexes");
            } else if ("DOWNLOADINDEX".equals(item.getAction())) {
                entry.setTitle("Downloading Indexes");
            } else if ("OPTIMIZE_INDEX".equals(item.getAction())) {
                entry.setTitle("Optimizing Indexes");
            } else if ("PUBLISHINDEX".equals(item.getAction())) {
                entry.setTitle("Publishing Indexes");
            } else if ("REBUILDATTRIBUTES".equals(item.getAction())) {
                entry.setTitle("Rebuilding attributes");
            } else if ("TL_PURGE".equals(item.getAction())) {
                entry.setTitle("Timeline purge");
            } else if ("EXPIRE_CACHE".equals(item.getAction())) {
                entry.setTitle("Expiring caches");
            } else if ("EVICT_UNUSED_PROXIED_ITEMS".equals(item.getAction())) {
                entry.setTitle("Evicting unused proxied items");
            } else if ("REMOVESNAPSHOTS".equals(item.getAction())) {
                entry.setTitle("Removing snapshots");
            } else if ("REMOVE_REPO_FOLDER".equals(item.getAction())) {
                entry.setTitle("Removing repository folder");
            } else if ("EMPTY_TRASH".equals(item.getAction())) {
                entry.setTitle("Emptying Trash");
            } else if ("SYNC_SHADOW".equals(item.getAction())) {
                entry.setTitle("Synchronizing Shadow Repository");
            } else if ("REBUILD_MAVEN_METADATA".equals(item.getAction())) {
                entry.setTitle("Rebuilding maven metadata files");
            } else {
                entry.setTitle(item.getAction());
            }
            content = new SyndContentImpl();
            content.setType(MediaType.TEXT_PLAIN.toString());
            content.setValue(msg.toString());
            entry.setPublishedDate(item.getEventDate());
            entry.setAuthor(feed.getAuthor());
            entry.setLink("/");
            entry.setDescription((SyndContent)content);
            entries.add(entry);
        }
        feed.setEntries(entries);
        return feed;
    }
}

