/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rest.feeds.sources;

import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndFeedImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.nexus.feeds.NexusArtifactEvent;
import org.sonatype.nexus.rest.feeds.sources.AbstractFeedSource;
import org.sonatype.nexus.rest.feeds.sources.SyndEntryBuilder;

public abstract class AbstractNexusItemEventFeedSource
extends AbstractFeedSource {
    public abstract List<NexusArtifactEvent> getEventList(Integer var1, Integer var2, Map<String, String> var3);

    public abstract SyndEntryBuilder<NexusArtifactEvent> getSyndEntryBuilder(NexusArtifactEvent var1);

    @Override
    public SyndFeed getFeed(Integer from, Integer count, Map<String, String> params) {
        SyndFeedImpl feed = this.createFeed();
        List<NexusArtifactEvent> events = this.getEventList(from, count, params);
        ArrayList<SyndEntry> entries = new ArrayList<SyndEntry>(events.size());
        for (NexusArtifactEvent event : events) {
            SyndEntryBuilder<NexusArtifactEvent> entryBuilder = this.getSyndEntryBuilder(event);
            if (!entryBuilder.shouldBuildEntry(event)) continue;
            entries.add(this.getSyndEntryBuilder(event).buildEntry(event));
        }
        feed.setEntries(entries);
        return feed;
    }

    private SyndFeedImpl createFeed() {
        SyndFeedImpl feed = new SyndFeedImpl();
        feed.setTitle(this.getTitle());
        feed.setDescription(this.getDescription());
        feed.setAuthor("Nexus " + this.getApplicationStatusSource().getSystemStatus().getVersion());
        feed.setPublishedDate(new Date());
        return feed;
    }

    protected Set<String> getRepoIdsFromParams(Map<String, String> params) {
        if (params != null && params.containsKey("r")) {
            HashSet<String> result = new HashSet<String>();
            String value = params.get("r");
            if (value.contains(",")) {
                String[] values = StringUtils.split((String)value, (String)",");
                result.addAll(Arrays.asList(values));
            } else {
                result.add(value);
            }
            return result;
        }
        return null;
    }
}

