/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rest.feeds.sources;

import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndContentImpl;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndEntryImpl;
import java.util.Date;
import javax.inject.Inject;
import org.restlet.data.MediaType;
import org.sonatype.nexus.feeds.NexusArtifactEvent;
import org.sonatype.nexus.proxy.NoSuchRepositoryException;
import org.sonatype.nexus.proxy.maven.MavenRepository;
import org.sonatype.nexus.proxy.maven.gav.Gav;
import org.sonatype.nexus.proxy.registry.RepositoryRegistry;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.rest.feeds.sources.SyndEntryBuilder;
import org.sonatype.sisu.goodies.common.ComponentSupport;

public abstract class AbstractNexusItemEventEntryBuilder
extends ComponentSupport
implements SyndEntryBuilder<NexusArtifactEvent> {
    private RepositoryRegistry repositoryRegistry;

    @Inject
    public void setRepositoryRegistry(RepositoryRegistry repositoryRegistry) {
        this.repositoryRegistry = repositoryRegistry;
    }

    protected RepositoryRegistry getRepositoryRegistry() {
        return this.repositoryRegistry;
    }

    @Override
    public SyndEntry buildEntry(NexusArtifactEvent event) {
        SyndEntryImpl entry = new SyndEntryImpl();
        entry.setTitle(this.buildTitle(event));
        entry.setLink(this.buildLink(event));
        entry.setPublishedDate(this.buildPublishDate(event));
        entry.setAuthor(this.buildAuthor(event));
        entry.setDescription(this.buildDescription(event));
        return entry;
    }

    protected String buildTitle(NexusArtifactEvent event) {
        return event.getAction();
    }

    protected String buildLink(NexusArtifactEvent event) {
        return "content/repositories/" + event.getNexusItemInfo().getRepositoryId() + event.getNexusItemInfo().getPath();
    }

    protected Date buildPublishDate(NexusArtifactEvent event) {
        return event.getEventDate();
    }

    protected String buildAuthor(NexusArtifactEvent event) {
        if (event.getEventContext().containsKey("request.user")) {
            return (String)event.getEventContext().get("request.user");
        }
        return null;
    }

    protected SyndContent buildDescription(NexusArtifactEvent event) {
        SyndContentImpl content = new SyndContentImpl();
        content.setType(MediaType.TEXT_PLAIN.toString());
        StringBuilder msg = new StringBuilder();
        if (event.getMessage() != null) {
            msg.append(event.getMessage());
            msg.append(' ');
        }
        msg.append(this.buildDescriptionMsgItem(event));
        msg.append(this.buildDescriptionMsgAction(event));
        msg.append(this.buildDescriptionMsgAuthor(event));
        msg.append(this.buildDescriptionMsgAddress(event));
        content.setValue(msg.toString());
        return content;
    }

    protected String getRepositoryName(NexusArtifactEvent event) {
        String repoId = event.getNexusItemInfo().getRepositoryId();
        try {
            Repository repository = this.getRepositoryRegistry().getRepository(repoId);
            return repository.getName();
        }
        catch (NoSuchRepositoryException e) {
            return repoId;
        }
    }

    protected abstract String buildDescriptionMsgItem(NexusArtifactEvent var1);

    protected String buildDescriptionMsgAction(NexusArtifactEvent event) {
        StringBuilder msg = new StringBuilder(" was ");
        if ("cached".equals(event.getAction())) {
            msg.append("cached from remote URL ").append(event.getNexusItemInfo().getRemoteUrl()).append(".");
        } else if ("deployed".equals(event.getAction())) {
            msg.append("deployed.");
        } else if ("deleted".equals(event.getAction())) {
            msg.append("deleted.");
        } else if ("retrieved".equals(event.getAction())) {
            msg.append("served downstream.");
        } else if ("broken".equals(event.getAction())) {
            msg.append("broken.");
            if (event.getMessage() != null) {
                msg.append(" Details: \n");
                msg.append(event.getMessage());
                msg.append("\n");
            }
        } else if ("brokenWRC".equals(event.getAction())) {
            msg.append("proxied, and the remote repository contains wrong checksum for it.");
            if (event.getMessage() != null) {
                msg.append(" Details: \n");
                msg.append(event.getMessage());
                msg.append("\n");
            }
        }
        return msg.toString();
    }

    protected String buildDescriptionMsgAuthor(NexusArtifactEvent event) {
        String author = this.buildAuthor(event);
        if (author != null) {
            return "Action was initiated by user \"" + author + "\".\n";
        }
        return "";
    }

    protected String buildDescriptionMsgAddress(NexusArtifactEvent event) {
        if (event.getEventContext().containsKey("request.address")) {
            return "Request originated from IP address " + (String)event.getEventContext().get("request.address") + ".\n";
        }
        return "";
    }

    protected Gav buildGAV(NexusArtifactEvent event) {
        if (event.getNexusItemInfo() == null) {
            return null;
        }
        try {
            Repository repo = this.getRepositoryRegistry().getRepository(event.getNexusItemInfo().getRepositoryId());
            if (MavenRepository.class.isAssignableFrom(repo.getClass())) {
                return ((MavenRepository)repo).getGavCalculator().pathToGav(event.getNexusItemInfo().getPath());
            }
            return null;
        }
        catch (NoSuchRepositoryException e) {
            this.log.debug("Feed entry contained invalid repository id " + event.getNexusItemInfo().getRepositoryId(), (Throwable)e);
            return null;
        }
    }

    @Override
    public boolean shouldBuildEntry(NexusArtifactEvent event) {
        return true;
    }
}

