/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rest.feeds;

import com.google.common.base.Preconditions;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.codehaus.enunciate.contract.jaxrs.ResourceMethodSignature;
import org.restlet.Context;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.resource.ResourceException;
import org.restlet.resource.Variant;
import org.sonatype.nexus.rest.AbstractNexusPlexusResource;
import org.sonatype.nexus.rest.feeds.sources.FeedSource;
import org.sonatype.nexus.rest.model.FeedListResource;
import org.sonatype.nexus.rest.model.FeedListResourceResponse;
import org.sonatype.plexus.rest.resource.PathProtectionDescriptor;
import org.sonatype.plexus.rest.resource.PlexusResource;

@Path(value="/feeds")
@Produces(value={"application/xml", "application/json"})
@Named
@Singleton
public class FeedsListPlexusResource
extends AbstractNexusPlexusResource {
    public static final String RESOURCE_URI = "/feeds";
    private final List<FeedSource> feeds;

    @Inject
    public FeedsListPlexusResource(List<FeedSource> feeds) {
        this.feeds = (List)Preconditions.checkNotNull(feeds);
    }

    public Object getPayloadInstance() {
        return null;
    }

    public String getResourceUri() {
        return RESOURCE_URI;
    }

    public PathProtectionDescriptor getResourceProtection() {
        return new PathProtectionDescriptor(this.getResourceUri(), "authcBasic,perms[nexus:feeds]");
    }

    @GET
    @ResourceMethodSignature(output=FeedListResourceResponse.class)
    public Object get(Context context, Request req, Response res, Variant variant) throws ResourceException {
        FeedListResourceResponse response = new FeedListResourceResponse();
        List<FeedSource> sources = this.feeds;
        for (FeedSource source : sources) {
            FeedListResource resource = new FeedListResource();
            resource.setResourceURI(this.createChildReference(req, (PlexusResource)this, source.getFeedKey()).toString());
            resource.setName(source.getFeedName());
            response.addData(resource);
        }
        return response;
    }
}

