/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rest.feeds;

import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndFeed;
import java.io.IOException;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.codehaus.enunciate.contract.jaxrs.ResourceMethodSignature;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.restlet.Context;
import org.restlet.data.Request;
import org.sonatype.nexus.rest.feeds.AbstractFeedPlexusResource;
import org.sonatype.plexus.rest.resource.PathProtectionDescriptor;

@Path(value="/feeds/{feedKey}")
@Produces(value={"application/rss+xml", "application/atom+xml", "text/xml"})
@Named
@Singleton
public class FeedPlexusResource
extends AbstractFeedPlexusResource {
    public static final String FEED_KEY = "feedKey";

    public Object getPayloadInstance() {
        return null;
    }

    public String getResourceUri() {
        return "/feeds/{feedKey}";
    }

    @Override
    protected String getChannelKey(Request request) {
        return (String)request.getAttributes().get(FEED_KEY);
    }

    public PathProtectionDescriptor getResourceProtection() {
        return new PathProtectionDescriptor("/feeds/*", "authcBasic,perms[nexus:feeds]");
    }

    @Override
    @GET
    @ResourceMethodSignature(pathParams={@PathParam(value="feedKey")}, queryParams={@QueryParam(value="from"), @QueryParam(value="count"), @QueryParam(value="r")}, output=String.class)
    protected SyndFeed getFeed(Context context, Request request, String channelKey, Integer from, Integer count, Map<String, String> params) throws IOException, ComponentLookupException {
        SyndFeed feed = super.getFeed(context, request, channelKey, from, count, params);
        if (feed.getLink() != null && !feed.getLink().startsWith("http")) {
            if (feed.getLink().startsWith("/")) {
                feed.setLink(feed.getLink().substring(1));
            }
            feed.setLink(this.createRootReference(request, feed.getLink()).toString());
        }
        for (SyndEntry entry : feed.getEntries()) {
            if (entry.getLink() == null || entry.getLink().startsWith("http")) continue;
            if (entry.getLink().startsWith("/")) {
                entry.setLink(entry.getLink().substring(1));
            }
            entry.setLink(this.createRootReference(request, entry.getLink()).toString());
        }
        return feed;
    }
}

