/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rest.feeds;

import com.sun.syndication.feed.synd.SyndFeed;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.restlet.Context;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.ResourceException;
import org.restlet.resource.Variant;
import org.sonatype.nexus.rest.AbstractNexusPlexusResource;
import org.sonatype.nexus.rest.feeds.FeedRepresentation;
import org.sonatype.nexus.rest.feeds.sources.FeedSource;

public abstract class AbstractFeedPlexusResource
extends AbstractNexusPlexusResource {
    private static final String RSS_2_0 = "rss_2.0";
    private static final String ATOM_1_0 = "atom_1.0";
    private Map<String, FeedSource> feeds;

    @Inject
    public void setFeeds(Map<String, FeedSource> feeds) {
        this.feeds = feeds;
    }

    public List<Variant> getVariants() {
        List result = super.getVariants();
        result.add(new Variant(FeedRepresentation.RSS_MEDIA_TYPE));
        result.add(new Variant(FeedRepresentation.ATOM_MEDIA_TYPE));
        result.add(new Variant(MediaType.TEXT_XML));
        return result;
    }

    public Object get(Context context, Request request, Response response, Variant variant) throws ResourceException {
        MediaType mediaType = variant.getMediaType();
        Form params = request.getResourceRef().getQueryAsForm();
        Integer from = null;
        Integer count = null;
        try {
            if (params.getFirstValue("from") != null) {
                from = Integer.valueOf(params.getFirstValue("from"));
            }
            if (params.getFirstValue("count") != null) {
                count = Integer.valueOf(params.getFirstValue("count"));
            }
        }
        catch (NumberFormatException e) {
            throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "The 'from' and 'count' parameters must be numbers!", (Throwable)e);
        }
        Map par = params.getValuesMap();
        try {
            if (!MediaType.APPLICATION_JSON.equals((Object)mediaType, true)) {
                SyndFeed feed = this.getFeed(context, request, this.getChannelKey(request), from, count, par);
                if (FeedRepresentation.ATOM_MEDIA_TYPE.equals((Object)mediaType, true)) {
                    feed.setFeedType(ATOM_1_0);
                } else {
                    feed.setFeedType(RSS_2_0);
                    if (!MediaType.TEXT_XML.equals((Object)mediaType, true)) {
                        mediaType = FeedRepresentation.RSS_MEDIA_TYPE;
                    }
                }
                feed.setLink(request.getResourceRef().toString());
                FeedRepresentation representation = new FeedRepresentation(mediaType, feed);
                return representation;
            }
            throw new ResourceException(Status.SERVER_ERROR_NOT_IMPLEMENTED, "Not implemented.");
        }
        catch (ComponentLookupException e) {
            throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND, "Channel source not found!", (Throwable)e);
        }
        catch (IOException e) {
            throw new ResourceException(Status.SERVER_ERROR_INTERNAL, (Throwable)e);
        }
    }

    protected SyndFeed getFeed(Context context, Request request, String channelKey, Integer from, Integer count, Map<String, String> params) throws IOException, ComponentLookupException {
        FeedSource src = this.feeds.get(channelKey);
        if (src != null) {
            return src.getFeed(from, count, params);
        }
        throw new ComponentLookupException("Feed with key '" + channelKey + "' not found.", "FeedSource", channelKey);
    }

    protected abstract String getChannelKey(Request var1);
}

