/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.feeds.record;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.events.Asynchronous;
import org.sonatype.nexus.events.Event;
import org.sonatype.nexus.events.EventSubscriber;
import org.sonatype.nexus.feeds.record.AbstractFeedRecorderEventInspector;
import org.sonatype.nexus.proxy.NoSuchRepositoryException;
import org.sonatype.nexus.proxy.events.RepositoryConfigurationUpdatedEvent;
import org.sonatype.nexus.proxy.events.RepositoryRegistryEventAdd;
import org.sonatype.nexus.proxy.events.RepositoryRegistryEventRemove;
import org.sonatype.nexus.proxy.events.RepositoryRegistryRepositoryEvent;
import org.sonatype.nexus.proxy.registry.RepositoryRegistry;
import org.sonatype.nexus.proxy.repository.GroupRepository;
import org.sonatype.nexus.proxy.repository.HostedRepository;
import org.sonatype.nexus.proxy.repository.ProxyRepository;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.proxy.repository.ShadowRepository;

@Named
@Singleton
public class RepositoryRegistryRepositoryEventInspector
extends AbstractFeedRecorderEventInspector
implements EventSubscriber,
Asynchronous {
    private final RepositoryRegistry repoRegistry;

    @Inject
    public RepositoryRegistryRepositoryEventInspector(RepositoryRegistry repoRegistry) {
        this.repoRegistry = (RepositoryRegistry)Preconditions.checkNotNull((Object)repoRegistry);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(RepositoryRegistryRepositoryEvent e) {
        this.inspect((Event<?>)e);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(RepositoryConfigurationUpdatedEvent e) {
        this.inspect((Event<?>)e);
    }

    protected void inspect(Event<?> evt) {
        if (!this.isNexusStarted()) {
            return;
        }
        Repository repository = null;
        repository = evt instanceof RepositoryRegistryRepositoryEvent ? ((RepositoryRegistryRepositoryEvent)evt).getRepository() : ((RepositoryConfigurationUpdatedEvent)evt).getRepository();
        try {
            this.repoRegistry.getRepository(repository.getId());
            this.inspectForTimeline(evt, repository);
        }
        catch (NoSuchRepositoryException e) {
            this.log.debug("Attempted to handle repository that isn't yet in registry");
        }
    }

    private void inspectForTimeline(Event<?> evt, Repository repository) {
        StringBuilder sb = new StringBuilder();
        if (repository.getRepositoryKind().isFacetAvailable(GroupRepository.class)) {
            sb.append(" repository group ");
        } else {
            sb.append(" repository ");
        }
        sb.append(repository.getName());
        sb.append(" (ID=");
        sb.append(repository.getId());
        sb.append(") ");
        if (repository.getRepositoryKind().isFacetAvailable(ProxyRepository.class)) {
            sb.append(" as proxy repository for URL ");
            sb.append(((ProxyRepository)repository.adaptToFacet(ProxyRepository.class)).getRemoteUrl());
        } else if (repository.getRepositoryKind().isFacetAvailable(HostedRepository.class)) {
            sb.append(" as hosted repository");
        } else if (repository.getRepositoryKind().isFacetAvailable(ShadowRepository.class)) {
            sb.append(" as ");
            sb.append(repository.getClass().getName());
            sb.append(" virtual repository for ");
            sb.append(((ShadowRepository)repository.adaptToFacet(ShadowRepository.class)).getMasterRepository().getName());
            sb.append(" (ID=");
            sb.append(((ShadowRepository)repository.adaptToFacet(ShadowRepository.class)).getMasterRepository().getId());
            sb.append(") ");
        }
        sb.append(".");
        if (evt instanceof RepositoryRegistryEventAdd) {
            sb.insert(0, "Registered");
        } else if (evt instanceof RepositoryRegistryEventRemove) {
            sb.insert(0, "Unregistered");
        } else if (evt instanceof RepositoryConfigurationUpdatedEvent) {
            sb.insert(0, "Updated");
        }
        this.getFeedRecorder().addSystemEvent("CONFIG", sb.toString());
    }
}

