/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.feeds.record;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.events.Asynchronous;
import org.sonatype.nexus.events.EventSubscriber;
import org.sonatype.nexus.feeds.record.AbstractFeedRecorderEventInspector;
import org.sonatype.nexus.proxy.events.RepositoryEventProxyModeChanged;
import org.sonatype.nexus.proxy.repository.ProxyMode;

@Named
@Singleton
public class RepositoryEventProxyModeChangedInspector
extends AbstractFeedRecorderEventInspector
implements EventSubscriber,
Asynchronous {
    @Subscribe
    @AllowConcurrentEvents
    public void inspect(RepositoryEventProxyModeChanged evt) {
        RepositoryEventProxyModeChanged revt = evt;
        StringBuilder sb = new StringBuilder("The proxy mode of repository '");
        sb.append(revt.getRepository().getName());
        sb.append("' (ID='").append(revt.getRepository().getId()).append("') was set to ");
        if (ProxyMode.ALLOW.equals((Object)revt.getNewProxyMode())) {
            sb.append("Allow.");
        } else if (ProxyMode.BLOCKED_AUTO.equals((Object)revt.getNewProxyMode())) {
            sb.append("Blocked (auto).");
        } else if (ProxyMode.BLOCKED_MANUAL.equals((Object)revt.getNewProxyMode())) {
            sb.append("Blocked (by user).");
        } else {
            sb.append(revt.getRepository().getProxyMode().toString()).append(".");
        }
        sb.append(" The previous state was ");
        if (ProxyMode.ALLOW.equals((Object)revt.getOldProxyMode())) {
            sb.append("Allow.");
        } else if (ProxyMode.BLOCKED_AUTO.equals((Object)revt.getOldProxyMode())) {
            sb.append("Blocked (auto).");
        } else if (ProxyMode.BLOCKED_MANUAL.equals((Object)revt.getOldProxyMode())) {
            sb.append("Blocked (by user).");
        } else {
            sb.append(revt.getOldProxyMode().toString()).append(".");
        }
        if (revt.getCause() != null) {
            sb.append(" Last detected transport error: ").append(revt.getCause().getMessage());
        }
        this.getFeedRecorder().addSystemEvent("REPO_PSTATUS_CHANGES", sb.toString());
    }
}

