/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.feeds.record;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.events.Asynchronous;
import org.sonatype.nexus.events.EventSubscriber;
import org.sonatype.nexus.feeds.record.AbstractFeedRecorderEventInspector;
import org.sonatype.nexus.proxy.events.RepositoryEventLocalStatusChanged;
import org.sonatype.nexus.proxy.repository.LocalStatus;

@Named
@Singleton
public class RepositoryEventLocalStatusChangedInspector
extends AbstractFeedRecorderEventInspector
implements EventSubscriber,
Asynchronous {
    @Subscribe
    @AllowConcurrentEvents
    public void inspect(RepositoryEventLocalStatusChanged revt) {
        StringBuilder sb = new StringBuilder("The repository '");
        sb.append(revt.getRepository().getName());
        sb.append("' (ID='").append(revt.getRepository().getId()).append("') was put ");
        LocalStatus newStatus = revt.getNewLocalStatus();
        if (LocalStatus.IN_SERVICE.equals((Object)newStatus)) {
            sb.append("IN SERVICE.");
        } else if (LocalStatus.OUT_OF_SERVICE.equals((Object)newStatus)) {
            sb.append("OUT OF SERVICE.");
        } else {
            sb.append(revt.getRepository().getLocalStatus().toString()).append(".");
        }
        sb.append(" The previous state was ");
        if (LocalStatus.IN_SERVICE.equals((Object)revt.getOldLocalStatus())) {
            sb.append("IN SERVICE.");
        } else if (LocalStatus.OUT_OF_SERVICE.equals((Object)revt.getOldLocalStatus())) {
            sb.append("OUT OF SERVICE.");
        } else {
            sb.append(revt.getOldLocalStatus().toString()).append(".");
        }
        this.getFeedRecorder().addSystemEvent("REPO_LSTATUS_CHANGES", sb.toString());
    }
}

