/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.feeds.record;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import java.lang.reflect.Method;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.events.EventSubscriber;
import org.sonatype.nexus.feeds.SystemProcess;
import org.sonatype.nexus.feeds.record.AbstractFeedRecorderEventInspector;
import org.sonatype.nexus.scheduling.AbstractNexusTask;
import org.sonatype.nexus.scheduling.NexusTask;
import org.sonatype.nexus.scheduling.events.NexusTaskEvent;
import org.sonatype.nexus.scheduling.events.NexusTaskEventStarted;
import org.sonatype.nexus.scheduling.events.NexusTaskEventStoppedCanceled;
import org.sonatype.nexus.scheduling.events.NexusTaskEventStoppedDone;
import org.sonatype.nexus.scheduling.events.NexusTaskEventStoppedFailed;

@Named
@Singleton
public class NexusTaskFeedEventInspector
extends AbstractFeedRecorderEventInspector
implements EventSubscriber {
    @Subscribe
    @AllowConcurrentEvents
    public void inspect(NexusTaskEvent evt) {
        if (evt instanceof NexusTaskEventStarted) {
            String action = this.getActionFromTask(((NexusTaskEventStarted)evt).getNexusTask());
            String message = this.getMessageFromTask(((NexusTaskEventStarted)evt).getNexusTask());
            SystemProcess prc = this.getFeedRecorder().systemProcessStarted(action, message);
            this.putSystemProcessFromEventContext((NexusTaskEventStarted)evt, prc);
        } else if (evt instanceof NexusTaskEventStoppedDone) {
            SystemProcess prc = this.getSystemProcessFromEventContext(((NexusTaskEventStoppedDone)evt).getStartedEvent());
            String message = this.getMessageFromTask(((NexusTaskEventStoppedDone)evt).getNexusTask());
            this.getFeedRecorder().systemProcessFinished(prc, message);
        } else if (evt instanceof NexusTaskEventStoppedCanceled) {
            SystemProcess prc = this.getSystemProcessFromEventContext(((NexusTaskEventStoppedCanceled)evt).getStartedEvent());
            String message = this.getMessageFromTask(((NexusTaskEventStoppedCanceled)evt).getNexusTask());
            this.getFeedRecorder().systemProcessCanceled(prc, message);
        } else if (evt instanceof NexusTaskEventStoppedFailed) {
            SystemProcess prc = this.getSystemProcessFromEventContext(((NexusTaskEventStoppedFailed)evt).getStartedEvent());
            this.getFeedRecorder().systemProcessBroken(prc, ((NexusTaskEventStoppedFailed)evt).getFailureCause());
        }
    }

    protected void putSystemProcessFromEventContext(NexusTaskEventStarted<?> evt, SystemProcess prc) {
        evt.getEventContext().put(SystemProcess.class.getName(), prc);
    }

    protected SystemProcess getSystemProcessFromEventContext(NexusTaskEventStarted<?> evt) {
        return (SystemProcess)evt.getEventContext().get(SystemProcess.class.getName());
    }

    protected String getActionFromTask(NexusTask<?> task) {
        if (task instanceof AbstractNexusTask) {
            try {
                Method getActionMethod = AbstractNexusTask.class.getDeclaredMethod("getAction", new Class[0]);
                getActionMethod.setAccessible(true);
                return (String)getActionMethod.invoke(task, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "UNKNOWN";
    }

    protected String getMessageFromTask(NexusTask<?> task) {
        if (task instanceof AbstractNexusTask) {
            try {
                Method getMessageMethod = AbstractNexusTask.class.getDeclaredMethod("getMessage", new Class[0]);
                getMessageMethod.setAccessible(true);
                return (String)getMessageMethod.invoke(task, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "UNKNOWN";
    }
}

