/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.feeds.record;

import com.google.common.eventbus.Subscribe;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.events.Event;
import org.sonatype.nexus.events.EventSubscriber;
import org.sonatype.nexus.feeds.record.AbstractFeedRecorderEventInspector;
import org.sonatype.nexus.proxy.events.NexusStartedEvent;
import org.sonatype.nexus.proxy.events.NexusStoppedEvent;

@Named
@Singleton
public class NexusBootEventInspector
extends AbstractFeedRecorderEventInspector
implements EventSubscriber {
    @Subscribe
    public void on(NexusStartedEvent e) {
        this.inspect((Event<?>)e);
    }

    @Subscribe
    public void on(NexusStoppedEvent e) {
        this.inspect((Event<?>)e);
    }

    protected void inspect(Event<?> evt) {
        if (evt instanceof NexusStartedEvent) {
            this.getFeedRecorder().addSystemEvent("BOOT", "Started Nexus (version " + this.getApplicationStatusSource().getSystemStatus().getVersion() + " " + this.getApplicationStatusSource().getSystemStatus().getEditionShort() + ")");
        } else if (evt instanceof NexusStoppedEvent) {
            this.getFeedRecorder().addSystemEvent("BOOT", "Stopping Nexus (version " + this.getApplicationStatusSource().getSystemStatus().getVersion() + " " + this.getApplicationStatusSource().getSystemStatus().getEditionShort() + ")");
            this.getFeedRecorder().shutdown();
        }
    }
}

